﻿using System;

namespace SOLID
{
    abstract class Customer : IDatabase, IDiscount
    {
        Int32 customerType;
        ILogger logger;

        public Customer(ILogger logger)
        {
            this.logger = logger;
        }

        public ILogger Logger
        {
            get { return logger; }
        }

        public Int32 CustomerType
        {
            get { return customerType; }
            set { customerType = value; }
        }

        public virtual void Add()
        {
            try
            {
                //Add to database
                //throw new Exception("Test exception!!");
            }
            catch (Exception ex)
            {
                logger.LogError(ex.Message);
            }
        }

        public abstract Double GetTotalDiscount(Double totalSales);
    }
}
