﻿using System;
using System.IO;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace CsharpSolutions
{
    class ConsoleReader : TextReader
    {
        RichTextBox tb;

        public ConsoleReader(RichTextBox tb)
        {
            this.tb = tb;
        }

        public override String ReadLine()
        {
            var task = new TaskCompletionSource<String>();
            var waiter = new FunctionBlocker();
            var buffer = tb.Text;
            EventHandler texthandler = (sender, ev) =>
            {
                if (tb.SelectionStart < buffer.Length || tb.Text.Length < buffer.Length)
                {
                    tb.Text = buffer;
                    tb.SelectionStart = buffer.Length;
                }
                else if (tb.Text.Length > buffer.Length && tb.Text.EndsWith(Environment.NewLine))
                {
                    buffer = tb.Text.Substring(buffer.Length, Math.Max(0, tb.Text.Length - buffer.Length - Environment.NewLine.Length));
                    waiter.Signal();
                }
            };
            tb.Focus();
            tb.TextChanged += texthandler;
            waiter.Wait();
            tb.TextChanged -= texthandler;
            return buffer;
        }
    }
}
