﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace CsharpSolutions
{
    public partial class Overview : Form
    {
        const int margin = 15;

        public Overview()
        {
            InitializeComponent();            
            GenerateButtons();
            AddConsole();
        }

        private void GenerateButtons()
        {
            var pos = new Point(margin, margin);
            var exercises = new Dictionary<String, Action>();

            exercises.Add("Aufgabe 1", CsharpSolutions.Exercises.Task01.Starter.DisplayUser);
            exercises.Add("Aufgabe 2", CsharpSolutions.Exercises.Task02.Countdown.Run);
            exercises.Add("Aufgabe 3", CsharpSolutions.Exercises.Task03.CurrencyConverter.Interaction);
            exercises.Add("Aufgabe 4", CsharpSolutions.Exercises.Task04.Calculator.Compute);
            exercises.Add("Aufgabe 5", CsharpSolutions.Exercises.Task05.PrimeNumbers.Computer);
            exercises.Add("Aufgabe 6", CsharpSolutions.Exercises.Task06.MySwap.TestSwap);
            exercises.Add("Aufgabe 7", CsharpSolutions.Exercises.Task07.NumberGuesser.Game);
            exercises.Add("Aufgabe 8", () => Console.WriteLine("The result of Integral(sin(x), x = 0 .. 5) = {0}.", CsharpSolutions.Exercises.Task08.Integrator.Integrate(0, 5, 1000, Math.Sin)));
            exercises.Add("Aufgabe 9", () => 
            { 
                var number = 12345; 
                var length = 0; 
                var result = CsharpSolutions.Exercises.Task09.DigitSum.Compute(12345, out length); 
                Console.WriteLine("Digit sum of {0} is {1} with {2} digits.", number, result, length);
            });
            exercises.Add("Aufgabe 15", CsharpSolutions.Exercises.Task15.PlotSample.Run);
            exercises.Add("Aufgabe 16", () => new CsharpSolutions.Exercises.Task16.FirstForm().Show());
            exercises.Add("Aufgabe 17", () => new CsharpSolutions.Exercises.Task17.Environment().Show());
            exercises.Add("Aufgabe 18", () => new CsharpSolutions.Exercises.Task18.ReactionSpeed().Show());
            exercises.Add("Aufgabe 19", () => new CsharpSolutions.Exercises.Task19.LinqQueries().Show());
            exercises.Add("Aufgabe 20", () => new CsharpSolutions.Exercises.Task20.MyForm().Show());
            exercises.Add("Aufgabe 21", () => new CsharpSolutions.Exercises.Task21.Communication().Show());
            exercises.Add("Aufgabe 22", () => new CsharpSolutions.Exercises.Task22.Form1().Show());
            exercises.Add("Aufgabe 23", CsharpSolutions.Exercises.Task23.Example.Showcase);
            exercises.Add("Aufgabe 24", CsharpSolutions.Exercises.Task24.Example.Showcase);
            exercises.Add("Aufgabe 25", () => new CsharpSolutions.Exercises.Task25.PictureViewer().Show());
            exercises.Add("Aufgabe 26", () => new CsharpSolutions.Exercises.Task26.MyNote().Show());
            exercises.Add("Aufgabe 27", CsharpSolutions.Exercises.Task27.SomeWebRequest.PerformWebRequest);
            exercises.Add("Aufgabe 28", () => new CsharpSolutions.Exercises.Task28.MyForm().Show());
            exercises.Add("Aufgabe 29", () => new CsharpSolutions.Exercises.Task29.MyPaint().Show());
            exercises.Add("Clear", () => Controls.Cast<Control>().OfType<TextBox>().First().ResetText());

            foreach (var exercise in exercises)
            {
                var bt = new Button();
                var f = exercise.Value;
                bt.Text = exercise.Key;
                bt.Click += (sender, e) => { f(); };
                bt.Location = pos;

                if (bt.Right + margin > Width)
                    bt.Location = new Point(margin, pos.Y + bt.Height + margin);

                Controls.Add(bt);
                pos = bt.Location + new Size(bt.Width + margin, 0);
            }
        }

        private void AddConsole()
        {
            var console = new RichTextBox();
            var writer = new ConsoleWriter(console);
            var reader = new ConsoleReader(console);
            console.Multiline = true;
            console.ScrollBars = RichTextBoxScrollBars.Vertical;
            console.BackColor = Color.Black;
            console.ForeColor = Color.LimeGreen;
            console.Font = new System.Drawing.Font("Consolas", 14f, FontStyle.Regular);
            console.Anchor = AnchorStyles.Bottom | AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
            console.Location = new Point(margin, Controls[Controls.Count - 1].Bottom +  margin);
            console.Size = new Size(Width - 3 * margin, Height - 50 - console.Location.Y);
            this.Controls.Add(console);
            Console.SetOut(writer);
            Console.SetIn(reader);
        }
    }
}
