#ifndef _ANALYSIS_H_
#define _ANALYSIS_H_

double getAverage(double* values, int n);
double getSquaredAverage(double* values, int n);
double getError(double average, double* values, int n);
void doAnalysis(double* values, int n, double* outAverage, double* outError);
double getJackknifeError(double average, double* values, int n);
double getJackknifeErrorWithBlocking(double average, double* values, int n, int nBlock);
double getBootstrapError(double average, double* values, int n, int nSamples, int nData);
double getAutocorrelationTime(double* values, int n);
double* getAutocorrelation(double* values, int n);

#endif