$(document).ready(function () {
	main_menue();

	//Funktion zum Faden zwischen den Kapiteln und zum Einblenden der Info-Dialoge 
	function pageTransition(from, to, title, message, whatchapt, username) {
		$('#'+from).fadeOut(function() {
			$('#'+to).fadeIn();
		});
		if (whatchapt == 'chap1' || whatchapt == 'chap2' || whatchapt == 'chap3') {
			$("#infoDialog").dialog({
				dialogClass: "no-close",
				autoOpen: false,
				resizable: false,
				height: "auto",
				width: 350,
				buttons: { "Ok": function () { 
												$(this).dialog("close");
												if(whatchapt == 'chap1') 
													chapter_one(username);
												if(whatchapt == 'chap2') 
													chapter_two();
												if(whatchapt == 'chap3') 
													chapter_three();
											 } },
				modal: true,
				title: title
			}).html(message);
			$("#infoDialog").dialog("open");
		}
	}

	/*----ANFANG Funktion "Hauptmenü"----*/
	function main_menue () {
		//Validierung der Namens-Eingabe
		$('.menueButton').attr("disabled", true);
		
		var usernameRegexPattern = new RegExp(/^[a-zäöüßA-ZÄÖÜ]{1,10}$/);
		var username = $('#user_name').val();
		var valid = usernameRegexPattern.test(username);
		
		if(valid) //Abfrage nötig für Fall "Game Over" und Name bleibt im Browser-Cache
			$('.menueButton').removeAttr("disabled");
		
		$('#user_name').on('keyup change', function(){
			username = $('#user_name').val();
			valid = usernameRegexPattern.test(username);
			if(valid) {
				$('.menueButton').removeAttr("disabled");
				$('#instructionUsername').hide();
			}
			else {
				$('.menueButton').attr("disabled", true);
				$('#instructionUsername').show();
			}                              
		});
	
		//Audio "Klick auf Menü-Buttons"
		$('.menueButton').click(function () {
			$('#audioMenue').get(0).play();
		});
	
		//Button "Start"
		$('#mbutton_start').click(function () {
			pageTransition('menue','prolog', '', '', '', '');	
			$('#audioProlog').get(0).play(); //Audio Hintergrundmelodie
			//Prolog Star-Wars-Animation
			$('#titlecontent').css({'-webkit-animation':'scroll 100s linear 2s infinite','-moz-animation':'scroll 100s linear 2s infinite','-ms-animation':'scroll 100s linear 2s infinite','-o-animation':'scroll 100s linear 2s infinite','animation':'scroll 100s linear 2s infinite'});
			
			//Prolog ausfaden lassen
			setTimeout(function(){
				$('#titles').fadeOut(4500);
			}, 20000);
			//nach 23sec. Chapter ONE zeigen
			setTimeout(function(){
				username = $('#user_name').val();
				pageTransition('prolog','chapter_one', 'Kapitel 1: Dialog', '<p>Finde den Klan-Meister!<br><br>Bewege dich nach links (A) oder nach rechts (D).</p>', 'chap1', username);
			}, 23000);	
		});
		//Button "Kapitel 1"
		$('#mbutton_chapter_one').click(function () {
			username = $('#user_name').val();
			pageTransition('menue','chapter_one', 'Kapitel 1: Dialog', '<p>Finde den Klan-Meister!<br><br>Bewege dich nach links (A) oder nach rechts (D).</p>', 'chap1', username);
		});
		//Button "Kapitel 2"
		$('#mbutton_chapter_two').click(function () {
			pageTransition('menue','chapter_two', 'Kapitel 2: Action-Adventure', '<p>Besiege die Drillinge!<br><br>Schieße mit der Leertaste.<br>Bewege dabei dein Ufo nach oben (W) und unten (S), um auszuweichen.<p>', 'chap2', '');
		});
		//Button "Kapitel 3"
		$('#mbutton_chapter_three').click(function () {
			pageTransition('menue','chapter_three', 'Kapitel 3: Hidden Object', '<p>Du hast die Entführer zwar besiegt, doch deine Freundin ist noch immer gefangen.<br><br>Finde den Schlüssel!<br><br>Ziehe ihn dann mit der Maus zum Käfig.<br>Leichte Gegenstände kannst du bewegen, mit schweren Dingen kannst du teilweise über Klicks interagieren.</p>', 'chap3', '');
		});
	}
/*----ENDE Funktion "Hauptmenü"----*/
/*----ANFANG Funktion "Kapitel 1"----*/	
	function chapter_one(username) {
		$('#audioChap1Background').get(0).play(); //Audio Hintergrundmelodie
		
		var meeting = false;
		var event_repeat_right = false;
		var event_repeat_left = false;
		
		$(document).keydown(function (eingabe) {
		if (meeting)
			return;
		if (eingabe.keyCode === 68) { //Eingabe D (für rechts)
			$('#alien').css('left','+=3');
			event_repeat_left = false;
			if (!event_repeat_right) {		//nur beim ersten Mal
				event_repeat_right=true;
				$('#alien').destroy().sprite({fps: 5, no_of_frames: 3});
				$('#vordergrund').destroy().pan({fps: 15, speed: 3, dir: 'left'});
				$('#berge').destroy().pan({fps: 15, speed: 1, dir: 'left'});
			}
		}
		else if (eingabe.keyCode == 65 && ($('#alien').css('left').replace('px', '') * 1 > 0)) { // Eingabe A (für links) + Kollisionsabfrage
			$('#alien').css('left','-=3');
			event_repeat_right = false;
			if (!event_repeat_left) { //nur beim ersten Mal
				event_repeat_left=true;
				$('#alien').destroy().sprite({fps: 5, no_of_frames: 3});
				$('#vordergrund').destroy().pan({fps: 15, speed: 3, dir: 'right'});
				$('#berge').destroy().pan({fps: 15, speed: 1, dir: 'right'});
			}
		}
		else if ($('#alien').css('left').replace('px', '') * 1 <= 0) {	//Kollisionsabfrage für Hintergründe-Animation
			$('#vordergrund').destroy();
			$('#berge').destroy();
		}	
		else
			return;
		}).keyup(function (eingabe) {
			$('#alien').destroy();
			$('#vordergrund').destroy();
			$('#berge').destroy();
			event_repeat_right = false;
			event_repeat_left = false;
			});
		
		var chap1Loop = setInterval(chap1Step,15);
		function chap1Step () {
			if ($('#alien').css('left').replace('px', '') * 1  >= $('#clanmaster').css('left').replace('px', '') * 1 -150 ) { //wenn Alien auf Clanmaster trifft --> DIALOG
				meeting=true; //d.h. User kann Alien nicht mehr bewegen (s.o.)
				$('#vordergrund').destroy();
				$('#berge').destroy();
			
				manageDialogComposition ();
				clearInterval(chap1Loop);
			}
		}
		
		function manageDialogComposition () {
			//Einstieg des Klan-Meisters:
			$('#clanmaster').stop().animate({height : '180px', width : '110px'}, 500, function() {
					$('#text_clanmaster').html("Huch, "+username+".").show();
				});
			//nach Wartezeit beginnen Gesprächsoptionen:
			setTimeout(function(){
				$('#reply_alternatives').show();
				//Klick auf pos Begrüßung
				$('#greeting_pos').click(function () {
					$('#text_alien').html("Seid gegrüßt, mein liebster Klan-Meister!").show();
					$('#greeting_pos').hide();
					$('#greeting_neg').hide();
						
					setTimeout(function(){
						$('#text_clanmaster').html("Kann ich dir helfen?");
						$('#text_alien').hide();
					}, 2000);
					
					setTimeout(function(){
						$('#greeting_pos').text("Ja, ich hoffe.").show();
						$('#greeting_neg').text("Nein, ich denke nicht.").show();
					}, 2000);
					
					
					$('#greeting_pos').unbind('click');	//alle Eventhandler removen					
					$('#greeting_pos').click (function (){
						$('#text_alien').html("Ja, mein Meister. Meine Freundin wurde entführt.").show();
						$('#greeting_pos').hide();
						$('#greeting_neg').hide();
						
						setTimeout(function(){
							$('#text_clanmaster').html("Ich weiß. Die Rowdy-Drillinge der Anti-Marsianer-Allianz halten sie gefangen. Mach dich auf die Reise und besiege die drei Brüder!");
							$('#text_alien').hide();
						}, 2000);
						
						setTimeout(function(){
							$('#greeting_pos').text("Ich mach mich auf den Weg.").show();
						}, 3000);
						
						$('#greeting_pos').unbind('click'); //alle Eventhandler removen	
						$('#greeting_pos').click (function (){
							$('#audioChap1Background').get(0).pause();
							pageTransition('chapter_one','chapter_two', 'Kapitel 2: Action-Adventure', '<p>Besiege die Drillinge!<br><br>Schieße mit der Leertaste.<br>Bewege dabei dein Ufo nach oben (W) und unten (S), um auszuweichen.<p>', 'chap2', '');							
						});
					});
					
					$('#greeting_neg').unbind('click');	//alle Eventhandler removen	
					$('#greeting_neg').click (function (){
						$('#text_alien').html("Nein, Meister. Was wissen Sie schon?").show();
						$('#greeting_pos').hide();
						$('#greeting_neg').hide();
						
						setTimeout(function(){
							$('#text_clanmaster').html("Alles, du Kleinling. Die Rowdy-Drillinge der Anti-Marsianer-Allianz halten deine Freundin gefangen. Mach dich auf die Reise und besiege die drei Brüder!");
							$('#text_alien').hide();
						}, 2000);
						
						setTimeout(function(){
							$('#greeting_pos').text("Ich mach mich auf den Weg.").show();
						}, 3000);
						
						$('#greeting_pos').unbind('click');	
						$('#greeting_pos').click (function (){
							$('#audioChap1Background').get(0).pause();
							pageTransition('chapter_one','chapter_two', 'Kapitel 2: Action-Adventure', '<p>Besiege die Drillinge!<br><br>Schieße mit der Leertaste.<br>Bewege dabei dein Ufo nach oben (W) und unten (S), um auszuweichen.<p>', 'chap2', '');
						});	
					});
				});
				
				//Klick auf neg Begrüßung
				$('#greeting_neg').click(function () {
					$('#warning').show();
					$('#chapter_one').hide();
					$('#audioChap1Background').get(0).pause(); //Hintergrundmelodie pausieren
					$('#audioChap1Cry').get(0).play(); //Audio "Weinen" abspielen
					
					$('#neg').click(function (){
						window.location.reload();
					});
				
					$('#pos').click(function (){
						$('#chapter_one').show();
						$('#greeting_neg').hide();
						$('#warning').hide();
						$('#audioChap1Cry').get(0).pause(); //Audio "Weinen" pausieren
						$('#audioChap1Background').get(0).play(); //Hintergrundmelodie abspielen
					});
				});
			}, 3500);
		}
	}
/*----ENDE Funktion "Kapitel 1"----*/
/*----ANFANG Funktion "Kapitel 2"----*/
	function chapter_two() {		
		$('.button_back_to_menue').click(function () { 
			window.location.reload();
		});
		$('#button_to_chapter_three').click(function () { 
			pageTransition('chapter_two','chapter_three', 'Kapitel 3: Hidden Object', '<p>Du hast die Entführer zwar besiegt, doch deine Freundin ist noch immer gefangen.<br><br>Finde den Schlüssel!<br><br>Ziehe ihn dann mit der Maus zum Käfig.<br>Leichte Gegenstände kannst du bewegen, mit schweren Dingen kannst du teilweise über Klicks interagieren.</p>', 'chap3', '');	
		});
		
		$('#audioChap2Background').get(0).play(); //Hintergrundmelodie "Kap 3"
		
		var keycode_up=false;
		var keycode_down=false;
		var keycode_space=false;
		
		$(document).keydown(function (eingabe) {
			if (eingabe.keyCode === 32)	//Eingabe Leertaste (für Schießen)
				keycode_space=true;
			if (eingabe.keyCode === 87)	//Eingabe W (für oben)
				keycode_up=true;
			if (eingabe.keyCode === 83)	//Eingabe S (für unten)
				keycode_down=true;						
			else
				return;
			}).keyup(function (eingabe) {				
				if (eingabe.keyCode === 32)	//Eingabe Leertaste (für Schießen)
					keycode_space=false;
				if (eingabe.keyCode === 87)	//Eingabe W (für oben)
					keycode_up=false;
				if (eingabe.keyCode === 83)	//Eingabe S (für unten)
					keycode_down=false;
			});
			
		function makeBulletFly (div){
			var fly_loop =  setInterval(function(){fly()},40);
			function fly(){
				div.css('left','+=8');
				if(div.css('left').replace('px', '')*1 >= 1000-div.css('width').replace('px', '')*1) { //Kollisonsabfrage mit Spielrand
					div.remove();
					clearInterval(fly_loop);
				}							
			}
		}
		//Bewegung der drei bösen Ufos
		function MakeBadUfoMove (div, speed) {
			if (typeof div.css('left') !== 'undefined') {
				if(div.css('left').replace('px', '') * 1 > 0 && div.css('left').replace('px', '') * 1 < ($('#chapter_two').css('width').replace('px', '') * 1 - div.css('width').replace('px', '') * 1))
					div.css('left',speed);
				if(!(div.css('left').replace('px', '') * 1 > 0 && div.css('left').replace('px', '') * 1 < ($('#chapter_two').css('width').replace('px', '') * 1 - div.css('width').replace('px', '') * 1))) //Kollisonsabfrage mit Spielrand
					div.css('left','800px');
			}
		} 
		
		var shot =[];
		var counter =0;
		var dead_bad_ufos = 0;
		
		var shotloop = setInterval(makeShotStep,100);
		function makeShotStep() {
			counter++;
			shot[counter]=false;
			
			if (keycode_space){ //Eingabe Leertaste (für Schießen)
				$('#audioChap2Laser').get(0).play(); //Audio "Schuss"
				$('#allbullets').append('<div class="bullets" id="bullet'+counter+'"><img src="img/bullet.png"></div>');
				var position_bullet= $('#alien_ufo').css('top').replace('px', '') * 1 + ($('#alien_ufo').css('height').replace('px', '') * 1 / 2);	//horizontale Position je nach Ufo-Position
				$('#bullet'+counter).css({'position':'absolute','top':position_bullet,'left':'221px','width':'32px','height':'16px'});
				$('#bullet'+counter).show();
				shot[counter]=true;
			}
			if(shot[counter]){
				makeBulletFly($('#bullet'+counter));
			}
			
			//Kollisionsabfrage: Bullets - böse Ufos
			if (typeof $('#bullet'+counter).css('left') !== 'undefined') {
				var collision_loop =  setInterval(function(){coll()},15);
				var current_bullet = $('#bullet'+counter);
				function coll(){
					var BulletRight = current_bullet.css('left').replace('px', '') * 1 + (current_bullet.css('width').replace('px', '') * 1);
					var BulletTop = current_bullet.css('top').replace('px', '') * 1;
					var BulletBottom = (current_bullet.css('top').replace('px', '') * 1) + (current_bullet.css('height').replace('px', '') * 1);
			
					if (typeof $('#bad_ufo_1').css('left') !== 'undefined')
						bulletCollision (current_bullet, $('#bad_ufo_1'), $('#bad_ufo_1').css('left').replace('px', '') * 1, $('#bad_ufo_1').css('top').replace('px', '') * 1, $('#bad_ufo_1').css('top').replace('px', '') * 1 + 100, BulletRight, BulletTop, BulletBottom);
					if (typeof $('#bad_ufo_2').css('left') !== 'undefined')
						bulletCollision (current_bullet, $('#bad_ufo_2'), $('#bad_ufo_2').css('left').replace('px', '') * 1, $('#bad_ufo_2').css('top').replace('px', '') * 1, $('#bad_ufo_2').css('top').replace('px', '') * 1 + 100, BulletRight, BulletTop, BulletBottom);
					if (typeof $('#bad_ufo_3').css('left') !== 'undefined')
						bulletCollision (current_bullet, $('#bad_ufo_3'), $('#bad_ufo_3').css('left').replace('px', '') * 1, $('#bad_ufo_3').css('top').replace('px', '') * 1, $('#bad_ufo_3').css('top').replace('px', '') * 1 + 100, BulletRight, BulletTop, BulletBottom);
				}
			}
			
			function bulletCollision (bullet, badUfo, badUfoLeft, badUfoTop, badUfoBottom, BulletRight, BulletTop, BulletBottom) {
				if(badUfoLeft <= BulletRight && ((BulletTop >= badUfoTop && BulletTop <= badUfoBottom) || (BulletBottom >= badUfoTop && BulletBottom <= badUfoBottom)))	{
					dead_bad_ufos++;
					badUfo.remove();
					bullet.remove();
					$('#audioChap2Explosion').get(0).play(); //Audio "Explosion"
						
					var imgsrc_bad = 'img/explosion_bad.gif'+'?'+Math.random()*Math.random(); //damit Bild immer neu geladen wird (GIF!)
					$('#img_explosion').replaceWith( '<img src="'+imgsrc_bad+'" id="img_explosion">' );
					$('#img_explosion').css({ "top": ''+badUfoTop+'px',  "left": ''+badUfoLeft+'px'});
					$('#explosion').show();
					$('#explosion').fadeOut(1500);
					if (dead_bad_ufos == 3) {
						$('#won').show();
						$('#audioChap2Background').get(0).pause(); //Hintergrundmelodie pausieren
						$('#audioWon').get(0).play(); //Audio "Siegeston" abspielen
						clearInterval(gameLoop);
						clearInterval(shotloop);
					}
					clearInterval(collision_loop);	
				}
			}	
		}
		
		var gameLoop = setInterval(makeGameStep,15);
		function makeGameStep() {	
			//Eingabe oben + Kollisonsabfrage Rand
			if (keycode_up && $('#alien_ufo').css('top').replace('px', '') * 1 > 0)
				$('#alien_ufo').css('top','-=2');
			//Eingabe unten + Kollisonsabfrage Rand
			if(keycode_down && $('#alien_ufo').css('top').replace('px', '') * 1 < ($('#chapter_two').css('height').replace('px', '') * 1 - $('#alien_ufo').css('height').replace('px', '') * 1))
				$('#alien_ufo').css('top','+=2');
			
			//Bewegung der drei bösen Ufos
			MakeBadUfoMove($('#bad_ufo_1'), '-=1');
			MakeBadUfoMove($('#bad_ufo_2'), '-=2');
			MakeBadUfoMove($('#bad_ufo_3'), '-=3');

			//Kollisionsabfrage: gutes Ufo - böse Ufos
			var goodUfoRight = ($('#alien_ufo').css('left').replace('px', '') * 1) + 196;
			var goodUfoTop = $('#alien_ufo').css('top').replace('px', '') * 1;
			var goodUfoBottom = ($('#alien_ufo').css('top').replace('px', '') * 1) + 100;
			
			if (typeof $('#bad_ufo_1').css('left') !== 'undefined')
				collision (goodUfoRight, goodUfoTop, goodUfoBottom, $('#bad_ufo_1').css('left').replace('px', '') * 1, $('#bad_ufo_1').css('top').replace('px', '') * 1, $('#bad_ufo_1').css('top').replace('px', '') * 1 + 100);
			if (typeof $('#bad_ufo_2').css('left') !== 'undefined')
				collision (goodUfoRight, goodUfoTop, goodUfoBottom, $('#bad_ufo_2').css('left').replace('px', '') * 1, $('#bad_ufo_2').css('top').replace('px', '') * 1, $('#bad_ufo_2').css('top').replace('px', '') * 1 + 100);
			if (typeof $('#bad_ufo_3').css('left') !== 'undefined')
				collision (goodUfoRight, goodUfoTop, goodUfoBottom, $('#bad_ufo_3').css('left').replace('px', '') * 1, $('#bad_ufo_3').css('top').replace('px', '') * 1, $('#bad_ufo_3').css('top').replace('px', '') * 1 + 100);
			
			function collision (goodUfoRight, goodUfoTop, goodUfoBottom, badUfoLeft, badUfoTop, badUfoBottom) {
				if(badUfoLeft <= goodUfoRight && ((goodUfoTop >= badUfoTop && goodUfoTop <= badUfoBottom) || (goodUfoBottom >= badUfoTop && goodUfoBottom <= badUfoBottom))) {
					var imgsrc_explos_good = 'img/explosion_good.gif'+'?'+Math.random()*Math.random(); //damit Bild immer neu geladen wird (GIF!)
					$('#alien_ufo').css({ "background": 'url("'+imgsrc_explos_good+'")' });
					$('#audioChap2Explosion').get(0).play(); //Audio "Explosion" abspielen
					$('#gameover').show();
					$('#audioChap2Background').get(0).pause(); //Hintergrundmelodie pausieren
					$('#audioGameOver').get(0).play(); //Audio "Game-over-Ton" abspielen
					clearInterval(gameLoop);
					clearInterval(shotloop);
				}
			}	
		}
	}
/*----ENDE Funktion "Kapitel 2"----*/
/*----ANFANG Funktion "Kapitel 3"----*/
	function chapter_three () {
		$('.button_back_to_menue').click(function () { 
			window.location.reload();
		});	
		
		$('#audioChap3Background').get(0).play(); //Audio "Ticken der Bombe"
		
		$(init);
		function init() {
			$('#draggablePlant').draggable({
			cursor: 'w-resize',
			axis: 'x',
			containment: '#chapter_three'
			});
			$('#draggableFalseKey').draggable({
			cursor: 'move',
			scope: 'key',
			containment: '#chapter_three'
			});
			$('#draggableKey').draggable({
			cursor: 'move',
			scope: 'key',
			containment: '#chapter_three'
			});
			$('#droppableCage').droppable( {
				scope: 'key',
				tolerance: 'touch',
				drop: manageDropEvent //Funktion, die bei Drop ausgeführt wird
			} );
		}
		
		falseKeyUsed = false;
		dresserInvestigated = false;
		function manageDropEvent(event, ui) {
			var draggable = ui.draggable;
			if (draggable.attr('id') == 'draggableFalseKey') {
				if (!falseKeyUsed) {	//nur beim ersten Mal
					falseKeyUsed = true;
					createAndOpenDialog("ROFL", "Dachtest du wirklich es würde so einfach sein?", "Sorry");
					$('#draggableFalseKey').remove(); //Schlüssel entfernen
				}
			}
			if (draggable.attr('id') == 'draggableKey') {
				createAndOpenDialog("Passender Schlüssel", "Du konntest deine Freundin befreien. Gut gemacht.", "Danke");
				$('#preventAnyAction').show(); //User kann durch Klick nichts mehr auslösen
				$('#draggableKey').remove(); //Schlüssel entfernen
				clearInterval(s); //Timer beenden
				$('#audioChap3Background').get(0).pause(); //Audio "Ticken der Bombe" pausieren
				$('#audioWon').get(0).play(); //Audio "Siegeston" abspielen
				$('#countdown').remove(); //Bombe, Timer und Lunte entfernen
				$('#droppableCage').html('<img src="img/cage_open.gif" id="img_plant">'); //geöffneter Käfig statt geschlossenen
				setTimeout(function(){
					pageTransition('chapter_three','epilog', '', '', '', '');
					epilog();
				}, 5000);
			}	
		}

		function createAndOpenDialog(title, message, buttonText, e) {
			$("#chapt3_dialog").dialog({
				autoOpen: false,
				buttons: [ { text: buttonText, click: function() { $( this ).dialog( "close" ); } } ],
				modal: true,
				title: title,
				close: function (event, ui) { if(falseKeyUsed || dresserInvestigated) $(this).dialog("close"); else $(this).remove();}
			}).text(message); 
			$("#chapt3_dialog").dialog("open");
		}
		
		var time= 20; //Countdown Startpunkt
		s = setInterval( function () {
			$('#time').text(time--); 
			if (time == -1) {
				clearInterval(s);
				$('#preventAnyAction').show(); //User kann durch Klick nichts mehr auslösen
				$('#audioChap3Background').get(0).pause(); //Audio "Ticken der Bombe" pausieren
				$('#audioChap3Explosion').get(0).play(); //Audio "Explosion" abspielen
				var imgsrc_bomExplosion = 'img/bomb_explosion.gif'+'?'+Math.random()*Math.random(); //damit Bild immer neu geladen wird (GIF!)
				$('#img_bombExplosion').replaceWith( '<img src="'+imgsrc_bomExplosion+'" id="img_bombExplosion">' );
				$('#bombExplosion').show();
				$('#bombExplosion').fadeOut(2000);
				$('#droppableCage').remove();
				$('#countdown').remove();
				$('#ashheap').fadeIn(2000);
				setTimeout(function(){
					$('#audioGameOver').get(0).play(); //Audio "Game-over-Ton" abspielen
					$('#chap3Gameover').show();
				}, 2300);
			}		
		} , 1000);
		
		//Klickbare Komode
		$('#clickableDresser').click(function () {
			if (!dresserInvestigated) { //nur beim ersten Mal	
				dresserInvestigated=true;
				createAndOpenDialog("Kommode", "Darin befindet sich nur unnützer Krempel.", "Ok");
			}	
		});
		//Klickbarer TV-Knopf
		$('#clickableTvButton').click(function () {
			$('#audioChap3Tv').get(0).play(); //Audio "Umschaltton" abspielen
			currentProgramm = $('#screen').html();
			if (currentProgramm == '<img src="img/screen_grey.png">')
				$('#screen').html('<img src="img/screen_movie.gif">');
			else
				$('#screen').html('<img src="img/screen_grey.png">');
		});	
	}
/*----ENDE Funktion "Kapitel 3"----*/
/*----ANFANG Funktion "Epilog"----*/
	function epilog () {
		$('#audioEpilogBackground').get(0).play(); //Hintergrundmelodie abspielen
		setTimeout(function(){
			$('#epilog').css('background','black');
			$('#credits').fadeIn();
		}, 12000);
		setTimeout(function(){
			window.location.reload();
		}, 18000);
	}
/*----ENDE Funktion "Epilog"----*/	
});