/*jslint plusplus: true */
/*global $,ace,Node,inspectElements,inspectText,inspectchildren*/
//ace.require("ace/ext/language_tools");
var textarea = $('textarea[name="htmlcode"]');
textarea.hide();
var htmleditor = ace.edit("htmlcode");
htmleditor.setTheme("ace/theme/xcode");
htmleditor.getSession().setMode("ace/mode/html");
htmleditor.getSession().setValue($("#htmlcodeinput").text());
var texeditor = ace.edit("texcode");
texeditor.setTheme("ace/theme/xcode");
texeditor.getSession().setMode("ace/mode/latex");
texeditor.getSession().setValue("Hier erscheint nach der Übersetzung des LaTeX-Code.");
texeditor.setReadOnly(true);



//Doctype: Abfrage ob Code als gesamtes Dokument oder Ausschnitt betrachtet werden soll.
var doctype = true;
$("#doctype").change(function () {"use strict";
	if ($("#doctype2:checked").val()) {doctype = false; $("#bonusoptions").hide(); } else {$("#bonusoptions").show(); }
    });

var latexproperties = {};
latexproperties.body = [];
latexproperties.currentcode = [];
latexproperties.preambel = [];
latexproperties.h1 = "section";
latexproperties.h2 = "subsection";
latexproperties.h3 = "subsubsection";
latexproperties.h4 = "paragraph";
latexproperties.h5 = "subparagraph";
latexproperties.h6 = "minisec";
latexproperties.image = false;
latexproperties.hyper = false;
latexproperties.audioname = "Audioelement";
latexproperties.videoname = "Videoelement";
latexproperties.multirow = false;
latexproperties.colortbl = false;
latexproperties.options = [];
latexproperties.base = "";
var colorrow = false;
var columns = 0;
var firstline = false;
latexproperties.list = 0;

//Makedocument: Aus Preambel, encoding, lang,... Präambel basteln
var makedocument = function (object) {
        "use strict";
	    if (latexproperties.image) {object.preambel.push("\\usepackage{graphicx}\n"); }
        if (latexproperties.multirow) {object.preambel.push("\\usepackage{multirow}\n"); }
        if (latexproperties.colortbl) {object.preambel.push("\\usepackage{colortbl}\n\\usepackage{xcolor}\n"); }
        if (latexproperties.ulem) {object.preambel.push("\\usepackage[normalem]{ulem}\n"); }
        if (latexproperties.hyper) {object.preambel.push("\\usepackage{hyperref}\n"); }
        if (object.encoding) {
            object.encoding = object.encoding.replace("-", "");
        } else {
            object.encoding = "utf8";
        }
            object.preambel.splice(0, 0, "\\documentclass[" + object.lang + "]{" + object.docclass + "}\n\\usepackage[" + object.encoding + "]{inputenc}\n\\usepackage{babel}\n");
	//console.log(object.preambel);
	        object.body.splice(0, 0, "\\begin{document}\n");
	        object.body = object.preambel.concat(object.body);
	        object.body.push("\\end{document}");
	        return object.body;
    };
//Setoptions Notwendige Pakete herausschreiben
var langs = [{"Deutsch": "ngerman"}, {"Englisch": "englisch"}],
    setoptions = function (object) {
        "use strict";
        object.options = [];
        if (latexproperties.image) {object.options.push(" graphicx (oder graphics)"); }
        if (latexproperties.multirow) {object.options.push(" multirow"); }
        if (latexproperties.colortbl) {object.options.push(" colortbl, xcolor"); }
        if (latexproperties.ulem) {object.options.push(" ulem (mit der Option normalem)"); }
	    if (latexproperties.hyper) {object.options.push(" hyperref"); }
        object.options = object.options.toString();
        if (object.options !== "") {
            object.options = [object.options];
            object.options.splice(0, 0, "Benötigte Pakete: ");
            object.options.join("");
        }
        $("#pakete").text(object.options.join(""));
    };
//Check the Checkbox STatus für hyperlinks
$("#hyperlink").change(function () {
    "use strict";
    if ($("#hyperlink").attr("checked")) {latexproperties.hyper = true; } else {latexproperties.hyper = false; }
});

//Sprachauswahl
    
$.each(langs, function (i, v) {
    "use strict";
    var property;
    for (property in v) {$("<option/>").text(property).val(v[property]).appendTo($("#langselection")); }
});
latexproperties.lang = "ngerman";
$("#langselection").change(function () {
    "use strict";
    latexproperties.lang = $("#langselection").val();
});

var classes = [];
classes.push({"Artikel": "scrartcl"}, {"Buch": "scrbook"});
$.each(classes, function (i, v) {
    "use strict";
    var property;
    for (property in v)
        {$("<option/>").text(property).val(v[property]).appendTo($("#classselection")); }
});
latexproperties.docclass = "scrartcl";//standardklasse scrartcl
$("#classselection").change(function () {
    "use strict";
    latexproperties.docclass = $("#classselection").val();
    if (latexproperties.docclass === "scrartcl") {
        latexproperties.h1 = "section";
        latexproperties.h2 = "subsection";
        latexproperties.h3 = "subsubsection";
        latexproperties.h4 = "paragraph";
        latexproperties.h5 = "subparagraph";
        latexproperties.h6 = "minisec";
    } else {
        latexproperties.h1 = "chapter";
        latexproperties.h2 = "section";
        latexproperties.h3 = "subsection";
        latexproperties.h4 = "subsubsection";
        latexproperties.h5 = "paragraph";
        latexproperties.h6 = "subparagraph";
    }
});
     

var inspectors = { };

var pushcode = function () {
    "use strict";
	var joined = latexproperties.currentcode.join("");
	if (joined) {
		latexproperties.body.push(joined + "\n");
		latexproperties.currentcode = [];
    }
};



var inspectNodes = function (nodes) {
    "use strict";
    var i,
        node;
	for (i = 0; i < nodes.length; ++i) {
		node = nodes[i];
		if (node.nodeType === Node.ELEMENT_NODE) {
			inspectElements(node);
		} else if (node.nodeType === Node.TEXT_NODE) {
			inspectText(node);
		}
	}
};

var inspectElements = function (element) {
    "use strict";
	var inspector = inspectors[element.localName];

	if (inspector) {inspector(element); } else {inspectchildren(element); }
};



var inspectText = function (text) {
    "use strict";
    var content = text.data,
        ohnetab = content.replace(/\t/g, "").replace(/\s+/g, ' ');
    if (ohnetab !== " ") {
        latexproperties.currentcode.push(ohnetab);
    }
};

var inspectchildren = function (element) {
    "use strict";
    inspectNodes(element.childNodes);
};
/*inspectors.html = inspectchildren;
inspectors.head = inspectchildren;
inspectors.body = inspectchildren;
inspectors.header=inspectchildren;
inspectors.footer=inspectchildren;
inspectors.tbody=inspectchildren;*/
inspectors.link = function () {"use strict"; };
inspectors.style = function () {"use strict"; };
inspectors.noscript = function () {"use strict"; };
inspectors.caption = function () {"use strict"; };

inspectors.base = function (element) {
    "use strict";
    latexproperties.base = element.href;
};


/*inspectors.audio= function(element){
	inspectchildren(element);
    if (latexproperties.hyper)*/
inspectors.em = function (element) {
    "use strict";
    latexproperties.currentcode.push("\\emph{");
    inspectchildren(element);
    latexproperties.currentcode.push("}");
};

inspectors.strong = function (element) {
    "use strict";
    latexproperties.currentcode.push("\\bf{");
    inspectchildren(element);
    latexproperties.currentcode.push("}");
};

inspectors.code = function (element) {
    "use strict";
    latexproperties.body.push("\\begin{verbatim}\n");
    inspectchildren(element);
    pushcode();
    latexproperties.body.push("\\end{verbatim}\n");
};

inspectors.small = function (element) {
    "use strict";
    latexproperties.currentcode.push("{\\small");
    inspectchildren(element);
    latexproperties.currentcode.push("}");
};

inspectors.s = function (element) {
    "use strict";
    latexproperties.ulem = true;
    latexproperties.currentcode.push("\\sout{");
    inspectchildren(element);
    latexproperties.currentcode.push("}");
};

inspectors.q = function (element) {
    "use strict";
    latexproperties.csquotes = true;
    latexproperties.currentcode.push("\\enquote{");
    inspectchildren(element);
    latexproperties.currentcode.push("}");
}

inspectors.hr = function (element) {
    "use strict";
    pushcode();
    latexproperties.body.push("\\hrule\n");
};
    
inspectors.blockquote = function (element) {
    "use strict";
    pushcode();
    latexproperties.body.push("\\begin{quote}\n");
    inspectchildren(element);
    pushcode();
    latexproperties.body.push("\\end{quote}\n");
};
        

inspectors.video = function (element) {
    "use strict";
	inspectchildren(element);
    if (latexproperties.hyper) {latexproperties.body.push("\\href{" + latexproperties.base + element.src.replace("file:///", "") + "}{" + latexproperties.videoname + "}"); } else {latexproperties.body.push(latexproperties.currentcode.join("")); }
};

inspectors.source = function (element) {
    "use strict";
	inspectchildren(element);
	element.parentNode.src = element.src;
};

inspectors.figure = function (element) {
    "use strict";
    pushcode();
    latexproperties.body.push("\\begin{figure}\n");
    inspectchildren(element);
    pushcode();
    latexproperties.body.push("\\end{figure}\n");
};

inspectors.figcaption = function (element) {
    "use strict";
    latexproperties.currentcode.push("\\caption{");
    inspectchildren(element);
    latexproperties.currentcode.push("}\n");
};

inspectors.cite = function (element) {
    "use strict";
    latexproperties.currentcode.push("\\cite{");
    inspectchildren(element);
    latexproperties.currentcode.push("}");
};

inspectors.table = function (element) {
    "use strict";
    var n;
    pushcode();
    if (element.caption) {latexproperties.body.push("\\begin{table}\n\\caption{" + element.caption.innerText.replace(/\n/g, "") + "}\n"); }
    if (element.tHead || element.tFoot) {latexproperties.colortbl = true; }
    //if (element.tFoot) {latexproperties.colortbl = true; }
    latexproperties.body.push("\\begin{tabular}{");
    columns = 0;
    firstline = true;
    inspectchildren(element);
    for (n = 0; n < columns; n++) {latexproperties.body.push("c"); }
    latexproperties.body.push("}\n");
    pushcode();
    latexproperties.body.push("\\end{tabular}\n");
    if (element.caption) {latexproperties.body.push("\\end{table}\n"); }
};



inspectors.thead = function (element) {
    "use strict";
    colorrow = true;
    inspectchildren(element);
    colorrow = false;
};
inspectors.tfoot = function (element) {
    "use strict";
    colorrow = true;
    inspectchildren(element);
    colorrow = false;
};

inspectors.tr = function (element) {
    "use strict";
    if (colorrow) {latexproperties.currentcode.push("\\rowcolor{lightgray}\n"); }
    inspectchildren(element);
    latexproperties.currentcode.push("\\\\\n");
    firstline = false;
};

inspectors.th = function (element) {
    "use strict";
    if (element.getAttribute("rowspan")) {
        latexproperties.multirow = true;
        latexproperties.currentcode.push("\\multirow{" + element.getAttribute("rowspan") + "}{*}{\\emph{");
        inspectchildren(element);
        latexproperties.currentcode.push("}");
    }
    if (element.getAttribute("colspan")) {
        latexproperties.currentcode.push("\\multicolumn{" + element.getAttribute("colspan") + "}{c}{\\emph{");
        inspectchildren(element);
        latexproperties.currentcode.push("}");
        if (firstline) {columns = columns + element.getAttribute("colspan") * 1; }
    } else {
        if (firstline) {columns++; }
        latexproperties.currentcode.push("\\emph{");
        inspectchildren(element);
    }
    if (element.nextSibling.nextSibling !== null) {
        latexproperties.currentcode.push("}&");
    } else {latexproperties.currentcode.push("}"); }
};

inspectors.td = function (element) {
    "use strict";
    if (element.getAttribute("rowspan")) {
        latexproperties.multirow = true;
        latexproperties.currentcode.push("\\multirow{" + element.getAttribute("rowspan") + "}{*}{");
        inspectchildren(element);
        latexproperties.currentcode.push("}");
    }
    if (element.getAttribute("colspan")) {
        latexproperties.currentcode.push("\\multicolumn{" + element.getAttribute("colspan") + "}{c}{");
        inspectchildren(element);
        latexproperties.currentcode.push("}");
        if (firstline) {columns = columns + element.getAttribute("colspan") * 1; }
    } else {
        if (firstline) {columns++; }
        inspectchildren(element);
    }
    if (element.nextSibling.nextSibling !== null) {latexproperties.currentcode.push("&"); }
};



inspectors.a = function (element) {
    "use strict";
    inspectchildren(element);
    if (latexproperties.hyper) {latexproperties.body.push("\\href{" + element.getAttribute("href") + "}{" + latexproperties.currentcode.join("") + "}"); } else {latexproperties.body.push(latexproperties.currentcode.join("")); }
	latexproperties.currentcode = [];
};

inspectors.aside = function (element) {
    "use strict";
    inspectNodes(element.childnodes);
    latexproperties.body.push("\\marginpar{" + latexproperties.currentcode.join("") + "}");
    latexproperties.currentcode = [];
};

inspectors.section = function (element) {
    "use strict";
    inspectchildren(element);
    latexproperties.body.push("\\part{" + latexproperties.currentcode.join("") + "}\n");
    latexproperties.currentcode = [];
};

inspectors.h1 = function (element) {
    "use strict";
    inspectchildren(element);
    latexproperties.body.push("\\" + latexproperties.h1 + "{" + latexproperties.currentcode.join("") + "}\n");
    latexproperties.currentcode = [];
};
inspectors.h2 = function (element) {
    "use strict";
    inspectchildren(element);
    latexproperties.body.push("\\" + latexproperties.h2 + "{" + latexproperties.currentcode.join("") + "}\n");
    latexproperties.currentcode = [];
};
inspectors.h3 = function (element) {
    "use strict";
    inspectchildren(element);
    latexproperties.body.push("\\" + latexproperties.h3 + "{" + latexproperties.currentcode.join("") + "}\n");
	latexproperties.currentcode = [];
};
inspectors.h4 = function (element) {
    "use strict";
    inspectchildren(element);
    latexproperties.body.push("\\" + latexproperties.h4 + "{" + latexproperties.currentcode.join("") + "}\n");
    latexproperties.currentcode = [];
};
inspectors.h5 = function (element) {
    "use strict";
    inspectchildren(element);
    latexproperties.body.push("\\" + latexproperties.h5 + "{" + latexproperties.currentcode.join("") + "}\n");
    latexproperties.currentcode = [];
};
inspectors.h6 = function (element) {
    "use strict";
    inspectchildren(element);
    latexproperties.body.push("\\" + latexproperties.h6 + "{" + latexproperties.currentcode.join("") + "}\n");
    latexproperties.currentcode = [];
};


inspectors.p = function (element) {
    "use strict";
	inspectchildren(element);
	latexproperties.body.push("\n\\par{}" + latexproperties.currentcode.join("") + "\\par{}\n");
	latexproperties.currentcode = [];
};

inspectors.span = function (element) {
    "use strict";
	inspectchildren(element);
	if (element.parentNode) {
        if (element.parentNode.nodeType !== Node.ELEMENT_NODE) {
            latexproperties.body.push("\\mbox{" + latexproperties.currentcode.join("") + "}");
            latexproperties.currentcode = [];
        }
    }
};

inspectors.sub = function (element) {
    "use strict";
    latexproperties.currentcode.push("\textsubscript{");
    inspectchildren(element);
    latexproperties.currentcode.push("}");
}

inspectors.sup = function (element) {
    "use strict";
    latexproperties.currentcode.push("\textsuperscript{");
    inspectchildren(element);
    latexproperties.currentcode.push("}");
}


inspectors.title = function (element) {
    "use strict";
	inspectchildren(element);
	latexproperties.body.push("\\title{" + latexproperties.currentcode.join("") + "}\n\\maketitle\n");
	latexproperties.currentcode = [];
};

inspectors.div = function (element) {
    "use strict";
	inspectchildren(element);
	pushcode();
};

inspectors.li = function (element) {
    "use strict";
	if (latexproperties.list > 0) {
        latexproperties.body.push("\\item ");
		inspectchildren(element);
		pushcode();
        latexproperties.body.push("\n");
    }
};

inspectors.ol = function (element) {
    "use strict";
	latexproperties.body.push("\\begin{enumerate}");
	latexproperties.list++;
	inspectchildren(element);
	latexproperties.body.push("\\end{enumerate}");
	latexproperties.list--;
};



inspectors.ul = function (element) {
    "use strict";
    pushcode();
	latexproperties.body.push("\\begin{itemize}\n");
	latexproperties.list++;
	inspectchildren(element);
	latexproperties.body.push("\\end{itemize}\n");
	latexproperties.list--;
};

inspectors.dl = function (element) {
    "use strict";
    pushcode();
    latexproperties.body.push("\\begin{description}\n");
    latexproperties.list++;
    inspectchildren(element);
    pushcode();
    latexproperties.body.push("\\end{description}\n");
    latexproperties.list--;
};

inspectors.dt = function (element) {
    "use strict";
    latexproperties.currentcode.push("\\item[");
    inspectchildren(element);
    latexproperties.currentcode.push("]");
};
inspectors.dd = function (element) {
    "use strict";
    inspectchildren(element);
    if (element.nextSibling.localName === "dd") {latexproperties.currentcode.push("\\par"); }
    latexproperties.currentcode.push("\n");
};

inspectors.meta = function (element) {
    "use strict";
	if (element.getAttribute('charset')) {
        latexproperties.encoding = element.getAttribute('charset');
	    inspectchildren(element);
    }
};

inspectors.img = function (element) {
    "use strict";
	latexproperties.image = true;
	inspectchildren(element);
	var source = element.getAttribute("src"),
        height,
        width;
	source = source.replace("file:///", "");
	if (element.height) {height = "height=" + element.height + "px"; }
	if (element.width) {width = "width=" + element.width + "px"; }
	if (element.height || element.width) {latexproperties.body.push("\\includegraphics[" + height + "," + width + "]{" + latexproperties.base + source + "}\n"); } else {latexproperties.body.push("\\includegraphics{" + latexproperties.base + source + "}\n"); }
};
 
var clearoptions=function() {document.getElementById("pakete").innerText="";}

$("#uebersetzungsbutton").click(function () {
    "use strict";
    $("#pakete").text("");
	latexproperties.body = [];
	latexproperties.preambel = [];
    latexproperties.multirow = false;
    latexproperties.colortbl = false;
    latexproperties.image = false;
    latexproperties.options = [];
	var original = htmleditor.getSession().getValue(),
        script = original.match(/<script.*\/script>/g),
        noscript = original,
        content,
        texoutput;
	if (script) {
		$.each(script, function (i, v) {noscript = noscript.replace(v, ""); });
    }
    content = $('<div />').html(noscript).get(0);
	inspectNodes(content.childNodes);
    pushcode();
    if (doctype) {
        texoutput = makedocument(latexproperties); 
    } else {
        texoutput =latexproperties.body;
        setoptions(latexproperties);
    }
    if (texoutput){
    texoutput = texoutput.join("");
    texoutput = texoutput.replace(/\n\n/g, "\n").replace(/\\par{}/g, "\\par{}").replace(/\\par{}\\par{}/g, "\\par{}");
    }
    //console.log(texoutput);
    //$("#texcodeoutput").text(texoutput);
    //".texcode").ace({theme:"pastel_on_dark",value:texoutput,read});
    texeditor.getSession().setValue(texoutput)
	return;

});


