var cubeone = new cube();
cubeone.basic();
cubeone.RotateOuterLeft();
cubeone.RotateOuterLeft();
cubeone.RotateOuterRight();
cubeone.RotateOuterRight();
cubeone.RotateOuterDown();
cubeone.RotateOuterDown();
cubeone.RotateOuterUp();
cubeone.RotateOuterUp();
cubeone.RotateOuterFront();
cubeone.RotateOuterFront();
cubeone.RotateOuterBack();
cubeone.RotateOuterBack();
var newcubecolors = cubeone.Translate();

var camera, scene, renderer;
var mesh;

init();
animate();

function init(){
	renderer = new THREE.WebGLRenderer();
	renderer.setSize( window.innerWidth, window.innerHeight );
	document.body.appendChild( renderer.domElement );

	camera = new THREE.PerspectiveCamera( 70, window.innerWidth / window.innerHeight, 1, 1000 );
	camera.position.z = 40;

	scene = new THREE.Scene();

	var geometry = new THREE.CubeGeometry( 18, 18, 18, 3, 3, 3 );

	 for ( var i = 0; i < 108; i++ ) 
    {
        face  = geometry.faces[ i ];    
        face.color.setHex( newcubecolors[ i ] );
    }		

	var material = new THREE.MeshBasicMaterial( { color: 0xffffff, vertexColors: THREE.FaceColors } );

	mesh = new THREE.Mesh( geometry, material );
	scene.add( mesh );

	window.addEventListener( 'resize', onWindowResize, false );
}

function onWindowResize(){
	camera.aspect = window.innerWidth / window.innerHeight;
	camera.updateProjectionMatrix();

	renderer.setSize( window.innerWidth, window.innerHeight );
}

function animate(){
	requestAnimationFrame( animate );

	mesh.rotation.x += 0.005;
	mesh.rotation.y += 0.01;

	renderer.render( scene, camera );
}