var cubearr = [];								// leeres Cube-Array
// var primecolor = "cubewhite";
// var frontcolor = "cubeblue";
var colors = ["cubewhite","cubeblue","cubered","cubeyellow","cubegreen","cubeorange"];
var cubewhite = "FFFFFF";
var cubered = "9C0917";
var cubeblue = "0A3F84";
var cubeorange = "FF4E0A";
var cubeyellow = "FFD406";
var cubegreen = "0A7C38";

function cube(cubearr){
	this.cube = cubearr || new Array(54);		// constructor der cube-Klasse
}

// Basic-Funktion der cube-Klasse. Beschreibt den Würfel mit den Grundfarben

cube.prototype.basic = function(){
	for(i=0;i<9;i++)
	{
		this.cube[i] = cubewhite;
	}
	for(i=9;i<18;i++)
	{
		this.cube[i] = cubered;
	}
	for(i=18;i<27;i++)
	{
		this.cube[i] = cubeblue;
	}
	for(i=27;i<36;i++)
	{
		this.cube[i] = cubeorange;
	}
	for(i=36;i<45;i++)
	{
		this.cube[i] = cubeyellow;
	}
	for(i=45;i<54;i++)
	{
		this.cube[i] = cubegreen;
	}
}

// Äußere Rotations-Funktionen

{
	cube.prototype.RotateOuterLeft = function(){
		var parkone = this.cube[0];
		var parktwo = this.cube[3];
		var parkthree = this.cube[6];

		this.cube[0] = this.cube[45];
		this.cube[3] = this.cube[48];
		this.cube[6] = this.cube[51];

		this.cube[45] = this.cube[36];
		this.cube[48] = this.cube[39];
		this.cube[51] = this.cube[42];

		this.cube[36] = this.cube[18];
		this.cube[39] = this.cube[21];
		this.cube[42] = this.cube[24];

		this.cube[18] = parkone;
		this.cube[21] = parktwo;
		this.cube[24] = parkthree;

		parkone = this.cube[9];
		parktwo = this.cube[12];

		this.cube[9] = this.cube[15];
		this.cube[12] = this.cube[16];

		this.cube[15] = this.cube[17];
		this.cube[16] = this.cube[14];

		this.cube[17] = this.cube[11];
		this.cube[14] = this.cube[10];

		this.cube[11] = parkone;
		this.cube[10] = parktwo;

		console.log('Rotate Outer Left');
	}

	cube.prototype.RotateOuterLeftInverse = function(){
		var parkone = this.cube[0];
		var parktwo = this.cube[3];
		var parkthree = this.cube[6];

		this.cube[0] = this.cube[18];
		this.cube[3] = this.cube[21];
		this.cube[6] = this.cube[24];

		this.cube[18] = this.cube[36];
		this.cube[21] = this.cube[39];
		this.cube[24] = this.cube[42];

		this.cube[36] = this.cube[45];
		this.cube[39] = this.cube[48];
		this.cube[42] = this.cube[51];

		this.cube[45] = parkone;
		this.cube[48] = parktwo;
		this.cube[51] = parkthree;

		parkone = this.cube[9];
		parktwo = this.cube[12];

		this.cube[9] = this.cube[11];
		this.cube[12] = this.cube[10];

		this.cube[11] = this.cube[17];
		this.cube[10] = this.cube[14];

		this.cube[17] = this.cube[15];
		this.cube[14] = this.cube[16];

		this.cube[15] = parkone;
		this.cube[16] = parktwo;

		console.log('Rotate Outer Left Inverse');
	}

	cube.prototype.RotateOuterRight = function(){
		var parkone = this.cube[2];
		var parktwo = this.cube[5];
		var parkthree = this.cube[8];

		this.cube[2] = this.cube[20];
		this.cube[5] = this.cube[23];
		this.cube[8] = this.cube[26];

		this.cube[20] = this.cube[38];
		this.cube[23] = this.cube[41];
		this.cube[26] = this.cube[44];

		this.cube[38] = this.cube[47];
		this.cube[41] = this.cube[50];
		this.cube[44] = this.cube[53];

		this.cube[47] = parkone;
		this.cube[50] = parktwo;
		this.cube[53] = parkthree;

		parkone = this.cube[27];
		parktwo = this.cube[30];

		this.cube[27] = this.cube[33];
		this.cube[30] = this.cube[34];

		this.cube[33] = this.cube[35];
		this.cube[34] = this.cube[32];

		this.cube[35] = this.cube[29];
		this.cube[32] = this.cube[28];

		this.cube[29] = parkone;
		this.cube[28] = parktwo;

		console.log('Rotate Outer Right');
	}

	cube.prototype.RotateOuterRightInverse = function(){
		var parkone = this.cube[2];
		var parktwo = this.cube[5];
		var parkthree = this.cube[8];

		this.cube[2] = this.cube[47];
		this.cube[5] = this.cube[50];
		this.cube[8] = this.cube[53];

		this.cube[47] = this.cube[38];
		this.cube[50] = this.cube[41];
		this.cube[53] = this.cube[44];

		this.cube[38] = this.cube[20];
		this.cube[41] = this.cube[23];
		this.cube[44] = this.cube[26];

		this.cube[20] = parkone;
		this.cube[23] = parktwo;
		this.cube[26] = parkthree;

		parkone = this.cube[27];
		parktwo = this.cube[30];

		this.cube[27] = this.cube[29];
		this.cube[30] = this.cube[28];

		this.cube[29] = this.cube[35];
		this.cube[28] = this.cube[32];

		this.cube[35] = this.cube[33];
		this.cube[32] = this.cube[34];

		this.cube[33] = parkone;
		this.cube[34] = parktwo;

		console.log('Rotate Outer Right Inverse');
	}

	cube.prototype.RotateOuterFront = function(){
		var parkone = this.cube[6];
		var parktwo = this.cube[7];
		var parkthree = this.cube[8];

		this.cube[6] = this.cube[17];
		this.cube[7] = this.cube[14];
		this.cube[8] = this.cube[11];

		this.cube[17] = this.cube[38];
		this.cube[14] = this.cube[37];
		this.cube[11] = this.cube[36];

		this.cube[38] = this.cube[27];
		this.cube[37] = this.cube[30];
		this.cube[36] = this.cube[33];

		this.cube[27] = parkone;
		this.cube[30] = parktwo;
		this.cube[33] = parkthree;

		parkone = this.cube[18];
		parktwo = this.cube[21];

		this.cube[18] = this.cube[24];
		this.cube[21] = this.cube[25];

		this.cube[24] = this.cube[26];
		this.cube[25] = this.cube[23];

		this.cube[26] = this.cube[20];
		this.cube[23] = this.cube[19];

		this.cube[20] = parkone;
		this.cube[19] = parktwo;

		console.log('Rotate Outer Front');
	}

	cube.prototype.RotateOuterFrontInverse = function(){
		var parkone = this.cube[6];
		var parktwo = this.cube[7];
		var parkthree = this.cube[8];

		this.cube[6] = this.cube[27];
		this.cube[7] = this.cube[30];
		this.cube[8] = this.cube[33];

		this.cube[27] = this.cube[38];
		this.cube[30] = this.cube[37];
		this.cube[33] = this.cube[36];

		this.cube[38] = this.cube[17];
		this.cube[37] = this.cube[14];
		this.cube[36] = this.cube[11];

		this.cube[17] = parkone;
		this.cube[14] = parktwo;
		this.cube[11] = parkthree;

		parkone = this.cube[18];
		parktwo = this.cube[21];

		this.cube[18] = this.cube[20];
		this.cube[21] = this.cube[19];

		this.cube[20] = this.cube[26];
		this.cube[19] = this.cube[23];

		this.cube[26] = this.cube[24];
		this.cube[23] = this.cube[25];

		this.cube[24] = parkone;
		this.cube[25] = parktwo;

		console.log('Rotate Outer Front Inverse');
	}

	cube.prototype.RotateOuterBack = function(){
		var parkone = this.cube[0];
		var parktwo = this.cube[1];
		var parkthree = this.cube[2];

		this.cube[0] = this.cube[29];
		this.cube[1] = this.cube[32];
		this.cube[2] = this.cube[35];

		this.cube[29] = this.cube[44];
		this.cube[32] = this.cube[43];
		this.cube[35] = this.cube[42];

		this.cube[44] = this.cube[15];
		this.cube[43] = this.cube[12];
		this.cube[42] = this.cube[9];

		this.cube[15] = parkone;
		this.cube[12] = parktwo;
		this.cube[9] = parkthree;

		parkone = this.cube[45];
		parktwo = this.cube[48];

		this.cube[45] = this.cube[51];
		this.cube[48] = this.cube[52];

		this.cube[51] = this.cube[53];
		this.cube[52] = this.cube[50];

		this.cube[53] = this.cube[47];
		this.cube[50] = this.cube[46];

		this.cube[47] = parkone;
		this.cube[46] = parktwo;

		console.log('Rotate Outer Back');
	}

	cube.prototype.RotateOuterBackInverse = function(){
		var parkone = this.cube[0];
		var parktwo = this.cube[1];
		var parkthree = this.cube[2];

		this.cube[0] = this.cube[15];
		this.cube[1] = this.cube[12];
		this.cube[2] = this.cube[9];

		this.cube[15] = this.cube[44];
		this.cube[12] = this.cube[43];
		this.cube[9] = this.cube[42];

		this.cube[44] = this.cube[29];
		this.cube[43] = this.cube[32];
		this.cube[42] = this.cube[35];

		this.cube[29] = parkone;
		this.cube[32] = parktwo;
		this.cube[35] = parkthree;

		parkone = this.cube[45];
		parktwo = this.cube[48];

		this.cube[45] = this.cube[47];
		this.cube[48] = this.cube[46];

		this.cube[47] = this.cube[53];
		this.cube[46] = this.cube[50];

		this.cube[53] = this.cube[51];
		this.cube[50] = this.cube[52];

		this.cube[51] = parkone;
		this.cube[52] = parktwo;

		console.log('Rotate Outer Back Inverse');
	}

	cube.prototype.RotateOuterUp = function(){
		var parkone = this.cube[18];
		var parktwo = this.cube[19];
		var parkthree = this.cube[20];

		this.cube[18] = this.cube[27];
		this.cube[19] = this.cube[28];
		this.cube[20] = this.cube[29];

		this.cube[27] = this.cube[53];
		this.cube[28] = this.cube[52];
		this.cube[29] = this.cube[51];

		this.cube[53] = this.cube[9];
		this.cube[52] = this.cube[10];
		this.cube[51] = this.cube[11];

		this.cube[9] = parkone;
		this.cube[10] = parktwo;
		this.cube[11] = parkthree;

		parkone = this.cube[0];
		parktwo = this.cube[3];

		this.cube[0] = this.cube[6];
		this.cube[3] = this.cube[7];

		this.cube[6] = this.cube[8];
		this.cube[7] = this.cube[5];

		this.cube[8] = this.cube[2];
		this.cube[5] = this.cube[1];

		this.cube[2] = parkone;
		this.cube[1] = parktwo;

		console.log('Rotate Outer Up');
	}

	cube.prototype.RotateOuterUpInverse = function(){
		var parkone = this.cube[18];
		var parktwo = this.cube[19];
		var parkthree = this.cube[20];

		this.cube[18] = this.cube[9];
		this.cube[19] = this.cube[10];
		this.cube[20] = this.cube[11];

		this.cube[9] = this.cube[53];
		this.cube[10] = this.cube[52];
		this.cube[11] = this.cube[51];

		this.cube[53] = this.cube[27];
		this.cube[52] = this.cube[28];
		this.cube[51] = this.cube[29];

		this.cube[27] = parkone;
		this.cube[28] = parktwo;
		this.cube[29] = parkthree;

		parkone = this.cube[0];
		parktwo = this.cube[3];

		this.cube[0] = this.cube[2];
		this.cube[3] = this.cube[1];

		this.cube[2] = this.cube[8];
		this.cube[1] = this.cube[5];

		this.cube[8] = this.cube[6];
		this.cube[5] = this.cube[7];

		this.cube[6] = parkone;
		this.cube[7] = parktwo;

		console.log('Rotate Outer Up Inverse');
	}

	cube.prototype.RotateOuterDown = function(){
		var parkone = this.cube[24];
		var parktwo = this.cube[25];
		var parkthree = this.cube[26];

		this.cube[24] = this.cube[15];
		this.cube[25] = this.cube[16];
		this.cube[26] = this.cube[17];

		this.cube[15] = this.cube[47];
		this.cube[16] = this.cube[46];
		this.cube[17] = this.cube[45];

		this.cube[47] = this.cube[33];
		this.cube[46] = this.cube[34];
		this.cube[45] = this.cube[35];

		this.cube[33] = parkone;
		this.cube[34] = parktwo;
		this.cube[35] = parkthree;

		parkone = this.cube[36];
		parktwo = this.cube[39];

		this.cube[36] = this.cube[42];								// Hey, you found an Easter-Egg!
		this.cube[39] = this.cube[43];

		this.cube[42] = this.cube[44];
		this.cube[43] = this.cube[41];

		this.cube[44] = this.cube[38];
		this.cube[41] = this.cube[37];

		this.cube[38] = parkone;
		this.cube[37] = parktwo;

		console.log('Rotate Outer Down');
	}

	cube.prototype.RotateOuterDownInverse = function(){
		var parkone = this.cube[24];
		var parktwo = this.cube[25];
		var parkthree = this.cube[26];

		this.cube[24] = this.cube[33];
		this.cube[25] = this.cube[34];
		this.cube[26] = this.cube[35];

		this.cube[33] = this.cube[47];
		this.cube[34] = this.cube[46];
		this.cube[35] = this.cube[45];

		this.cube[47] = this.cube[15];
		this.cube[46] = this.cube[16];
		this.cube[45] = this.cube[17];

		this.cube[15] = parkone;
		this.cube[16] = parktwo;
		this.cube[17] = parkthree;

		parkone = this.cube[36];
		parktwo = this.cube[39];

		this.cube[36] = this.cube[38];
		this.cube[39] = this.cube[37];

		this.cube[38] = this.cube[44];
		this.cube[37] = this.cube[41];

		this.cube[44] = this.cube[42];
		this.cube[41] = this.cube[43];

		this.cube[42] = parkone;
		this.cube[43] = parktwo;

		console.log('Rotate Outer Down Inverse');
	}
}

// Innere Rotations-Funktionen

{
	cube.prototype.RotateInnerMiddle = function(){
		var parkone = this.cube[1];
		var parktwo = this.cube[4];
		var parkthree = this.cube[7];

		this.cube[1] = this.cube[46];
		this.cube[4] = this.cube[49];
		this.cube[7] = this.cube[52];

		this.cube[46] = this.cube[37];
		this.cube[49] = this.cube[40];
		this.cube[52] = this.cube[43];

		this.cube[37] = this.cube[19];
		this.cube[40] = this.cube[22];
		this.cube[43] = this.cube[25];

		this.cube[19] = parkone;
		this.cube[22] = parktwo;
		this.cube[25] = parkthree;

		console.log('Rotate Inner Middle');
	}

	cube.prototype.RotateInnerMiddleInverse = function(){
		var parkone = this.cube[1];
		var parktwo = this.cube[4];
		var parkthree = this.cube[7];

		this.cube[1] = this.cube[19];
		this.cube[4] = this.cube[22];
		this.cube[7] = this.cube[25];

		this.cube[19] = this.cube[37];
		this.cube[22] = this.cube[40];
		this.cube[25] = this.cube[43];

		this.cube[37] = this.cube[46];
		this.cube[40] = this.cube[49];
		this.cube[43] = this.cube[52];

		this.cube[46] = parkone;
		this.cube[49] = parktwo;
		this.cube[52] = parkthree;

		console.log('Rotate Inner Middle Inverse');
	}

	cube.prototype.RotateInnerEquator = function(){
		var parkone = this.cube[21];
		var parktwo = this.cube[22];
		var parkthree = this.cube[23];

		this.cube[21] = this.cube[12];
		this.cube[22] = this.cube[13];
		this.cube[23] = this.cube[14];

		this.cube[12] = this.cube[50];
		this.cube[13] = this.cube[49];
		this.cube[14] = this.cube[48];

		this.cube[50] = this.cube[30];
		this.cube[49] = this.cube[31];
		this.cube[48] = this.cube[32];

		this.cube[30] = parkone;
		this.cube[31] = parktwo;
		this.cube[32] = parkthree;

		console.log('Rotate Inner Equator');
	}

	cube.prototype.RotateInnerEquatorInverse = function(){
		var parkone = this.cube[21];
		var parktwo = this.cube[22];
		var parkthree = this.cube[23];

		this.cube[21] = this.cube[30];
		this.cube[22] = this.cube[31];
		this.cube[23] = this.cube[32];

		this.cube[30] = this.cube[50];
		this.cube[31] = this.cube[49];
		this.cube[32] = this.cube[48];

		this.cube[50] = this.cube[12];
		this.cube[49] = this.cube[13];
		this.cube[48] = this.cube[14];

		this.cube[12] = parkone;
		this.cube[13] = parktwo;
		this.cube[14] = parkthree;

		console.log('Rotate Inner Equator Inverse');
	}

	cube.prototype.RotateInnerStanding = function(){
		var parkone = this.cube[3];
		var parktwo = this.cube[4];
		var parkthree = this.cube[5];

		this.cube[3] = this.cube[16];
		this.cube[4] = this.cube[13];
		this.cube[5] = this.cube[10];

		this.cube[16] = this.cube[41];
		this.cube[13] = this.cube[40];
		this.cube[10] = this.cube[39];

		this.cube[41] = this.cube[28];
		this.cube[40] = this.cube[31];
		this.cube[39] = this.cube[34];

		this.cube[28] = parkone;
		this.cube[31] = parktwo;
		this.cube[34] = parkthree;

		console.log('Rotate Inner Standing');
	}

	cube.prototype.RotateInnerStandingInverse = function(){
		var parkone = this.cube[3];
		var parktwo = this.cube[4];
		var parkthree = this.cube[5];

		this.cube[3] = this.cube[28];
		this.cube[4] = this.cube[31];
		this.cube[5] = this.cube[34];

		this.cube[28] = this.cube[41];
		this.cube[31] = this.cube[40];
		this.cube[34] = this.cube[39];

		this.cube[41] = this.cube[16];
		this.cube[40] = this.cube[13];
		this.cube[39] = this.cube[10];

		this.cube[16] = parkone;
		this.cube[13] = parktwo;
		this.cube[10] = parkthree;

		console.log('Rotate Inner Standing Inverse');
	}
}

// Ganze Rotations-Funktionen

{
	cube.prototype.RotateWholeX = function(){
		// Rotate Outer Right
		var parkone = this.cube[2];
		var parktwo = this.cube[5];
		var parkthree = this.cube[8];

		this.cube[2] = this.cube[20];
		this.cube[5] = this.cube[23];
		this.cube[8] = this.cube[26];

		this.cube[20] = this.cube[38];
		this.cube[23] = this.cube[41];
		this.cube[26] = this.cube[44];

		this.cube[38] = this.cube[47];
		this.cube[41] = this.cube[50];
		this.cube[44] = this.cube[53];

		this.cube[47] = parkone;
		this.cube[50] = parktwo;
		this.cube[53] = parkthree;

		parkone = this.cube[27];
		parktwo = this.cube[30];

		this.cube[27] = this.cube[33];
		this.cube[30] = this.cube[34];

		this.cube[33] = this.cube[35];
		this.cube[34] = this.cube[32];

		this.cube[35] = this.cube[29];
		this.cube[32] = this.cube[28];

		this.cube[29] = parkone;
		this.cube[28] = parktwo;

		// Rotate Inner Middle Inverse
		var parkone = this.cube[1];
		var parktwo = this.cube[4];
		var parkthree = this.cube[7];

		this.cube[1] = this.cube[19];
		this.cube[4] = this.cube[22];
		this.cube[7] = this.cube[25];

		this.cube[19] = this.cube[37];
		this.cube[22] = this.cube[40];
		this.cube[25] = this.cube[43];

		this.cube[37] = this.cube[46];
		this.cube[40] = this.cube[49];
		this.cube[43] = this.cube[52];

		this.cube[46] = parkone;
		this.cube[49] = parktwo;
		this.cube[52] = parkthree;

		// Rotate Outer Left Inverse
		var parkone = this.cube[0];
		var parktwo = this.cube[3];
		var parkthree = this.cube[6];

		this.cube[0] = this.cube[18];
		this.cube[3] = this.cube[21];
		this.cube[6] = this.cube[24];

		this.cube[18] = this.cube[36];
		this.cube[21] = this.cube[39];
		this.cube[24] = this.cube[42];

		this.cube[36] = this.cube[45];
		this.cube[39] = this.cube[48];
		this.cube[42] = this.cube[51];

		this.cube[45] = parkone;
		this.cube[48] = parktwo;
		this.cube[51] = parkthree;

		parkone = this.cube[9];
		parktwo = this.cube[12];

		this.cube[9] = this.cube[11];
		this.cube[12] = this.cube[10];

		this.cube[11] = this.cube[17];
		this.cube[10] = this.cube[14];

		this.cube[17] = this.cube[15];
		this.cube[14] = this.cube[16];

		this.cube[15] = parkone;
		this.cube[16] = parktwo;

		console.log('Rotate Whole X');
	}

	cube.prototype.RotateWholeXInverse = function(){
		// Rotate Outer Right Inverse
		var parkone = this.cube[2];
		var parktwo = this.cube[5];
		var parkthree = this.cube[8];

		this.cube[2] = this.cube[47];
		this.cube[5] = this.cube[50];
		this.cube[8] = this.cube[53];

		this.cube[47] = this.cube[38];
		this.cube[50] = this.cube[41];
		this.cube[53] = this.cube[44];

		this.cube[38] = this.cube[20];
		this.cube[41] = this.cube[23];
		this.cube[44] = this.cube[26];

		this.cube[20] = parkone;
		this.cube[23] = parktwo;
		this.cube[26] = parkthree;

		parkone = this.cube[27];
		parktwo = this.cube[30];

		this.cube[27] = this.cube[29];
		this.cube[30] = this.cube[28];

		this.cube[29] = this.cube[35];
		this.cube[28] = this.cube[32];

		this.cube[35] = this.cube[33];
		this.cube[32] = this.cube[34];

		this.cube[33] = parkone;
		this.cube[34] = parktwo;

		// Rotate Inner Middle
		var parkone = this.cube[1];
		var parktwo = this.cube[4];
		var parkthree = this.cube[7];

		this.cube[1] = this.cube[46];
		this.cube[4] = this.cube[49];
		this.cube[7] = this.cube[52];

		this.cube[46] = this.cube[37];
		this.cube[49] = this.cube[40];
		this.cube[52] = this.cube[43];

		this.cube[37] = this.cube[19];
		this.cube[40] = this.cube[22];
		this.cube[43] = this.cube[25];

		this.cube[19] = parkone;
		this.cube[22] = parktwo;
		this.cube[25] = parkthree;

		// Rotate Outer Left
		var parkone = this.cube[0];
		var parktwo = this.cube[3];
		var parkthree = this.cube[6];

		this.cube[0] = this.cube[45];
		this.cube[3] = this.cube[48];
		this.cube[6] = this.cube[51];

		this.cube[45] = this.cube[36];
		this.cube[48] = this.cube[39];
		this.cube[51] = this.cube[42];

		this.cube[36] = this.cube[18];
		this.cube[39] = this.cube[21];
		this.cube[42] = this.cube[24];

		this.cube[18] = parkone;
		this.cube[21] = parktwo;
		this.cube[24] = parkthree;

		parkone = this.cube[9];
		parktwo = this.cube[12];

		this.cube[9] = this.cube[15];
		this.cube[12] = this.cube[16];

		this.cube[15] = this.cube[17];
		this.cube[16] = this.cube[14];

		this.cube[17] = this.cube[11];
		this.cube[14] = this.cube[10];

		this.cube[11] = parkone;
		this.cube[10] = parktwo;

		console.log('Rotate Whole X Inverse')
	}

	cube.prototype.RotateWholeY = function(){
		// Rotate Outer Up
		var parkone = this.cube[18];
		var parktwo = this.cube[19];
		var parkthree = this.cube[20];

		this.cube[18] = this.cube[27];
		this.cube[19] = this.cube[28];
		this.cube[20] = this.cube[29];

		this.cube[27] = this.cube[53];
		this.cube[28] = this.cube[52];
		this.cube[29] = this.cube[51];

		this.cube[53] = this.cube[9];
		this.cube[52] = this.cube[10];
		this.cube[51] = this.cube[11];

		this.cube[9] = parkone;
		this.cube[10] = parktwo;
		this.cube[11] = parkthree;

		parkone = this.cube[0];
		parktwo = this.cube[3];

		this.cube[0] = this.cube[6];
		this.cube[3] = this.cube[7];

		this.cube[6] = this.cube[8];
		this.cube[7] = this.cube[5];

		this.cube[8] = this.cube[2];
		this.cube[5] = this.cube[1];

		this.cube[2] = parkone;
		this.cube[1] = parktwo;

		// Rotate Inner Equator Inverse
		var parkone = this.cube[21];
		var parktwo = this.cube[22];
		var parkthree = this.cube[23];

		this.cube[21] = this.cube[30];
		this.cube[22] = this.cube[31];
		this.cube[23] = this.cube[32];

		this.cube[30] = this.cube[50];
		this.cube[31] = this.cube[49];
		this.cube[32] = this.cube[48];

		this.cube[50] = this.cube[12];
		this.cube[49] = this.cube[13];
		this.cube[48] = this.cube[14];

		this.cube[12] = parkone;
		this.cube[13] = parktwo;
		this.cube[14] = parkthree;

		// Rotate Outer Down Inverse
		var parkone = this.cube[24];
		var parktwo = this.cube[25];
		var parkthree = this.cube[26];

		this.cube[24] = this.cube[33];
		this.cube[25] = this.cube[34];
		this.cube[26] = this.cube[35];

		this.cube[33] = this.cube[47];
		this.cube[34] = this.cube[46];
		this.cube[35] = this.cube[45];

		this.cube[47] = this.cube[15];
		this.cube[46] = this.cube[16];
		this.cube[45] = this.cube[17];

		this.cube[15] = parkone;
		this.cube[16] = parktwo;
		this.cube[17] = parkthree;

		parkone = this.cube[36];
		parktwo = this.cube[39];

		this.cube[36] = this.cube[38];
		this.cube[39] = this.cube[37];

		this.cube[38] = this.cube[44];
		this.cube[37] = this.cube[41];

		this.cube[44] = this.cube[42];
		this.cube[41] = this.cube[43];

		this.cube[42] = parkone;
		this.cube[43] = parktwo;

		console.log('Rotate Whole Y');
	}

	cube.prototype.RotateWholeYInverse = function(){
		// Rotate Outer Up Inverse
		var parkone = this.cube[18];
		var parktwo = this.cube[19];
		var parkthree = this.cube[20];

		this.cube[18] = this.cube[9];
		this.cube[19] = this.cube[10];
		this.cube[20] = this.cube[11];

		this.cube[9] = this.cube[53];
		this.cube[10] = this.cube[52];
		this.cube[11] = this.cube[51];

		this.cube[53] = this.cube[27];
		this.cube[52] = this.cube[28];
		this.cube[51] = this.cube[29];

		this.cube[27] = parkone;
		this.cube[28] = parktwo;
		this.cube[29] = parkthree;

		parkone = this.cube[0];
		parktwo = this.cube[3];

		this.cube[0] = this.cube[2];
		this.cube[3] = this.cube[1];

		this.cube[2] = this.cube[8];
		this.cube[1] = this.cube[5];

		this.cube[8] = this.cube[6];
		this.cube[5] = this.cube[7];

		this.cube[6] = parkone;
		this.cube[7] = parktwo;

		// Rotate Inner Equator
		var parkone = this.cube[21];
		var parktwo = this.cube[22];
		var parkthree = this.cube[23];

		this.cube[21] = this.cube[12];
		this.cube[22] = this.cube[13];
		this.cube[23] = this.cube[14];

		this.cube[12] = this.cube[50];
		this.cube[13] = this.cube[49];
		this.cube[14] = this.cube[48];

		this.cube[50] = this.cube[30];
		this.cube[49] = this.cube[31];
		this.cube[48] = this.cube[32];

		this.cube[30] = parkone;
		this.cube[31] = parktwo;
		this.cube[32] = parkthree;

		// Rotate Outer Down
		var parkone = this.cube[24];
		var parktwo = this.cube[25];
		var parkthree = this.cube[26];

		this.cube[24] = this.cube[15];
		this.cube[25] = this.cube[16];
		this.cube[26] = this.cube[17];

		this.cube[15] = this.cube[47];
		this.cube[16] = this.cube[46];
		this.cube[17] = this.cube[45];

		this.cube[47] = this.cube[33];
		this.cube[46] = this.cube[34];
		this.cube[45] = this.cube[35];

		this.cube[33] = parkone;
		this.cube[34] = parktwo;
		this.cube[35] = parkthree;

		parkone = this.cube[36];
		parktwo = this.cube[39];

		this.cube[36] = this.cube[42];
		this.cube[39] = this.cube[43];

		this.cube[42] = this.cube[44];
		this.cube[43] = this.cube[41];

		this.cube[44] = this.cube[38];
		this.cube[41] = this.cube[37];

		this.cube[38] = parkone;
		this.cube[37] = parktwo;

		console.log('Rotate Whole Y Inverse');
	}

	cube.prototype.RotateWholeZ = function(){
		// Rotate Outer Front
		var parkone = this.cube[6];
		var parktwo = this.cube[7];
		var parkthree = this.cube[8];

		this.cube[6] = this.cube[17];
		this.cube[7] = this.cube[14];
		this.cube[8] = this.cube[11];

		this.cube[17] = this.cube[38];
		this.cube[14] = this.cube[37];
		this.cube[11] = this.cube[36];

		this.cube[38] = this.cube[27];
		this.cube[37] = this.cube[30];
		this.cube[36] = this.cube[33];

		this.cube[27] = parkone;
		this.cube[30] = parktwo;
		this.cube[33] = parkthree;

		parkone = this.cube[18];
		parktwo = this.cube[21];

		this.cube[18] = this.cube[24];
		this.cube[21] = this.cube[25];

		this.cube[24] = this.cube[26];
		this.cube[25] = this.cube[23];

		this.cube[26] = this.cube[20];
		this.cube[23] = this.cube[19];

		this.cube[20] = parkone;
		this.cube[19] = parktwo;

		// Rotate Inner Standing
		var parkone = this.cube[3];
		var parktwo = this.cube[4];
		var parkthree = this.cube[5];

		this.cube[3] = this.cube[16];
		this.cube[4] = this.cube[13];
		this.cube[5] = this.cube[10];

		this.cube[16] = this.cube[41];
		this.cube[13] = this.cube[40];
		this.cube[10] = this.cube[39];

		this.cube[41] = this.cube[28];
		this.cube[40] = this.cube[31];
		this.cube[39] = this.cube[34];

		this.cube[28] = parkone;
		this.cube[31] = parktwo;
		this.cube[34] = parkthree;
		
		// Rotate Outer Back Inverse
		var parkone = this.cube[0];
		var parktwo = this.cube[1];
		var parkthree = this.cube[2];

		this.cube[0] = this.cube[15];
		this.cube[1] = this.cube[12];
		this.cube[2] = this.cube[9];

		this.cube[15] = this.cube[44];
		this.cube[12] = this.cube[43];
		this.cube[9] = this.cube[42];

		this.cube[44] = this.cube[29];
		this.cube[43] = this.cube[32];
		this.cube[42] = this.cube[35];

		this.cube[29] = parkone;
		this.cube[32] = parktwo;
		this.cube[35] = parkthree;

		parkone = this.cube[45];
		parktwo = this.cube[48];

		this.cube[45] = this.cube[47];
		this.cube[48] = this.cube[46];

		this.cube[47] = this.cube[53];
		this.cube[46] = this.cube[50];

		this.cube[53] = this.cube[51];
		this.cube[50] = this.cube[52];

		this.cube[51] = parkone;
		this.cube[52] = parktwo;

		console.log('Rotate Whole Z');
	}
	cube.prototype.RotateWholeZInverse = function(){
		// Rotate Outer Front Inverse
		var parkone = this.cube[6];
		var parktwo = this.cube[7];
		var parkthree = this.cube[8];

		this.cube[6] = this.cube[27];
		this.cube[7] = this.cube[30];
		this.cube[8] = this.cube[33];

		this.cube[27] = this.cube[38];
		this.cube[30] = this.cube[37];
		this.cube[33] = this.cube[36];

		this.cube[38] = this.cube[17];
		this.cube[37] = this.cube[14];
		this.cube[36] = this.cube[11];

		this.cube[17] = parkone;
		this.cube[14] = parktwo;
		this.cube[11] = parkthree;

		parkone = this.cube[18];
		parktwo = this.cube[21];

		this.cube[18] = this.cube[20];
		this.cube[21] = this.cube[19];

		this.cube[20] = this.cube[26];
		this.cube[19] = this.cube[23];

		this.cube[26] = this.cube[24];
		this.cube[23] = this.cube[25];

		this.cube[24] = parkone;
		this.cube[25] = parktwo;

		// Rotate Inner Standing Inverse
		var parkone = this.cube[3];
		var parktwo = this.cube[4];
		var parkthree = this.cube[5];

		this.cube[3] = this.cube[28];
		this.cube[4] = this.cube[31];
		this.cube[5] = this.cube[34];

		this.cube[28] = this.cube[41];
		this.cube[31] = this.cube[40];
		this.cube[34] = this.cube[39];

		this.cube[41] = this.cube[16];
		this.cube[40] = this.cube[13];
		this.cube[39] = this.cube[10];

		this.cube[16] = parkone;
		this.cube[13] = parktwo;
		this.cube[10] = parkthree;

		// Rotate Outer Back
		var parkone = this.cube[0];
		var parktwo = this.cube[1];
		var parkthree = this.cube[2];

		this.cube[0] = this.cube[29];
		this.cube[1] = this.cube[32];
		this.cube[2] = this.cube[35];

		this.cube[29] = this.cube[44];
		this.cube[32] = this.cube[43];
		this.cube[35] = this.cube[42];

		this.cube[44] = this.cube[15];
		this.cube[43] = this.cube[12];
		this.cube[42] = this.cube[9];

		this.cube[15] = parkone;
		this.cube[12] = parktwo;
		this.cube[9] = parkthree;

		parkone = this.cube[45];
		parktwo = this.cube[48];

		this.cube[45] = this.cube[51];
		this.cube[48] = this.cube[52];

		this.cube[51] = this.cube[53];
		this.cube[52] = this.cube[50];

		this.cube[53] = this.cube[47];
		this.cube[50] = this.cube[46];

		this.cube[47] = parkone;
		this.cube[46] = parktwo;

		console.log('Rotate Whole Z Inverse');
	}
}

// Hilfsalgorithmen

{
	// Algorithmus, der zusammenhängende Stücke findet

	cube.prototype.CounterCorner = function(arrindex){
		var arr = [];

		// Fängt falsche Eingaben ab
		if(arrindex == 4 || arrindex == 13 || arrindex == 22 || arrindex == 31 || arrindex == 40 || arrindex == 49)
			arr.push(-1);

		else if(arrindex == 0)
			arr.push(9,51);
		else if(arrindex == 2)
			arr.push(53,29);
		else if(arrindex == 6)
			arr.push(18,11);
		else if(arrindex == 8)
			arr.push(27,20);

		else if(arrindex == 9)
			arr.push(51,0);
		else if(arrindex == 11)
			arr.push(6,18);
		else if(arrindex == 15)
			arr.push(42,45);
		else if(arrindex == 17)
			arr.push(24,36);

		else if(arrindex == 18)
			arr.push(11,6);
		else if(arrindex == 20)
			arr.push(8,27);
		else if(arrindex == 24)
			arr.push(36,17);
		else if(arrindex == 26)
			arr.push(33,38);

		else if(arrindex == 27)
			arr.push(20,8);
		else if(arrindex == 29)
			arr.push(2,53);
		else if(arrindex == 33)
			arr.push(38,26);
		else if(arrindex == 35)
			arr.push(47,44);

		else if(arrindex == 36)
			arr.push(17,24);
		else if(arrindex == 38)
			arr.push(26,33);
		else if(arrindex == 42)
			arr.push(45,15);
		else if(arrindex == 44)
			arr.push(35,47);

		else if(arrindex == 45)
			arr.push(15,42);
		else if(arrindex == 47)
			arr.push(44,35);
		else if(arrindex == 51)
			arr.push(0,9);
		else if(arrindex == 53)
			arr.push(29,2);

		else
			arr.push(-1);

		return arr;
	}

	cube.prototype.CounterBorder = function(arrindex){
		var arr = [];

		// Fängt falsche Eingaben ab
		if(arrindex == 4 || arrindex == 13 || arrindex == 22 || arrindex == 31 || arrindex == 40 || arrindex == 49)
			arr.push(-1);

		else if(arrindex == 1)
			arr.push(52);
		else if(arrindex == 3)
			arr.push(10);
		else if(arrindex == 5)
			arr.push(28);
		else if(arrindex == 7)
			arr.push(19);

		else if(arrindex == 10)
			arr.push(3);
		else if(arrindex == 12)
			arr.push(48);
		else if(arrindex == 14)
			arr.push(21);
		else if(arrindex == 16)
			arr.push(39);

		else if(arrindex == 19)
			arr.push(7);
		else if(arrindex == 21)
			arr.push(14);
		else if(arrindex == 23)
			arr.push(30);
		else if(arrindex == 25)
			arr.push(37);

		else if(arrindex == 28)
			arr.push(5);
		else if(arrindex == 30)
			arr.push(23);
		else if(arrindex == 32)
			arr.push(50);
		else if(arrindex == 34)
			arr.push(41);

		else if(arrindex == 37)
			arr.push(25);
		else if(arrindex == 39)
			arr.push(16);
		else if(arrindex == 41)
			arr.push(34);
		else if(arrindex == 43)
			arr.push(46);

		else if(arrindex == 46)
			arr.push(43);
		else if(arrindex == 48)
			arr.push(12);
		else if(arrindex == 50)
			arr.push(32);
		else if(arrindex == 52)
			arr.push(1);

		else
			arr.push(-1);

		return arr;
	}

	// Algorithmus, der die Gegenfarbe ausliefert (z.B. Gelb zu Weiß)		// ???

	// cube.prototype.CounterColor = function(color){
	// 	switch
	// }

	// Such-Algorithmus, um Ecken und Kanten zu finden

	cube.prototype.FindCorner = function(colorone,colortwo,colorthree){
		for(i=0;i<54;i++)
		{
			if(this.cube[i] == colorone)
			{
				if(this.cube[this.CounterCorner(i)[0]] == colortwo)
				{
					if(this.cube[this.CounterCorner(i)[1]] == colorthree)
					{
						return i;
					}
				}
			}
		}
	}

	cube.prototype.FindBorder = function(colorone,colortwo){
		for(i=0;i<54;i++)
		{
			if(this.cube[i] == colorone)
			{
				if(this.cube[this.CounterBorder(i)[0]] == colortwo)
				{
					return i;
				}
			}
		}
	}

	cube.prototype.FindCenter = function(colorone){
		for(i=4;i<54;i+=9)
		{
			if(this.cube[i] == colorone)
			{
				return i;
			}
		}
	}

	cube.prototype.TurnFrontDown = function(color){
		var position = this.FindBorder(color,cubeyellow);
		switch(position)
		{
			case 1:
			case this.CounterBorder(1)[0]:
				this.RotateOuterUp();
				this.RotateOuterUp();
				break;

			case 3:
			case this.CounterBorder(3)[0]:
				this.RotateOuterUpInverse();
				break;

			case 5:
			case this.CounterBorder(5)[0]:
				this.RotateOuterUp();
				break;

			case 7:
			case this.CounterBorder(7)[0]:
			default:
				break;
		}
	}
}

// Algorithmen zum Lösen

cube.prototype.ColorUp = function(color){
	if(this.cube[13] == color)
	{
		this.RotateWholeZ();
	}
	else if(this.cube[22] == color)
	{
		this.RotateWholeX();
	}
	else if(this.cube[31] == color)
	{
		this.RotateWholeZInverse();
	}
	else if(this.cube[40] == color)
	{
		this.RotateWholeZ();
		this.RotateWholeZ();
	}
	else if(this.cube[49] == color)
	{
		this.RotateWholeXInverse();
	}
}

cube.prototype.TurnFrontCenter = function(color){
	var position = this.FindCenter(color);
	switch(position)
	{
		case 13:
			this.RotateWholeYInverse();
			break;

		case 31:
			this.RotateWholeY();
			break;

		case 49:
			this.RotateWholeY();
			this.RotateWholeY();
			break;

		case 22:
		case 40:
		default:
			break;
	}
}

cube.prototype.TurnDown = function(colorone,colortwo){
	var position = this.FindBorder(colorone,colortwo);
	switch(position)
	{
		case 16:
		case this.CounterBorder(16)[0]:
			this.RotateOuterDown();
			break;

		case 34:
		case this.CounterBorder(34)[0]:
			this.RotateOuterDownInverse();
			break;

		case 46:
		case this.CounterBorder(46)[0]:
			this.RotateOuterDown();
			this.RotateOuterDown();
			break;

		case 25:
		case this.CounterBorder(25)[0]:
		default:
			break;
	}
}

// 1. Ebene
// Weißes Kreuz

// Kanten-Positionierungen und -Drehungen

{
	cube.prototype.BorderUp = function(UpColor,FrontColor){
		var position = this.FindBorder(UpColor,FrontColor);
		switch(position)
		{
			case 1:
			case this.CounterBorder(1)[0]:
			case 3:
			case this.CounterBorder(3)[0]:
			case 5:
			case this.CounterBorder(5)[0]:
			case 7:
			case this.CounterBorder(7)[0]:
				this.BorderUpUp(position);
				break;

			case 12:
			case this.CounterBorder(12)[0]:
			case 21:
			case this.CounterBorder(21)[0]:
			case 30:
			case this.CounterBorder(30)[0]:
			case 50:
			case this.CounterBorder(50)[0]:
				this.BorderUpMiddle(position);
				break;

			case 37:
			case this.CounterBorder(37)[0]:
			case 39:
			case this.CounterBorder(39)[0]:
			case 41:
			case this.CounterBorder(41)[0]:
			case 43:
			case this.CounterBorder(43)[0]:
				this.BorderUpDown(position);
				break;

			default:
				break;
		}
		this.BorderFlipUp(UpColor,FrontColor);
	}

	// Bewegt das gewünschte Feld an die Kante vorne-oben, wenn es vorher auf der oberen Ebene ist

	cube.prototype.BorderUpUp = function(position){
		switch(position)
		{
			case 1:
			case this.CounterBorder(1)[0]:
				this.RotateOuterBack();
				this.RotateInnerEquator();
				this.RotateInnerEquator();
				this.RotateOuterFrontInverse();
				this.RotateInnerEquatorInverse();
				this.RotateInnerEquatorInverse();
				break;

			case 3:
			case this.CounterBorder(3)[0]:
				this.RotateOuterLeft();
				this.RotateInnerEquator();
				this.RotateOuterFrontInverse();
				this.RotateInnerEquatorInverse();
				break;

			case 5:
			case this.CounterBorder(5)[0]:
				this.RotateOuterRightInverse();
				this.RotateOuterFrontInverse();
				break;

			case 7:
			case this.CounterBorder(7)[0]:
			default:
				break;
		}
	}

	// Bewegt das gewünschte Feld an die Kante vorne-oben, wenn es vorher auf der mittleren Ebene ist

	cube.prototype.BorderUpMiddle = function(position){
		switch(position)
		{
			case 12:
			case this.CounterBorder(12)[0]:
				this.RotateInnerEquator();
				this.RotateOuterFront();
				this.RotateInnerEquatorInverse();
				break;

			case 21:
			case this.CounterBorder(21)[0]:
				this.RotateOuterFront();
				break;

			case 30:
			case this.CounterBorder(30)[0]:
				this.RotateInnerEquatorInverse();
				this.RotateOuterFront();
				this.RotateInnerEquator();
				break;

			case 50:
			case this.CounterBorder(50)[0]:		
				this.RotateInnerEquator();
				this.RotateInnerEquator();
				this.RotateOuterFront();
				this.RotateInnerEquatorInverse();
				this.RotateInnerEquatorInverse();
				break;

			default:
				break;
		}

	}

	// Bewegt das gewünschte Feld an die Kante vorne-oben, wenn es vorher auf der unteren Ebene ist

	cube.prototype.BorderUpDown = function(position){
		switch(position)
		{
			case 37:
			case this.CounterBorder(37)[0]:
				this.RotateOuterFront();
				this.RotateOuterFront();
				break;

			case 39:
			case this.CounterBorder(39)[0]:
				this.RotateOuterDown();
				this.RotateOuterFront();
				this.RotateOuterFront();
				break;

			case 41:
			case this.CounterBorder(41)[0]:
				this.RotateOuterDownInverse();
				this.RotateOuterFront();
				this.RotateOuterFront();
				break;

			case 43:
			case this.CounterBorder(43)[0]:
				this.RotateOuterDown();
				this.RotateOuterDown();
				this.RotateOuterFront();
				this.RotateOuterFront();
				break;

			default:
				break;
		}

	}

	// Kippt die Kante vorne-oben, wenn nötig
	cube.prototype.BorderFlipUp = function(UpColor,FrontColor){
		var position = this.FindBorder(UpColor,FrontColor);
		switch(position)
		{
			case 19:
				this.RotateOuterFront();
				this.RotateOuterUpInverse();
				this.RotateOuterRight();
				this.RotateOuterUp();
				break;

			case 7:
			default:
				break;
		}
	}
}

// Erstellen des weißen Kreuzes (momentan noch Farben vor-ausgewählt)

cube.prototype.ColorCross = function(UpColor){
	this.ColorUp(cubewhite);
	this.TurnFrontCenter(cubeblue);
	this.BorderUp(cubewhite,cubeblue);
	this.TurnFrontCenter(cubered);
	this.BorderUp(cubewhite,cubered);
	this.TurnFrontCenter(cubegreen);
	this.BorderUp(cubewhite,cubegreen);
	this.TurnFrontCenter(cubeorange);
	this.BorderUp(cubewhite,cubeorange);
}

// Ecken-Positionierungen und -Drehungen

{
	cube.prototype.CornerUp = function(UpColor,SideColor,FrontColor){
		var position = this.FindCorner(UpColor,SideColor,FrontColor);
		switch(position)
		{
			case 0:
			case this.CounterCorner(0)[0]:
			case this.CounterCorner(0)[1]:
			case 2:
			case this.CounterCorner(2)[0]:
			case this.CounterCorner(2)[1]:
			case 6:
			case this.CounterCorner(6)[0]:
			case this.CounterCorner(6)[1]:
			case 8:
			case this.CounterCorner(8)[0]:
			case this.CounterCorner(8)[1]:
				this.CornerUpUp(position);
				break;

			case 36:
			case this.CounterCorner(36)[0]:
			case this.CounterCorner(36)[1]:
			case 38:
			case this.CounterCorner(38)[0]:
			case this.CounterCorner(38)[1]:
			case 42:
			case this.CounterCorner(42)[0]:
			case this.CounterCorner(42)[1]:
			case 44:
			case this.CounterCorner(44)[0]:
			case this.CounterCorner(44)[1]:
				this.CornerUpDown(position);
				break;

			default:
				break;
		}
		this.CornerUpFlip(UpColor,SideColor,FrontColor);
	}

	// Bewegt das gewünschte Feld an die Ecke vorne-oben-rechts, wenn es vorher auf der oberen Ebene ist

	cube.prototype.CornerUpUp = function(position){
		switch(position)
		{
			case 0:
			case this.CounterCorner(0)[0]:
			case this.CounterCorner(0)[1]:
				this.RotateOuterBack();
				this.RotateOuterDown();
				this.RotateOuterBackInverse();
				this.RotateOuterRightInverse();
				this.RotateOuterDown();
				this.RotateOuterRight();
				break;

			case 2:
			case this.CounterCorner(2)[0]:
			case this.CounterCorner(2)[1]:
				this.RotateOuterRight();
				this.RotateOuterDown();
				this.RotateOuterDown();
				this.RotateOuterRightInverse();
				this.RotateOuterRightInverse();
				this.RotateOuterDown();
				this.RotateOuterRight();
				break;

			case 6:
			case this.CounterCorner(6)[0]:
			case this.CounterCorner(6)[1]:
				this.RotateOuterLeft();
				this.RotateOuterRightInverse();
				this.RotateOuterDown();
				this.RotateOuterRight();
				this.RotateOuterLeftInverse();
				break;

			case 8:
			case this.CounterCorner(8)[0]:
			case this.CounterCorner(8)[1]:
			default:
				break;
		}
	}

	// Bewegt das gewünschte Feld an die Ecke vorne-oben-rechts, wenn es vorher auf der unteren Ebene ist

	cube.prototype.CornerUpDown = function(position){
		switch(position)
		{
			case 36:
			case this.CounterCorner(36)[0]:
			case this.CounterCorner(36)[1]:
				this.RotateOuterRightInverse();
				this.RotateOuterDown();
				this.RotateOuterRight();
				break;

			case 38:
			case this.CounterCorner(38)[0]:
			case this.CounterCorner(38)[1]:
				this.RotateOuterDownInverse();
				this.RotateOuterRightInverse();
				this.RotateOuterDown();
				this.RotateOuterRight();
				break;

			case 42:
			case this.CounterCorner(42)[0]:
			case this.CounterCorner(42)[1]:
				this.RotateOuterDown();
				this.RotateOuterRightInverse();
				this.RotateOuterDown();
				this.RotateOuterRight();
				break;

			case 44:
			case this.CounterCorner(44)[0]:
			case this.CounterCorner(44)[1]:
				this.RotateOuterDown();
				this.RotateOuterDown();
				this.RotateOuterRightInverse();
				this.RotateOuterDown();
				this.RotateOuterRight();
				break;

			default:
				break;
		}
	}

	cube.prototype.CornerUpFlip = function(UpColor,SideColor,FrontColor){
		var position = this.FindCorner(UpColor,SideColor,FrontColor);
		switch(position)
		{
			case 27:
				this.RotateOuterRightInverse();
				this.RotateOuterDownInverse();
				this.RotateOuterRight();
				this.RotateOuterDown();
				this.RotateOuterRightInverse();
				this.RotateOuterDownInverse();
				this.RotateOuterRight();
				break;

			case 20:
				this.RotateOuterRightInverse();
				this.RotateOuterDownInverse();
				this.RotateOuterRight();
				this.RotateOuterDown();
				this.RotateOuterRightInverse();
				this.RotateOuterDownInverse();
				this.RotateOuterDownInverse();
				this.RotateOuterRight();
				this.RotateOuterDown();
				this.RotateOuterRightInverse();
				this.RotateOuterDownInverse();
				this.RotateOuterRight();
				break;

			case 8:
			default:
				break;
		}
	}
}

// Vervollständigung der weißen Ebene (momentan noch Farben vor-ausgewählt)

cube.prototype.ColorLayer = function(UpColor){
	this.TurnFrontCenter(cubeblue);
	this.CornerUp(cubewhite,cubeorange,cubeblue);
	this.TurnFrontCenter(cubered);
	this.CornerUp(cubewhite,cubeblue,cubered);
	this.TurnFrontCenter(cubegreen);
	this.CornerUp(cubewhite,cubered,cubegreen);
	this.TurnFrontCenter(cubeorange);
	this.CornerUp(cubewhite,cubegreen,cubeorange);
}

// 2. Ebene
// Kanten-Positionierungen

{
	cube.prototype.BorderMiddle = function(UpColor,FrontColor,SideColor){
		var position = this.FindBorder(FrontColor,SideColor);
		switch(position)
		{
			case this.CounterBorder(23)[0]:									// Für den Fall, dass der Stein zwar schon an der richtigen Stelle ist, aber verdreht ist
			case 14:
			case this.CounterBorder(14)[0]:
			case 48:
			case this.CounterBorder(48)[0]:
			case 32:
			case this.CounterBorder(32)[0]:
				this.BorderMiddleMiddle(position);
				break;

			case 25:
			case this.CounterBorder(25)[0]:
			case 16:
			case this.CounterBorder(16)[0]:
			case 46:
			case this.CounterBorder(46)[0]:
			case 34:
			case this.CounterBorder(34)[0]:
				this.BorderMiddleDown(position);
				break;

			case 23:
			default:
				break;
		}
	}

	// Führt die Kantenbewegung von der falschen Mitte zur richtigen Mitte aus

	cube.prototype.BorderMiddleMiddle = function(position){
		switch(position)
		{
			case this.CounterBorder(23)[0]:
				this.BorderSwitchMiddleDown("right");
				this.RotateOuterDown();
				this.RotateOuterDown();
				this.BorderSwitchMiddleDown("right");
				break;

			case 14:
				this.RotateWholeYInverse();
				this.BorderSwitchMiddleDown("right");
				this.RotateWholeY();
				this.RotateWholeY();
				this.BorderSwitchMiddleDown("left");
				break;

			case this.CounterBorder(14)[0]:
				this.BorderSwitchMiddleDown("left");
				this.RotateWholeY();
				this.RotateOuterDownInverse();
				this.BorderSwitchMiddleDown("left");
				break;

			case 48:
				this.RotateWholeYInverse();
				this.RotateWholeYInverse();
				this.BorderSwitchMiddleDown("right");
				this.RotateWholeYInverse();
				this.RotateOuterDown();
				this.BorderSwitchMiddleDown("left");
				break;

			case this.CounterBorder(48)[0]:
				this.RotateWholeYInverse();
				this.BorderSwitchMiddleDown("left");
				this.RotateWholeYInverse();
				this.RotateWholeYInverse();
				this.BorderSwitchMiddleDown("left");
				break;

			case 32:
				this.RotateWholeY();
				this.BorderSwitchMiddleDown("right");
				this.RotateOuterDownInverse();
				this.RotateOuterDownInverse();
				this.BorderSwitchMiddleDown("left");
				break;

			case this.CounterBorder(32)[0]:
				this.RotateWholeY();
				this.RotateWholeY();
				this.BorderSwitchMiddleDown("left");
				this.RotateWholeYInverse();
				this.RotateOuterDown();
				this.BorderSwitchMiddleDown("left");
				break;

			case 23:
			default:
				break;
		}
	}

	// Führt die Kantenbewegung von unten zur Mitte aus

	cube.prototype.BorderMiddleDown = function(position){
		switch(position)
		{
			case 25:
				this.BorderSwitchMiddleDown("right");
				break;

			case this.CounterBorder(25)[0]:
				this.RotateWholeY();
				this.RotateOuterDown();
				this.BorderSwitchMiddleDown("left");
				break;

			case 16:
				this.RotateOuterDown();
				this.BorderSwitchMiddleDown("right");
				break;

			case this.CounterBorder(16)[0]:
				this.RotateWholeY();
				this.RotateOuterDown();
				this.RotateOuterDown();
				this.BorderSwitchMiddleDown("left");
				break;

			case 46:
				this.RotateOuterDown();
				this.RotateOuterDown();
				this.BorderSwitchMiddleDown("right");
				break;

			case this.CounterBorder(46)[0]:
				this.RotateWholeY();
				this.RotateOuterDownInverse();
				this.BorderSwitchMiddleDown("left");
				break;

			case 34:
				this.RotateOuterDownInverse();
				this.BorderSwitchMiddleDown("right");
				break;

			case this.CounterBorder(34)[0]:
				this.RotateWholeY();
				this.BorderSwitchMiddleDown("left");
				break;

			default:
				break;
		}
	}

	// Algorithmus zum Tauschen

	cube.prototype.BorderSwitchMiddleDown = function(direction){
		switch(direction)
		{
			case 'left':
				this.RotateOuterDown();
				this.RotateOuterLeft();
				this.RotateOuterDownInverse();
				this.RotateOuterLeftInverse();
				this.RotateOuterDownInverse();
				this.RotateOuterFrontInverse();
				this.RotateOuterDown();
				this.RotateOuterFront();
				break;

			case 'right':
				this.RotateOuterDownInverse();
				this.RotateOuterRightInverse();
				this.RotateOuterDown();
				this.RotateOuterRight();
				this.RotateOuterDown();
				this.RotateOuterFront();
				this.RotateOuterDownInverse();
				this.RotateOuterFrontInverse();
				break;

			default:
				break;
		}
	}
}

// Vervollständigung der zweiten Ebene

cube.prototype.BorderAlign = function(UpColor){
	this.TurnFrontCenter(cubeblue);
	this.BorderMiddle(cubewhite,cubeblue,cubeorange);
	this.TurnFrontCenter(cubered);
	this.BorderMiddle(cubewhite,cubered,cubeblue);
	this.TurnFrontCenter(cubegreen);
	this.BorderMiddle(cubewhite,cubegreen,cubered);
	this.TurnFrontCenter(cubeorange);
	this.BorderMiddle(cubewhite,cubeorange,cubegreen);
}

// 3. Ebene
// Kanten-Positionierungen und -Drehungen

{	
	cube.prototype.BorderDown = function(UpColor){
		this.TurnFrontDown(cubeblue,cubeyellow);
		var positionred = this.FindBorder(cubered,cubeyellow);
		var positiongreen = this.FindBorder(cubegreen,cubeyellow);
		var positionorange = this.FindBorder(cubeorange,cubeyellow);
		this.BorderDownDown(positionred,positiongreen,positionorange);
		this.TurnFrontDown(cubeblue,cubeyellow);
		this.BorderFlipDown(cubewhite);
	}

	cube.prototype.BorderDownDown = function(positionred,positiongreen,positionorange){
		var pos = new Array(3);
		switch(positionred)
		{
			case 1:
			case this.CounterBorder(1)[0]:
				pos[1] = "r";
				break;

			case 3:
			case this.CounterBorder(3)[0]:
				pos[2] = "r";
				break;

			case 5:
			case this.CounterBorder(5)[0]:
				pos[0] = "r";
				break;

			default:
				break;
		}
		switch(positiongreen)
		{
			case 1:
			case this.CounterBorder(1)[0]:
				pos[1] = "g";
				break;

			case 3:
			case this.CounterBorder(3)[0]:
				pos[2] = "g";
				break;

			case 5:
			case this.CounterBorder(5)[0]:
				pos[0] = "g";
				break;

			default:
				break;
		}
		switch(positionorange)
		{
			case 1:
			case this.CounterBorder(1)[0]:
				pos[1] = "o";
				break;

			case 3:
			case this.CounterBorder(3)[0]:
				pos[2] = "o";
				break;

			case 5:
			case this.CounterBorder(5)[0]:
				pos[0] = "o";
				break;

			default:
				break;
		}
		switch(pos.join(','))
		{
			case 'r,o,g':
				this.RotateOuterUpInverse();
				this.BorderSwitchDownDown("left");
				break;

			case 'g,r,o':
				this.RotateOuterUp();
				this.BorderSwitchDownDown("right");
				break;

			case 'g,o,r':
				this.RotateOuterUp();
				this.RotateOuterUp();
				this.BorderSwitchDownDown("right");
				this.BorderSwitchDownDown("left");
				break;

			case 'o,g,r':
				this.RotateOuterUp();
				this.BorderSwitchDownDown("left");
				this.RotateOuterUp();
				this.BorderSwitchDownDown("right");
				break;
			
			case 'o,r,g':
				this.RotateOuterUp();
				this.BorderSwitchDownDown("right");
				this.RotateOuterUp();
				this.BorderSwitchDownDown("right");
				break;

			case 'r,g,o':
			default:
				break;
		}
	}

	cube.prototype.BorderSwitchDownDown = function(direction){
		switch(direction)
		{
			case 'left':
				this.RotateOuterUp();
				this.RotateOuterFront();
				this.RotateOuterRight();
				this.RotateOuterUp();
				this.RotateOuterRightInverse();
				this.RotateOuterUpInverse();
				this.RotateOuterFrontInverse();
				break;

			case 'right':
				this.RotateOuterUpInverse();
				this.RotateOuterFrontInverse();
				this.RotateOuterLeftInverse();
				this.RotateOuterUpInverse();
				this.RotateOuterLeft();
				this.RotateOuterUp();
				this.RotateOuterFront();
				break;

			default:
				break;
		}

	}

	cube.prototype.BorderFlipDown = function(UpColor){
		var FalseBorderCount = 0;
		var FalseBorderPosition = 0;
		var positionblueyellow = this.FindBorder(cubeyellow,cubeblue);
		var positionredyellow = this.FindBorder(cubeyellow,cubered);
		var positiongreenyellow = this.FindBorder(cubeyellow,cubegreen);
		var positionorangeyellow = this.FindBorder(cubeyellow,cubeorange);
		switch(positionblueyellow)
		{
			case this.CounterBorder(7)[0]:
				FalseBorderCount++;
				FalseBorderPosition+=1;
				break;

			case '7':
			default:
				break;
		}
		switch(positionredyellow)
		{
			case this.CounterBorder(5)[0]:
				FalseBorderCount++;
				FalseBorderPosition+=2;
				break;

			case '5':
			default:
				break;
		}
		switch(positiongreenyellow)
		{
			case this.CounterBorder(1)[0]:
				FalseBorderCount++;
				FalseBorderPosition+=4;
				break;

			case '1':
			default:
				break;
		}
		switch(positionorangeyellow)
		{
			case this.CounterBorder(3)[0]:
				FalseBorderCount++;
				FalseBorderPosition+=8;
				break;

			case '3':
			default:
				break;
		}
		// console.log(FalseBorderCount);					// Ausgabe zum Debuggen
		// console.log(FalseBorderPosition);
		switch(FalseBorderCount)
		{
			case 2:
				switch(FalseBorderPosition)
				{
					case 3:
						this.BorderFlipDownOnce();
						this.RotateOuterUpInverse();
						this.BorderFlipDownOnce();
						break;

					case 5:
						this.RotateOuterUpInverse();
						this.BorderFlipDownOnce();
						this.RotateOuterUpInverse();
						this.RotateOuterUpInverse();
						this.BorderFlipDownOnce();
						break;

					case 9:
						this.RotateOuterUpInverse();
						this.BorderFlipDownOnce();
						this.RotateOuterUpInverse();
						this.BorderFlipDownOnce();
						break;

					case 6:
						this.BorderFlipDownOnce();
						this.RotateOuterUp();
						this.BorderFlipDownOnce();
						break;

					case 10:
						this.BorderFlipDownOnce();
						this.RotateOuterUp();
						this.RotateOuterUp();
						this.BorderFlipDownOnce();
						break;

					case 12:
						this.RotateOuterUpInverse();
						this.BorderFlipDownOnce();
						this.RotateOuterUpInverse();
						this.BorderFlipDownOnce();
						break;

					default:
						break;
				}
				break;

			case 4:
				this.BorderFlipDownOnce();
				this.RotateOuterUpInverse();
				this.BorderFlipDownOnce();
				this.RotateOuterUpInverse();
				this.BorderFlipDownOnce();
				this.RotateOuterUpInverse();
				this.BorderFlipDownOnce();
				break;

			case 0:
			default:
				break;
		}
	}

	cube.prototype.BorderFlipDownOnce = function(){
		this.RotateOuterRight();
		this.RotateInnerEquator();
		this.RotateOuterRight();
		this.RotateInnerEquator();
		this.RotateOuterRight();
		this.RotateInnerEquator();
		this.RotateOuterRight();
		this.RotateInnerEquator();
	}
}

cube.prototype.DownCross = function(UpColor){
	this.ColorUp(cubeyellow);
	this.BorderDown(cubewhite);
	this.BorderDown(cubewhite);
}

// Ecken-Positionierungen und -Drehungen

{
	cube.prototype.CornerDown = function(UpColor){
		var positionredblue = this.FindCorner(cubeyellow,cubered,cubeblue);
		var positiongreenred = this.FindCorner(cubeyellow,cubegreen,cubered);
		var positionorangegreen = this.FindCorner(cubeyellow,cubeorange,cubegreen);
		var positionblueorange = this.FindCorner(cubeyellow,cubeblue,cubeorange);
		this.CornerDownDown(positionredblue,positiongreenred,positionorangegreen,positionblueorange);
		this.CornerFlipDown(cubewhite);
	}

	cube.prototype.CornerDownDown = function(positionredblue,positiongreenred,positionorangegreen,positionblueorange){
		var pos = new Array(4);
		switch(positionredblue)
		{
			case 8:
			case this.CounterCorner(8)[0]:
			case this.CounterCorner(8)[1]:
				pos[0] = 'rb';
				break;

			case 2:
			case this.CounterCorner(2)[0]:
			case this.CounterCorner(2)[1]:
				pos[1] = 'rb';
				break;

			case 0:
			case this.CounterCorner(0)[0]:
			case this.CounterCorner(0)[1]:
				pos[2] = 'rb';
				break;

			case 6:
			case this.CounterCorner(6)[0]:
			case this.CounterCorner(6)[1]:
				pos[3] = 'rb';
				break;

			default:
				break;
		}
		switch(positiongreenred)
		{
			case 8:
			case this.CounterCorner(8)[0]:
			case this.CounterCorner(8)[1]:
				pos[0] = 'gr';
				break;

			case 2:
			case this.CounterCorner(2)[0]:
			case this.CounterCorner(2)[1]:
				pos[1] = 'gr';
				break;

			case 0:
			case this.CounterCorner(0)[0]:
			case this.CounterCorner(0)[1]:
				pos[2] = 'gr';
				break;

			case 6:
			case this.CounterCorner(6)[0]:
			case this.CounterCorner(6)[1]:
				pos[3] = 'gr';
				break;

			default:
				break;
		}
		switch(positionorangegreen)
		{
			case 8:
			case this.CounterCorner(8)[0]:
			case this.CounterCorner(8)[1]:
				pos[0] = 'og';
				break;

			case 2:
			case this.CounterCorner(2)[0]:
			case this.CounterCorner(2)[1]:
				pos[1] = 'og';
				break;

			case 0:
			case this.CounterCorner(0)[0]:
			case this.CounterCorner(0)[1]:
				pos[2] = 'og';
				break;

			case 6:
			case this.CounterCorner(6)[0]:
			case this.CounterCorner(6)[1]:
				pos[3] = 'og';
				break;

			default:
				break;
		}
		switch(positionblueorange)
		{
			case 8:
			case this.CounterCorner(8)[0]:
			case this.CounterCorner(8)[1]:
				pos[0] = 'bo';
				break;

			case 2:
			case this.CounterCorner(2)[0]:
			case this.CounterCorner(2)[1]:
				pos[1] = 'bo';
				break;

			case 0:
			case this.CounterCorner(0)[0]:
			case this.CounterCorner(0)[1]:
				pos[2] = 'bo';
				break;

			case 6:
			case this.CounterCorner(6)[0]:
			case this.CounterCorner(6)[1]:
				pos[3] = 'bo';
				break;

			default:
				break;
		}
		// console.log(pos);									// Debug-Output
		switch(pos.join(','))
		{
			case 'rb,og,bo,gr':
				this.RotateOuterUp();
				this.RotateOuterUp();
				this.CornerSwitchDownDown('counterclockwise');
				this.RotateOuterUp();
				this.RotateOuterUp();
				break;

			case 'rb,bo,gr,og':
				this.RotateOuterUp();
				this.RotateOuterUp();
				this.CornerSwitchDownDown('clockwise');
				this.RotateOuterUp();
				this.RotateOuterUp();
				break;

			case 'gr,rb,bo,og':
				this.CornerSwitchDownDown('clockwise');
				this.RotateOuterUp();
				this.RotateOuterUp();
				this.CornerSwitchDownDown('counterclockwise');
				this.RotateOuterUp();
				this.RotateOuterUp();
				break;

			case 'gr,og,rb,bo':
				this.RotateOuterUp();
				this.CornerSwitchDownDown('counterclockwise');
				this.RotateOuterUpInverse();
				break;

			case 'gr,bo,og,rb':
				this.CornerSwitchDownDown('counterclockwise');
				break;

			case 'og,rb,gr,bo':
				this.RotateOuterUp();
				this.CornerSwitchDownDown('clockwise');
				this.RotateOuterUpInverse();
				break;

			case 'og,gr,bo,rb':
				this.RotateOuterUpInverse();
				this.CornerSwitchDownDown('counterclockwise');
				this.RotateOuterUp();
				break;

			case 'og,bo,rb,gr':
				this.CornerSwitchDownDown('clockwise');
				this.RotateOuterUpInverse();
				this.CornerSwitchDownDown('clockwise');
				this.RotateOuterUp();
				break;

			case 'bo,rb,og,gr':
				this.CornerSwitchDownDown('clockwise');
				break;

			case 'bo,gr,rb,og':
				this.RotateOuterUpInverse();
				this.CornerSwitchDownDown('clockwise');
				this.RotateOuterUp();
				break;

			case 'bo,og,gr,rb':
				this.CornerSwitchDownDown('clockwise');
				this.RotateOuterUp();
				this.CornerSwitchDownDown('clockwise');
				this.RotateOuterUpInverse();
				break;

			case 'rb,gr,og,bo':
			default:
				break;
		}
	}

	cube.prototype.CornerSwitchDownDown = function(direction){
		switch(direction)
		{
			case 'clockwise':
				this.RotateOuterRightInverse();
				this.RotateOuterUp();
				this.RotateOuterLeft();
				this.RotateOuterUpInverse();
				this.RotateOuterRight();
				this.RotateOuterUp();
				this.RotateOuterLeftInverse();
				this.RotateOuterUpInverse();
				break;

			case 'counterclockwise':
				this.RotateOuterUp();
				this.RotateOuterLeft();
				this.RotateOuterUpInverse();
				this.RotateOuterRightInverse();
				this.RotateOuterUp();
				this.RotateOuterLeftInverse();
				this.RotateOuterUpInverse();
				this.RotateOuterRight();
				break;

			default:
				break;
		}
	}

	cube.prototype.CornerFlipDown = function(UpColor){
		var FalseCornerCount = 0;
		var FalseCornerPosition = 0;
		var positionredblueyellow = this.FindCorner(cubeyellow,cubered,cubeblue);
		var positiongreenredyellow = this.FindCorner(cubeyellow,cubegreen,cubered);
		var positionorangegreenyellow = this.FindCorner(cubeyellow,cubeorange,cubegreen);
		var positionblueorangeyellow = this.FindCorner(cubeyellow,cubeblue,cubeorange);
		switch(positionredblueyellow)
		{
			case this.CounterCorner(8)[0]:
				this.CornerFlipDownOnce('counterclockwise');
				this.RotateOuterUp();
				break;

			case this.CounterCorner(8)[1]:
				this.CornerFlipDownOnce('clockwise');
				this.RotateOuterUp();
				break;

			case 8:
				this.RotateOuterUp();
				break;

			default:
				break;
		}
		switch(positiongreenredyellow)
		{
			case this.CounterCorner(2)[0]:
				this.CornerFlipDownOnce('counterclockwise');
				this.RotateOuterUp();
				break;

			case this.CounterCorner(2)[1]:
				this.CornerFlipDownOnce('clockwise');
				this.RotateOuterUp();
				break;

			case 2:
				this.RotateOuterUp();
				break;

			default:
				break;
		}
		switch(positionorangegreenyellow)
		{
			case this.CounterCorner(0)[0]:
				this.CornerFlipDownOnce('counterclockwise');
				this.RotateOuterUp();
				break;

			case this.CounterCorner(0)[1]:
				this.CornerFlipDownOnce('clockwise');
				this.RotateOuterUp();
				break;

			case 0:
				this.RotateOuterUp();
				break;

			default:
				break;
		}
		switch(positionblueorangeyellow)
		{
			case this.CounterCorner(6)[0]:
				this.CornerFlipDownOnce('counterclockwise');
				this.RotateOuterUp();
				break;

			case this.CounterCorner(6)[1]:
				this.CornerFlipDownOnce('clockwise');
				this.RotateOuterUp();
				break;

			case 6:
				this.RotateOuterUp();
				break;

			default:
				break;
		}
		console.log(FalseCornerPosition);
		console.log(FalseCornerCount);
	}

	cube.prototype.CornerFlipDownOnce = function(direction){
		switch(direction)
		{
			case 'clockwise':
				this.RotateOuterRight();
				this.RotateOuterFrontInverse();
				this.RotateOuterRightInverse();
				this.RotateOuterFront();
				this.RotateOuterRight();
				this.RotateOuterFrontInverse();
				this.RotateOuterRightInverse();
				this.RotateOuterFront();
				break;

			case 'counterclockwise':
				this.RotateOuterFrontInverse();
				this.RotateOuterRight();
				this.RotateOuterFront();
				this.RotateOuterRightInverse();
				this.RotateOuterFrontInverse();
				this.RotateOuterRight();
				this.RotateOuterFront();
				this.RotateOuterRightInverse();
				break;

			default:
				break;
		}
	}
}

cube.prototype.DownLayer = function(UpColor){
	this.TurnFrontCenter(cubeblue);
	this.TurnFrontDown(cubeblue);
	this.CornerDown(cubewhite);
}

// Transfer-Funktion von Cube-Array-Punkten auf 3D-Anzeige-Array-Punkte

cube.prototype.Translate = function(){
	var ThreeDCube = new Array(108);
	ThreeDCube[0] = "0x" + this.cube[0];
	ThreeDCube[1] = "0x" + this.cube[0];
	ThreeDCube[2] = "0x" + this.cube[1];
	ThreeDCube[3] = "0x" + this.cube[1];
	ThreeDCube[4] = "0x" + this.cube[2];
	ThreeDCube[5] = "0x" + this.cube[2];
	ThreeDCube[6] = "0x" + this.cube[3];
	ThreeDCube[7] = "0x" + this.cube[3];
	ThreeDCube[8] = "0x" + this.cube[4];
	ThreeDCube[9] = "0x" + this.cube[4];
	ThreeDCube[10] = "0x" + this.cube[5];
	ThreeDCube[11] = "0x" + this.cube[5];
	ThreeDCube[12] = "0x" + this.cube[6];
	ThreeDCube[13] = "0x" + this.cube[6];
	ThreeDCube[14] = "0x" + this.cube[7];
	ThreeDCube[15] = "0x" + this.cube[7];
	ThreeDCube[16] = "0x" + this.cube[8];
	ThreeDCube[17] = "0x" + this.cube[8];
	ThreeDCube[18] = "0x" + this.cube[44];
	ThreeDCube[19] = "0x" + this.cube[44];
	ThreeDCube[20] = "0x" + this.cube[43];
	ThreeDCube[21] = "0x" + this.cube[43];
	ThreeDCube[22] = "0x" + this.cube[42];
	ThreeDCube[23] = "0x" + this.cube[42];
	ThreeDCube[24] = "0x" + this.cube[41];
	ThreeDCube[25] = "0x" + this.cube[41];
	ThreeDCube[26] = "0x" + this.cube[40];
	ThreeDCube[27] = "0x" + this.cube[40];
	ThreeDCube[28] = "0x" + this.cube[39];
	ThreeDCube[29] = "0x" + this.cube[39];
	ThreeDCube[30] = "0x" + this.cube[38];
	ThreeDCube[31] = "0x" + this.cube[38];
	ThreeDCube[32] = "0x" + this.cube[37];
	ThreeDCube[33] = "0x" + this.cube[37];
	ThreeDCube[34] = "0x" + this.cube[36];
	ThreeDCube[35] = "0x" + this.cube[36];
	ThreeDCube[36] = "0x" + this.cube[47];
	ThreeDCube[37] = "0x" + this.cube[47];
	ThreeDCube[38] = "0x" + this.cube[50];
	ThreeDCube[39] = "0x" + this.cube[50];
	ThreeDCube[40] = "0x" + this.cube[53];
	ThreeDCube[41] = "0x" + this.cube[53];
	ThreeDCube[42] = "0x" + this.cube[46];
	ThreeDCube[43] = "0x" + this.cube[46];
	ThreeDCube[44] = "0x" + this.cube[49];
	ThreeDCube[45] = "0x" + this.cube[49];
	ThreeDCube[46] = "0x" + this.cube[52];
	ThreeDCube[47] = "0x" + this.cube[52];
	ThreeDCube[48] = "0x" + this.cube[45];
	ThreeDCube[49] = "0x" + this.cube[45];
	ThreeDCube[50] = "0x" + this.cube[48];
	ThreeDCube[51] = "0x" + this.cube[48];
	ThreeDCube[52] = "0x" + this.cube[51];
	ThreeDCube[53] = "0x" + this.cube[51];
	ThreeDCube[54] = "0x" + this.cube[24];
	ThreeDCube[55] = "0x" + this.cube[24];
	ThreeDCube[56] = "0x" + this.cube[21];
	ThreeDCube[57] = "0x" + this.cube[21];
	ThreeDCube[58] = "0x" + this.cube[18];
	ThreeDCube[59] = "0x" + this.cube[18];
	ThreeDCube[60] = "0x" + this.cube[25];
	ThreeDCube[61] = "0x" + this.cube[25];
	ThreeDCube[62] = "0x" + this.cube[22];
	ThreeDCube[63] = "0x" + this.cube[22];
	ThreeDCube[64] = "0x" + this.cube[19];
	ThreeDCube[65] = "0x" + this.cube[19];
	ThreeDCube[66] = "0x" + this.cube[26];
	ThreeDCube[67] = "0x" + this.cube[26];
	ThreeDCube[68] = "0x" + this.cube[23];
	ThreeDCube[69] = "0x" + this.cube[23];
	ThreeDCube[70] = "0x" + this.cube[20];
	ThreeDCube[71] = "0x" + this.cube[20];
	ThreeDCube[72] = "0x" + this.cube[15];
	ThreeDCube[73] = "0x" + this.cube[15];
	ThreeDCube[74] = "0x" + this.cube[12];
	ThreeDCube[75] = "0x" + this.cube[12];
	ThreeDCube[76] = "0x" + this.cube[9];
	ThreeDCube[77] = "0x" + this.cube[9];
	ThreeDCube[78] = "0x" + this.cube[16];
	ThreeDCube[79] = "0x" + this.cube[16];
	ThreeDCube[80] = "0x" + this.cube[13];
	ThreeDCube[81] = "0x" + this.cube[13];
	ThreeDCube[82] = "0x" + this.cube[10];
	ThreeDCube[83] = "0x" + this.cube[10];
	ThreeDCube[84] = "0x" + this.cube[17];
	ThreeDCube[85] = "0x" + this.cube[17];
	ThreeDCube[86] = "0x" + this.cube[14];
	ThreeDCube[87] = "0x" + this.cube[14];
	ThreeDCube[88] = "0x" + this.cube[11];
	ThreeDCube[89] = "0x" + this.cube[11];
	ThreeDCube[90] = "0x" + this.cube[29];
	ThreeDCube[91] = "0x" + this.cube[29];
	ThreeDCube[92] = "0x" + this.cube[32];
	ThreeDCube[93] = "0x" + this.cube[32];
	ThreeDCube[94] = "0x" + this.cube[35];
	ThreeDCube[95] = "0x" + this.cube[35];
	ThreeDCube[96] = "0x" + this.cube[28];
	ThreeDCube[97] = "0x" + this.cube[28];
	ThreeDCube[98] = "0x" + this.cube[31];
	ThreeDCube[99] = "0x" + this.cube[31];
	ThreeDCube[100] = "0x" + this.cube[34];
	ThreeDCube[101] = "0x" + this.cube[34];
	ThreeDCube[102] = "0x" + this.cube[27];
	ThreeDCube[103] = "0x" + this.cube[27];
	ThreeDCube[104] = "0x" + this.cube[30];
	ThreeDCube[105] = "0x" + this.cube[30];
	ThreeDCube[106] = "0x" + this.cube[33];
	ThreeDCube[107] = "0x" + this.cube[33];

	return ThreeDCube;
}

// Testfunktion, um den Rubik's Cube in der vorgefertigten Tabelle auszugeben (als Kreuz)

function filltable(rubik){
	for(i=0;i<54;i++)
	{
		var td = $('#'+ i);
		td.attr('bgcolor', rubik.cube[i]);
	}
	cubeready(rubik);
}

// Testfunktionen zum Durchführen der Rotationen

{
	var cubeone = new cube();
	cubeone.basic();

	document.getElementById('clickme').onclick = function(){
		cubeone.basic();
		filltable(cubeone);
	}

	document.getElementById('L').onclick = function(){
		cubeone.RotateOuterLeft();
		filltable(cubeone);
	}

	document.getElementById('LI').onclick = function(){
		cubeone.RotateOuterLeftInverse();
		filltable(cubeone);
	}

	document.getElementById('R').onclick = function(){
		cubeone.RotateOuterRight();
		filltable(cubeone);
	}

	document.getElementById('RI').onclick = function(){
		cubeone.RotateOuterRightInverse();
		filltable(cubeone);
	}

	document.getElementById('U').onclick = function(){
		cubeone.RotateOuterUp();
		filltable(cubeone);
	}

	document.getElementById('UI').onclick = function(){
		cubeone.RotateOuterUpInverse();
		filltable(cubeone);
	}

	document.getElementById('D').onclick = function(){
		cubeone.RotateOuterDown();
		filltable(cubeone);
	}

	document.getElementById('DI').onclick = function(){
		cubeone.RotateOuterDownInverse();
		filltable(cubeone);
	}

	document.getElementById('F').onclick = function(){
		cubeone.RotateOuterFront();
		filltable(cubeone);
	}

	document.getElementById('FI').onclick = function(){
		cubeone.RotateOuterFrontInverse();
		filltable(cubeone);
	}

	document.getElementById('B').onclick = function(){
		cubeone.RotateOuterBack();
		filltable(cubeone);
	}

	document.getElementById('BI').onclick = function(){
		cubeone.RotateOuterBackInverse();
		filltable(cubeone);
	}

	document.getElementById('M').onclick = function(){
		cubeone.RotateInnerMiddle();
		filltable(cubeone);
	}

	document.getElementById('MI').onclick = function(){
		cubeone.RotateInnerMiddleInverse();
		filltable(cubeone);
	}

	document.getElementById('E').onclick = function(){
		cubeone.RotateInnerEquator();
		filltable(cubeone);
	}

	document.getElementById('EI').onclick = function(){
		cubeone.RotateInnerEquatorInverse();
		filltable(cubeone);
	}

	document.getElementById('S').onclick = function(){
		cubeone.RotateInnerStanding();
		filltable(cubeone);
	}

	document.getElementById('SI').onclick = function(){
		cubeone.RotateInnerStandingInverse();
		filltable(cubeone);
	}

	document.getElementById('X').onclick = function(){
		cubeone.RotateWholeX();
		filltable(cubeone);
	}

	document.getElementById('XI').onclick = function(){
		cubeone.RotateWholeXInverse();
		filltable(cubeone);
	}

	document.getElementById('Y').onclick = function(){
		cubeone.RotateWholeY();
		filltable(cubeone);
	}

	document.getElementById('YI').onclick = function(){
		cubeone.RotateWholeYInverse();
		filltable(cubeone);
	}

	document.getElementById('Z').onclick = function(){
		cubeone.RotateWholeZ();
		filltable(cubeone);
	}

	document.getElementById('ZI').onclick = function(){
		cubeone.RotateWholeZInverse();
		filltable(cubeone);
	}

	document.getElementById('CC').onclick = function(){
		cubeone.ColorCross(cubewhite);
		filltable(cubeone);
	}

	document.getElementById('CL').onclick = function(){
		cubeone.ColorLayer(cubewhite);
		filltable(cubeone);
	}

	document.getElementById('BA').onclick = function(){
		cubeone.BorderAlign(cubewhite);
		filltable(cubeone);
	}

	document.getElementById('DC').onclick = function(){
		cubeone.DownCross(cubewhite);
		filltable(cubeone);
	}

	document.getElementById('DL').onclick = function(){
		cubeone.DownLayer(cubewhite);
		filltable(cubeone);
	}
}

// Anzeigefunktion, ob der Würfel richtig liegt
function cubeready(rubik){
	var flag = 0;
	for(i=0;i<9;i++)
	{
		if(rubik.cube[i] != cubewhite)
			flag++;
	}
	for(i=9;i<18;i++)
	{
		if(rubik.cube[i] != cubered)
			flag++;
	}
	for(i=18;i<27;i++)
	{
		if(rubik.cube[i] != cubeblue)
			flag++;
	}
	for(i=27;i<36;i++)
	{
		if(rubik.cube[i] != cubeorange)
			flag++;
	}
	for(i=36;i<45;i++)
	{
		if(rubik.cube[i] != cubeyellow)
			flag++;
	}
	for(i=45;i<54;i++)
	{
		if(rubik.cube[i] != cubegreen)
			flag++;
	}
	$('#flag').text(flag);
	if(flag != 0)
		$('#cubeready').text('Not Ready');
	else
		$('#cubeready').text('Ready');
}