$(document).ready(function() 
{
	$('#home').show();
	$('#main').hide();
	$('#cutScenes').hide();
	$('#pausePlay').hide();
	$('#hint').hide();
	$('#mute').hide();
	$('#chooseDifficulty').hide();
	$('#showHighscore').hide();
	
	$('#options').click(function() //Bei Klick auf "Optionen" -> Schwierigkeit auswählen
	{
		$('#showHighscore').hide();

		if($('#chooseDifficulty').css('display') == 'none')
		{ 
			$('#chooseDifficulty').show();
		}
		else
		{
			$('#chooseDifficulty').hide();
		}
	});
	
	$('#highscore').click(function() //Bei Klick auf "Highscore" -> Highscores anzeigen
	{
		$('#chooseDifficulty').hide();
		$('#showHighscore').html('');
		
		if($('#showHighscore').css('display') == 'none')
		{ 
			$('#showHighscore').show();
		}
		else
		{
			$('#showHighscore').hide();
		}
		
		var levelCount = 0;
		var highscoreArray = [];
		var highscoreDifficulty = ['leicht', 'mittel', 'schwer', 'leicht', 'mittel', 'schwer', 'leicht', 'mittel', 'schwer', 'leicht', 'mittel', 'schwer'];
		
		highscoreArray.push(localStorage.getItem('One (leicht)'));
		highscoreArray.push(localStorage.getItem('One (mittel)'));
		highscoreArray.push(localStorage.getItem('One (schwer)'));
		highscoreArray.push(localStorage.getItem('Two (leicht)'));
		highscoreArray.push(localStorage.getItem('Two (mittel)'));
		highscoreArray.push(localStorage.getItem('Two (schwer)'));
		highscoreArray.push(localStorage.getItem('Three (leicht)'));
		highscoreArray.push(localStorage.getItem('Three (mittel)'));
		highscoreArray.push(localStorage.getItem('Three (schwer)'));
		highscoreArray.push(localStorage.getItem('Four (leicht)'));
		highscoreArray.push(localStorage.getItem('Four (mittel)'));
		highscoreArray.push(localStorage.getItem('Four (schwer)'));
		
		for(var i = 0; i < highscoreArray.length; i++)
		{
			if(i % 3 == 0)
			{
				levelCount++;
			}
		
			if(highscoreArray[i] != null)
			{
				$('#showHighscore').append('<p>Level ' + (levelCount) + ' (' + highscoreDifficulty[i] + '): ' + highscoreArray[i] + ' Sekunden</p>');
			}
			else
			{
				$('#showHighscore').append('<p>Level ' + (levelCount) + ' (' + highscoreDifficulty[i] + '): Noch keinen Highscore erreicht</p>');
			}
		}
	});
	
	//Globale Variablen
	var timeLimit = 0;
	var timeRemaining = 0;
	var musicstatus = false; //Musik Variable (AN/AUS)
		
	//Schwierigkeit festlegen (Startzeit)
	function startTime(level)
	{	
		timeLimit = 0;
		switch(level)
		{
			case 'mittel':
				timeLimit = 180000;
				break;
			case 'schwer':
				timeLimit = 120000;
				break;
			default: //leicht
				timeLimit = 300000;
		}
		return timeLimit;
	}
	
	//Schwierigkeit festlegen (Anzahl der zu suchenden Objekte)
	function difficulty(level, objectsTotal)
	{
		var objectCount = 0;
						
		switch(level)
		{
			case 'mittel':
				objectCount = Math.round(objectsTotal/100*50);
				break;
			case 'schwer':
				objectCount = Math.round(objectsTotal/100*80);
				break;
			default: //leicht
				objectCount = Math.round(objectsTotal/100*30);
		}
		return objectCount;
	}
	
	//Zufallsgenerator für die Objekte (je nach Level unterschiedlich viele)
	function getObjectsLevel(objectCount, objectMaxCount)
	{
		var numberTemp = 0;
		var objectSelection = [];
	
		while(objectSelection.length < objectCount)
		{			
			numberTemp = Math.floor(Math.random() * objectMaxCount); 
			if(jQuery.inArray(numberTemp, objectSelection) === -1)
			{
				objectSelection.push(numberTemp);
			}	
		}
		
		return objectSelection;
	}
	
	//Vorbereitung für die drawObject Methode (Objekt-Informationen werden gesammelt und Übergabe an Zeichnenfunktion)
	function prepareDrawing(objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsDrawNot, drawMode)
	{
		for(var i = 0; i < objectCount; i++)
		{		
			if(jQuery.inArray(objectIDs[arrayIndexes[i]], objectsDrawNot) === -1) //Nur dann zeichnen, wenn noch nicht gefunden
			{
				drawObjects(objectNames[arrayIndexes[i]], objectIDs[arrayIndexes[i]], objectWidth[arrayIndexes[i]], objectHeight[arrayIndexes[i]], coords[arrayIndexes[i]], true);
			
				if(drawMode) //Die Namen der zu suchenden Objekte in den Kasten am unteren Bildschirmrand schreiben wenn das erste mal gezeichnet wird (nicht bei resize)
				{
					$('#story').append('<span id="' + objectIDs[arrayIndexes[i]] + 'Bottom" class="objectNamesBottom">' + objectNames[arrayIndexes[i]] + '</span>');
				}
			}
		}
		
		//Alle verbleibenden Objekte zeichnen aber nicht klickbar
		for(var j = 0; j < objectIDs.length; j++)
		{
			if(jQuery.inArray(j, arrayIndexes) === -1)
			{
				drawObjects(objectNames[j], objectIDs[j], objectWidth[j], objectHeight[j], coords[j], false);
			}
		}		
	}	

	//drawObject-Funktion (wird in der Vorbereitungsfunktion aufgerufen, Objekte werden auf das Bild gezeichnet)
	function drawObjects(name, id, width, height, coords, clickable)
	{
		var objectSizes = calculateSizes(width, height);
		var objectWidth = objectSizes[0];
		var objectHeight = objectSizes[1];
		
		if(clickable)
		{
			var coords = calculateCoords(coords, width, height, objectWidth, objectHeight);
		
			$('#level').append('<img id="' + id + '" class="object" src="img/objects/' + id + '.png" width="' + objectWidth + 'px" height="' + objectHeight + 'px" usemap="#' + id + 'Map"><map class="objectMap" name="' + id + 'Map"><area id="' + id + 'Map" class="imageMaps" shape="poly" coords="' + coords + '"></map>');
		}
		else
		{
			$('#level').append('<img id="' + id + '" class="object" src="img/objects/' + id + '.png" width="' + objectWidth + 'px" height="' + objectHeight + 'px">');
		}
	}
	
	//Größe des Background-Images zurückgeben für prozentuale Größenberechnung von Elementen
	function getBackgroundImageSize()
	{
		var backgroundImageWidth = $('#backgroundImage').css('width');
		var backgroundImageHeight = $('#backgroundImage').css('height');

		backgroundImageWidth = (backgroundImageWidth.substring(0,backgroundImageWidth.length-2))*1; //String abschneiden und in Zahl umwandeln
		backgroundImageHeight = (backgroundImageHeight.substring(0,backgroundImageHeight.length-2))*1;

		var backgroundSizes = [backgroundImageWidth, backgroundImageHeight];

		return backgroundSizes;
	}

	//Größe des Avatar-Bildes dynamisch berechnen
	function calculateAvatarSize()
	{
		var backgroundSizes = getBackgroundImageSize();

		$("#avatar").css('width', (backgroundSizes[1] * 0.19)); //Parameter spiegelen Verhältnis zwischen Originalgrößen von BackgroundImage und Avatar-Bild wieder
		$("#avatar").css('height', (backgroundSizes[1] * 0.19)); //Höhe und Breite sollen gleich sein um Verzerrung zu verhindern
	}
	
	//Prozentual richtige Größen der Objekte berechnen anhand der aktuellen Darstellungsgröße (wird in drawObject aufgerufen)
	function calculateSizes(objectWidthOriginal, objektHeightOriginal)
	{
		var backgroundSizes = getBackgroundImageSize();
		
		var prozentWidth = backgroundSizes[0] / 9.59; //Verhältnis zwischen Orginalgröße und aktueller Darstellungsgröße
		var prozentHeight = backgroundSizes[1] / 6;
		
		var objectWidth = prozentWidth * (objectWidthOriginal / 100);
		var objectHeight = prozentHeight * (objektHeightOriginal / 100);
		
		var objectSize = [objectWidth, objectHeight];
		
		return objectSize;
	}
	
	//Koordinaten der ImageMaps der Objekte prozentual berechnen anhand der aktuellen Darstellungsgröße (wird in drawObject aufgerufen)
	function calculateCoords(coordsInput, objectWidthOriginal, objectHeightOriginal, objectWidth, objectHeight)
	{
		var prozentWidth = objectWidth / (objectWidthOriginal / 100);
		var prozentHeight = objectHeight / (objectHeightOriginal / 100);
		var coordTemp = 0;
		var coordsArray = [];
		
		for(var i = 0; i < coordsInput.length; i++)
		{
			if(i%2 == 0) //Breite neu berechnen
			{
				coordTemp = Math.round(prozentWidth * (coordsInput[i] / 100));
				coordsArray.push(coordTemp);
			}
			else //Höhe neu berechnen
			{
				coordTemp = Math.round(prozentHeight * (coordsInput[i] / 100));
				coordsArray.push(coordTemp);
			}
		}
		
		return coordsArray.toString();
	}
	
	//Timer (verbleibende Suchzeit)
	function timer(timeLimit)
	{	
		var limitMins = 0;
		var limitSecs = 0;
		
		timeLimit = timeLimit / 1000;
		limitMins = Math.floor(timeLimit / 60);
		limitSecs = timeLimit % 60;
		
		timeCounter = setInterval(function()
		{			
			if(limitSecs < 10) //Führende Null hinzufügen wenn Sekunden kleiner 10
			{
				$('#timer').html(limitMins + ':0' + limitSecs);
			}
			else
			{
				$('#timer').html(limitMins + ':' + limitSecs);
			}
			
			if(limitSecs == 0 && limitMins == 0) //Aktion bei Zeit abgelaufen
			{
				clearInterval(timeCounter);
				$('#cover').show();
				$('#messages').show();
				$('#messages').html('<p>Zeit abgelaufen</p><p>Nochmal versuchen?</p><p><button id="restartLevel">Level neustarten</button></p>');	
				$('#pausePlay').hide();
				$('#hint').hide();
				$('#mute').hide();
								
				var music = document.getElementById('music');
				music.pause();
				musicstatus = false;
				
			}
			else if(limitSecs == 0)
			{
				limitSecs = 60;
				
				if(limitMins > 0)
				{
					limitMins--;
				}
			}

			limitSecs--;
			}, 1000);
	}
	
	//Aktion bei Klick auf Neustarten-Button (dynamisch erzeugter Button)
	$('#messages').on('click','#restartLevel',function() 
	{
		$('#cover').hide();
		$('#story').html('');
		
		var levelName = getLevelName();
		
		eval(levelName+'()'); //Aktuelles Level erneut starten
	});

	//Bei Klick auf Pause/Start
	$('#pausePlay').click(function()
	{
		var status = $(this).html();
		var timerCurrent = $('#timer').html();
		var timeCurrentArray = timerCurrent.split(":");
		var milliSeconds = ((timeCurrentArray[0] * 60) + ((timeCurrentArray[1] * 1) -1)) * 1000;

		if(status == 'Pause')
		{
			clearInterval(timeCounter); //Timer anhalten
			$(this).html('Fortsetzen'); 
			$('#cover').show();
			$('#messages').show();
			$('#messages').html('<span><p>Pause</p></span>');	
		}
		else
		{
			timer(milliSeconds);
			$(this).html('Pause');
			$('#cover').hide();
		}
	});
	
	//Mute-Button
	$('#mute').click(function()
	{
		var music = document.getElementById('music');
		if(musicstatus)
		{ 
			music.pause();
			musicstatus = false;
			$(this).html('Musik an');
		}
		else
		{
			music.play();
			musicstatus = true;
			$(this).html('Musik aus');
			
		}
	});
	
	//Zurück-zum-Hauptmenü-Button
	$('#toMainMenu').click(function()
	{
		var userBreak = confirm('Möchten Sie das aktuelle Spiel wirklich beenden?');
		
		if(userBreak)
		{
			window.location = 'seaquest.html';
		} 
	});
	
	//Hinweis/Hilfe-Funktion (ein klickbares Objekt hervorheben)
	function hintShow(objectsFound, arrayIndexes, objectIDs, hintUsed)
	{
		var status = $('#pausePlay').html();
		
		if(status == 'Pause')
		{
			if(hintUsed < 1)
			{
				for(var i = 0; i < arrayIndexes.length; i++)
				{
					if(jQuery.inArray(objectIDs[arrayIndexes[i]], objectsFound) === -1)
					{					
						for(var j = 0; j < 4; j++)
						{
							$('#' + objectIDs[arrayIndexes[i]] + '').animate(
							{
								opacity: 0.25,
							}, 400, function(){});
							
							$('#' + objectIDs[arrayIndexes[i]] + '').animate(
							{
								opacity: 1,
							}, 400, function(){});
						}
						
						break;
					}
				}
			}
			else
			{
				$('#cover').show();
				$('#messages').html('<p>Sie haben Ihren Hinweis bereits verbraucht</p>');
				$('#cover').delay(2000).fadeOut(1000);
			}
			
			return true;
		}
		
		return false
	}

	//Array-Funktion für die Items, die nach Level-Ende "gefunden" wurden und dem Spieler angezeigt werden sollen
	function getItemsFound()
	{
		var itemsFound = ['Du hast einen Schlüssel gefunden.', 'Du hast eine Falltür gefunden.', 'Du hast eine Karte gefunden.', 'Du hast eine Rettungskapsel gefunden und kannst rechtzeitig entkommen.'];
		var itemsUrl = ['<img class="itemFoundImg" src="img/items/itemKey.png">', '<img class="itemFoundImg" src="img/items/itemTrapdoor.png">', '<img class="itemFoundImg" src="img/items/itemMap.png">', '<img class="itemFoundImgBeside" src="img/items/itemEscapeCapsel.png"'];
		var itmesArray = [itemsFound, itemsUrl];

		return itmesArray;
	}
	
	//Aktion ausführen bei Klick auf ein Objekt
	function objectClick(objectsFound, objectCount, objectMapId, currentLevel, nextLevel, timeLimit, level)
	{
		var objectId = objectMapId.substring(0, objectMapId.length - 3);
		$('#' + objectId).fadeOut(1000);
		$('#' + objectId + 'Bottom').fadeOut(1000);

		if(jQuery.inArray(objectId, objectsFound) == -1) //Um Mehrfachklicks auf ein Objekt abzufangen
		{
			objectsFound.push(objectId);
		}

		//EasterEgg-Objekte
		if(objectId == 'starfishTwo') //Level 2: Seestern
		{
			musicstatus = true;
			$('#musicMp3').attr('src','music/unterDemMeerMp3.mp3');
			$('#musicOgg').attr('src','music/unterDemMeerOgg.ogg');
			var music = document.getElementById('music');
			music.load();
			music.play();
		}

		setTimeout(function() //Intervall von 1 sec um die Animation des Objekts noch abzuwarten
		{
			if(objectsFound.length == objectCount) //Aktion, wenn alle Objekte gefunden wurden
			{
				objectsFound.length = 0; //Wichtig um den alten Array zu leeren damit es keine doppelten Arrays im nächsten Level gibt!
				
				clearInterval(timeCounter); //Timer anhalten
				
				var timerCurrent = $('#timer').html();
				var timeCurrentArray = timerCurrent.split(":");
				var timeRemaining = ((timeCurrentArray[0] * 60) + ((timeCurrentArray[1] * 1) -1)) * 1000;
				var usedTime = (timeLimit - timeRemaining) / 1000;

				//Überprüfen, ob ein neuer Highscore vorliegt
				var oldHighscore = (localStorage.getItem(currentLevel + ' (' + level + ')'))*1;
				
				if(usedTime < oldHighscore || oldHighscore == 0)
				{
					//Highscore im Webstorage speichern
					if(typeof(Storage) != 'undefined')
					{
						localStorage.setItem(currentLevel + ' (' + level + ')', usedTime);
					} 
					else
					{
						alert('<p>Ihr Browser unterstützt leider keine Webstorage-Technologie. Der Highscore kann nicht gespeichert werden.</p>');
					}
				}

				var levelNumber = 0;

				switch(nextLevel)
				{
					case 'Three':
						levelNumber = 1;
						break;
					case 'Four':
						levelNumber = 2;
						break;
					case 'End':
						levelNumber = 3;
						break;
					default: //Level Eins
						levelNumber = 0;
				}

				var buttonEndCss = '';

				if(levelNumber == 3)
				{
					buttonEndCss = 'class="buttonEnd"'
				}

				var itmesArray = getItemsFound();
				
				$('#cover').show();
				$('#messages').show();
				$('#messages').html('<span class="levelCompleteSmaller">Level geschafft<p class="itemFound">' + itmesArray[0][levelNumber] + '</p>' + itmesArray[1][levelNumber] + '<br><button id="startLevel' + nextLevel + '"' + buttonEndCss + '>Weiter</button></span>');
				$('#pausePlay').hide();
				$('#mute').hide();
				$('#hint').hide();
				$('#story').html('');
				
				var music = document.getElementById('music');
				music.pause();
				
			}
		}, 1000);
	}
	
	//Name des aktuellen Levels zurückgeben
	function getLevelName()
	{
		if($('#level').css('display') == 'block')
		{ 
			var levelName = $('#backgroundImage').attr('src');
			return(levelName.substring(16, (levelName.length - 4)));
		}
		
		return 'noLevel';
	}

	//Aktion bei Veränderung der Browser-Fenstergröße
	$(window).resize(function()
	{
		var levelName = getLevelName();

		if(levelName != 'noLevel')
		{
			var dataArray = eval('$.getDataResize'+levelName+'()'); //Daten des entsprechenden Levels holen

			var objectsDrawNot = [];
	
			for(var i = 0; i < dataArray[2].length; i++)
			{
				$('#' + dataArray[2][i] + '').remove(); //Bisherige Grafiken entfernen
				
				if(jQuery.inArray(dataArray[2][i], dataArray[7]) !== -1) //Bereits gefundene Objekte feststellen
				{
					objectsDrawNot.push(dataArray[2][i]);
				}
			}

			prepareDrawing(dataArray[0], dataArray[1], dataArray[2], dataArray[3], dataArray[4], dataArray[5], dataArray[6], objectsDrawNot, false); //Neue Grafiken in richtiger Größe zeichnen
			}
	});
	
	function levelOne() //Erstes Level ausführen
	{
		$('.object').remove();
		$('.objectMap').remove();
	
		$('#pausePlay').show();
		$('#hint').show();
		$('#mute').show();
		
		$('#story').html('<p class="toSearch">Zu suchende Objekte</p>');
		
		//Musik ändern und starten
		musicstatus = true;
		$('#musicMp3').attr('src','music/superKaroshiMp3.mp3');
		$('#musicOgg').attr('src','music/superKaroshiOgg.ogg');
		var music = document.getElementById('music');
		music.load();
		music.play();
				
		var objectsFound = [];
		var objectsDrawNot = [];
		var hintUsed = 0;
		
		//Schwierigkeitsgrad
		level = $("input[name='difficulty']:checked").val();
		
		timeLimit = startTime(level); //Anfangszeit, die vom Schwierigkeitsgrad übergeben wird
		var timeCounter = timer(timeLimit); //Start des Counters
		
		//Array mit den Namen aller Objekte
		var objectNames = ['Pralinen', 'Buch', 'Kleiderbügel', 'Glas', 'Schlüssel', 'Lampe', 'Minion', 'Gemälde', 'Fußabdruck', 'Kerze', 'Blume', 'Seepferdchen', 'Koffer', 'Toad', 'U-Boot'];
		
		//Array mit den IDs aller Objekte (entspricht dem Dateinamen)
		var objectIDs = ['chocolateOne', 'bookOne', 'coathangerOne', 'glassOne', 'keyOne', 'lampOne', 'minionOne', 'paintingOne', 'footprintOne', 'candleOne', 'flowerOne', 'seahorseOne', 'suitcaseOne', 'toadOne', 'subOne'];
		
		//Arrays mit den Originalgrößen der Objekte
		var objectWidth = [51,45,132,21,66,27,43,39,61,30,34,47,95,43,246];
		var objectHeight = [45,55,99,50,32,66,60,49,74,38,21,67,88,59,89];
		
		//Arrays mit den ImageMap-Koordinaten der Objekte
		var chocolateOneCoords = [3,3,8,1,49,4,48,40,44,44,2,40];
		var bookOneCoords = [0,7,5,4,29,1,44,30,39,36,13,43,13,54,10,54,10,43,8,43];
		var coathangerOneCoords = [1,99,1,90,6,84,52,55,64,36,72,34,76,33,76,25,82,12,79,5,70,13,65,9,72,1,85,1,90,9,88,19,81,31,89,34,97,49,130,68,132,78,126,77,123,73,85,53,75,53];
		var glassOneCoords = [3,1,18,2,20,12,15,24,10,32,12,40,20,46,14,49,7,49,2,47,0,43,7,38,4,23,0,12];
		var keyOneCoords = [22,6,66,20,64,26,53,31,33,26,36,19,14,13,1,13,1,5,11,1,21,1];
		var lampOneCoords = [0,16,6,1,22,0,27,13,27,17,19,18,19,65,10,64,9,18];
		var minionOneCoords = [3,14,7,4,16,0,32,1,38,13,38,27,43,48,42,53,33,59,16,60,13,54,1,46];
		var paintingOneCoords = [1,1,1,0,39,0,39,48,0,49,0,0];
		var footprintOneCoords = [49,74,58,70,61,60,56,45,54,27,47,15,41,3,34,1,26,1,15,1,2,3,0,9,6,20,14,30,27,39,38,47,35,56,38,69];
		var candleOneCoords = [10,1,18,2,19,20,30,23,29,31,23,38,1,37,1,31,8,27];
		var flowerOneCoords = [7,0,33,1,33,13,13,21,5,14];
		var seahorseOneCoords = [28,0,41,3,46,17,45,22,36,19,38,34,34,44,17,54,15,66,3,65,0,58,5,47,15,35,11,27,16,15];
		var suitcaseOneCoords = [1,15,37,9,41,0,56,1,60,7,79,5,92,11,95,66,92,70,18,88,6,80,3,72];
		var toadOneCoords = [24,0,39,7,43,18,39,29,31,34,28,37,37,51,25,59,21,58,19,54,12,53,4,57,0,54,1,35,5,33,13,34,8,23,7,13,13,4];
		var subOneCoords = [10,12,70,15,110,7,153,15,195,36,230,55,227,67,206,75,120,88,110,73,86,73,71,77,57,88,45,89,16,76,20,48,0,40,0,24];

		var coords = [chocolateOneCoords, bookOneCoords, coathangerOneCoords, glassOneCoords, keyOneCoords, lampOneCoords, minionOneCoords, paintingOneCoords, footprintOneCoords, candleOneCoords, flowerOneCoords, seahorseOneCoords, suitcaseOneCoords, toadOneCoords, subOneCoords];
		
		var objectCount = difficulty(level, objectIDs.length); //Anzahl der klickbaren Objekte bestimmen lassen
		var arrayIndexes = getObjectsLevel(objectCount, objectIDs.length); //Zufällige Verteilung der klickbaren und nicht-klickbaren Objekte
		prepareDrawing(objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsDrawNot, true); //Aufruf der Vorbereitungsfunktion, in der die Zeichnenfunktion aufgerufen wird

		$('.imageMaps').click(function()
		{
			objectClick(objectsFound, objectCount, $(this).attr('id'), 'One', 'Two', timeLimit, level);
		});
		
		$('#hint').click(function()
		{
			if(getLevelName() == 'levelOne')
			{
				if(hintShow(objectsFound, arrayIndexes, objectIDs, hintUsed))
				{
					hintUsed++;
				}
			}
		});
		
		jQuery.getDataResizelevelOne = function() //Daten für die Window-Resize-Funktion übergeben
		{
			var getDataArray = [objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsFound];
			return(getDataArray);
		};
	}
	
	function levelTwo() //Zweites Level ausführen
	{
		$('.object').remove();
		$('.objectMap').remove();
	
		$('#pausePlay').show();
		$('#hint').show();
		$('#mute').show();
		
		$('#story').html('<p class="toSearch">Zu suchende Objekte</p>');
	
		//Musik ändern und starten
		musicstatus = true;
		$('#musicMp3').attr('src','music/monkeyIslandMp3.mp3');
		$('#musicOgg').attr('src','music/monkeyIslandOgg.ogg');
		var music = document.getElementById('music');
		music.load();
		music.play();
		
		var objectsFound = [];
		var objectsDrawNot = [];
		var hintUsed = 0;
		
		timeLimit = startTime(level); //Anfangszeit, die vom Schwierigkeitsgrad übergeben wird
		var timeCounter = timer(timeLimit); //Start des Counters
		
		//Array mit den Namen aller Objekte
		var objectNames = ['Weinflasche', 'Zahnrad', 'Kerze', 'Marienkäfer', 'Pacman', 'Wappen', 'Angelhaken', 'Affe', 'Seifenblase', 'Kitty', 'Zeitung', 'Ufo', 'Tasse', 'Laterne', 'Falltür', 'Vase', 'Schnecke', 'Apfel', 'Schneeflocke', 'Seestern', 'Hai', 'Tür', 'Gabel', 'Klötzchenturm', 'Minion'];
		
		//Array mit den IDs aller Objekte (entspricht dem Dateinamen)
		var objectIDs = ['wineBottleTwo', 'cogWheelTwo', 'candleTwo', 'ladybugTwo', 'pacmanTwo', 'crestTwo', 'fishHookTwo', 'monkeyTwo', 'soapBubbleTwo', 'kittyTwo', 'paperTwo', 'ufoTwo', 'cupTwo', 'lanternTwo', 'trapdoorTwo', 'vaseTwo', 'snailTwo', 'appleTwo', 'snowflakeTwo', 'starfishTwo', 'sharkTwo', 'doorTwo', 'forkTwo', 'buildingBlocksTwo', 'minionTwo'];
		
		//Arrays mit den Originalgrößen der Objekte
		var objectWidth = [23,34,35,31,29,32,13,93,101,35,39,143,31,26,128,20,75,29,50,39,140,54,14,19,49];
		var objectHeight = [102,22,44,27,22,43,95,84,101,30,46,50,19,68,62,55,59,27,55,30,72,113,93,60,79];
		
		//Arrays mit den ImageMap-Koordinaten der Objekte
		var wineBottleTwoCoords = [15,1,17,14,17,23,15,28,23,33,22,96,15,97,10,101,0,101,0,90,0,39,0,32,5,29,7,16,6,0,13,0];
		var cogWheelTwoCoords = [24,1,33,8,32,17,25,20,17,22,5,19,0,15,0,6,5,3,10,1,17,0];
		var candleTwoCoords = [17,3,17,13,18,21,19,28,17,33,26,27,33,27,34,34,31,38,29,40,24,44,16,44,5,43,0,38,5,36,13,35,12,25,12,18,13,6,12,1,15,0];
		var ladybugTwoCoords = [26,4,24,0,18,1,14,1,9,3,9,11,0,12,8,17,6,20,10,26,18,24,23,19,29,12];
		var pacmanTwoCoords = [19,0,27,5,25,8,18,10,17,11,29,17,23,22,9,22,2,15,1,4,6,0];
		var crestTwoCoords = [19,0,25,10,31,21,32,32,29,42,25,42,17,38,12,31,6,23,0,12,0,9];
		var fishHookTwoCoords = [3,0,0,0,1,11,2,21,1,33,1,47,3,61,3,71,2,74,3,75,2,85,5,94,9,94,12,94,13,86];
		var monkeyTwoCoords = [41,2,51,10,50,17,45,19,49,30,54,44,55,54,60,64,74,61,82,68,91,66,90,73,80,73,75,69,71,67,67,68,58,69,51,68,50,69,52,76,51,83,45,84,37,82,34,80,39,76,42,71,37,66,33,63,28,65,25,69,29,79,28,83,21,83,13,83,12,80,18,77,20,75,17,69,20,63,21,55,19,48,18,41,17,32,13,33,13,33,12,36,12,44,12,50,12,56,15,62,12,63,7,58,5,44,4,35,4,26,7,20,7,15,2,14,0,7,2,1,10,2,18,8,17,2,24,0,33,6];
		var soapBubbleTwoCoords = [65,3,83,12,95,30,100,50,97,67,88,83,75,94,56,99,36,98,17,88,7,74,0,60,0,44,3,31,10,17,18,10,39,0,57,0];
		var kittyTwoCoords = [34,1,33,9,35,18,33,23,31,29,24,29,8,30,5,27,0,29,0,22,2,16,6,10,6,4,15,5,22,1];
		var paperTwoCoords = [9,4,22,1,38,0,39,20,38,41,17,45,7,45,3,39,1,32,1,21,2,16,0,8,0,5,8,4];
		var ufoTwoCoords = [102,10,121,10,140,11,140,17,126,25,107,32,106,38,100,39,97,39,91,43,78,48,70,49,55,50,45,49,43,47,28,47,9,46,1,45,1,43,10,36,24,30,38,22,44,18,51,7,58,5,80,0];
		var cupTwoCoords = [22,0,31,6,30,8,31,14,25,18,13,18,3,16,0,12,0,9,7,10,13,10,14,6];
		var lanternTwoCoords = [15,1,15,13,16,23,21,30,25,41,22,50,20,59,16,63,14,67,11,66,9,57,5,49,3,43,0,41,3,34,7,30,11,29,10,25,13,21,13,1];
		var trapdoorTwoCoords = [118,0,122,24,128,51,127,61,103,62,61,61,43,61,18,60,0,61,1,53,15,36,24,22,38,4,40,0];
		var vaseTwoCoords = [14,0,17,15,19,33,19,46,14,55,5,54,2,48,0,39,0,25,2,17,5,9,5,0];
		var snailTwoCoords = [46,3,56,17,55,35,62,34,64,29,72,38,67,41,65,51,59,53,57,53,53,58,49,58,44,56,40,54,36,49,29,48,24,44,21,40,10,37,7,32,4,29,0,25,1,19,6,17,7,25,12,25,13,14,17,6,21,3,29,0,37,0];
		var appleTwoCoords = [29,14,25,24,23,26,14,27,8,26,2,20,0,13,1,8,4,2,6,1,9,1,10,9,16,17,22,12,25,7,21,8,26,6,29,13];
		var snowflakeTwoCoords = [28,1,29,9,28,12,35,7,37,5,36,16,42,14,49,14,49,15,40,23,49,28,41,31,40,31,41,39,38,39,36,39,38,50,30,42,28,44,26,55,23,50,23,44,21,43,15,49,13,50,14,40,13,38,7,42,3,42,2,39,11,34,11,31,2,30,0,27,11,26,9,20,3,18,1,13,10,15,13,18,17,17,12,9,12,5,19,14,22,12,21,5,24,0];
		var starfishTwoCoords = [28,0,25,8,23,16,33,23,39,25,28,26,25,26,21,25,20,29,16,30,14,27,8,26,4,24,9,21,9,15,4,9,0,4,6,8,14,13,19,11];
		var sharkTwoCoords = [140,11,135,19,128,25,122,31,126,40,128,50,125,51,122,49,117,43,112,38,102,42,89,46,79,58,69,64,72,60,67,55,62,57,58,55,50,60,41,57,37,65,31,71,27,68,28,62,18,58,2,51,1,47,12,49,34,52,41,50,43,43,49,44,67,32,80,23,80,16,77,7,75,4,74,1,83,3,93,12,105,7,120,4,130,0,139,0,139,5];
		var doorTwoCoords = [54,0,54,31,53,113,0,112,0,0];
		var forkTwoCoords = [12,1,13,11,13,23,10,31,11,46,11,78,12,93,4,92,4,48,5,30,0,22,0,9,1,0];
		var buildingBlocksTwoCoords = [19,15,18,41,18,56,10,60,0,57,0,36,0,22,0,5,6,0,15,1,10,1,19,2];
		var minionTwoCoords = [31,3,40,11,44,20,44,27,47,38,48,47,47,52,48,62,42,69,37,69,35,73,34,77,31,79,22,79,20,77,19,69,9,63,7,59,6,50,4,32,0,27,0,17,2,10,7,5,14,2,23,0,30,1];

		var coords = [wineBottleTwoCoords, cogWheelTwoCoords, candleTwoCoords, ladybugTwoCoords, pacmanTwoCoords, crestTwoCoords, fishHookTwoCoords, monkeyTwoCoords, soapBubbleTwoCoords, kittyTwoCoords, paperTwoCoords, ufoTwoCoords, cupTwoCoords, lanternTwoCoords, trapdoorTwoCoords, vaseTwoCoords, snailTwoCoords, appleTwoCoords, snowflakeTwoCoords, starfishTwoCoords, sharkTwoCoords, doorTwoCoords, forkTwoCoords, buildingBlocksTwoCoords, minionTwoCoords];
		
		var objectCount = difficulty(level, objectIDs.length); //Anzahl der klickbaren Objekte bestimmen lassen
		var arrayIndexes = getObjectsLevel(objectCount, objectIDs.length); //Zufällige Verteilung der klickbaren und nicht-klickbaren Objekte
		prepareDrawing(objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsDrawNot, true); //Aufruf der Vorbereitungsfunktion, in der die Zeichnenfunktion aufgerufen wird
		
		$('.imageMaps').click(function()
		{
			objectClick(objectsFound, objectCount, $(this).attr('id'), 'Two', 'Three', timeLimit, level);
		});
		
		$('#hint').click(function()
		{
			if(getLevelName() == 'levelTwo')
			{
				if(hintShow(objectsFound, arrayIndexes, objectIDs, hintUsed))
				{
					hintUsed++;
				}
			}
		});
		
		jQuery.getDataResizelevelTwo = function() //Daten für die Window-Resize-Funktion übergeben
		{
			var getDataArray = [objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsFound];
			return(getDataArray);
		};	
	}
	
	function levelThree() //Drittes Level ausführen
	{
		$('.object').remove();
		$('.objectMap').remove();
	
		$('#pausePlay').show();
		$('#hint').show();
		$('#mute').show();
		
		$('#story').html('<p class="toSearch">Zu suchende Objekte</p>');
	
		//Musik ändern und starten
		musicstatus = true;
		$('#musicMp3').attr('src','music/sevenDaysMp3.mp3');
		$('#musicOgg').attr('src','music/sevenDaysOgg.ogg');
		var music = document.getElementById('music');
		music.load();
		music.play();
		
		var objectsFound = [];
		var objectsDrawNot = [];
		var hintUsed = 0;
		
		timeLimit = startTime(level); //Anfangszeit, die vom Schwierigkeitsgrad übergeben wird
		var timeCounter = timer(timeLimit); //Start des Counters
		
		//Array mit den Namen aller Objekte
		var objectNames = ['Zange', 'Fußabdruck', 'Fleck', 'Drachen', 'Abfalleimer', 'Erste Hilfe Kasten', 'Ring', 'Karte', 'Minion', 'Apfel', 'Wookie', 'Kompass', 'Flamme', 'Gasmaske', 'Wasserflasche', 'Hebel', 'Tasse', 'Uhr', 'Wunderlampe', 'Kamera', 'Strahler', 'Bullauge', 'Leiter', 'Falltür', 'Vorhängeschloss'];
		
		//Array mit den IDs aller Objekte (entspricht dem Dateinamen)
		var objectIDs = ['pliersThree', 'footprintThree', 'stainThree', 'dragonsThree', 'trashCanThree', 'firstaidThree', 'ringThree', 'mapThree', 'minionThree', 'appleThree', 'wookieThree', 'compassThree', 'flameThree', 'gasMaskThree', 'bottleThree', 'leverThree', 'cupThree', 'clockThree', 'magicLampThree', 'cameraThree', 'spotlightThree', 'portholeThree', 'ladderThree', 'trapdoorThree', 'padlockThree'];
		
		//Arrays mit den Originalgrößen der Objekte
		var objectWidth = [121,78,46,106,74,95,27,84,52,32,54,34,36,60,20,25,56,62,103,56,85,53,100,113,23];
		var objectHeight = [62,33,70,96,96,57,26,86,70,34,109,24,46,81,51,65,37,67,54,58,48,48,227,95,47];
		
		//Arrays mit den ImageMap-Koordinaten der Objekte
		var pliersThreeCoords = [82,8,74,13,64,19,56,28,47,41,60,39,73,39,86,36,102,31,110,28,116,27,121,34,115,36,106,40,91,44,71,47,60,47,59,50,57,54,52,50,47,50,40,51,34,57,29,61,17,62,14,58,16,56,24,59,34,52,33,49,31,47,26,47,25,52,21,52,17,48,12,49,6,49,6,55,1,54,0,48,9,46,17,42,30,43,31,39,26,35,26,33,35,34,41,24,52,13,67,4,78,1,85,6];
		var footprintThreeCoords = [48,4,56,10,66,16,77,21,77,25,73,31,65,33,57,28,52,23,47,20,40,22,33,24,25,25,21,22,19,21,15,22,9,23,3,21,2,18,4,15,8,13,10,10,13,8,16,7,16,3,22,2,26,0,33,0,40,3,46,4];
		var stainThreeCoords = [38,21,36,24,44,29,40,32,35,28,30,32,36,39,36,45,30,41,27,33,27,52,24,50,24,33,20,37,20,63,17,70,16,69,16,62,17,48,17,34,13,28,8,35,2,38,4,32,2,30,1,24,7,22,8,14,1,9,5,7,10,10,14,6,14,0,21,7,24,0,28,8,33,3,36,13,44,7,44,12,42,18];
		var dragonsThreeCoords = [71,6,83,12,90,20,98,29,104,41,105,50,104,53,105,61,102,66,98,69,95,71,91,79,88,86,76,92,67,95,59,93,46,91,37,89,32,87,26,81,21,78,16,74,7,67,4,61,0,51,1,41,5,34,6,30,9,28,8,24,15,15,18,10,24,10,26,7,32,3,43,1,51,4,53,2,59,1];
		var trashCanThreeCoords = [59,74,55,87,44,96,20,96,10,87,9,74,6,45,2,38,1,23,8,11,19,4,29,1,39,1,53,2,63,7,72,12,73,20,72,32,72,45,70,51,65,48];
		var firstaidThreeCoords = [92,10,90,18,90,28,89,35,86,40,78,49,67,55,41,53,6,46,3,18,3,13,0,11,10,3,16,0,34,1,57,1,71,0,92,4];
		var ringThreeCoords = [22,2,27,12,26,20,18,23,10,25,5,25,0,19,2,8,9,3,15,0];
		var mapThreeCoords = [83,28,80,35,79,43,77,48,73,55,72,60,68,69,65,77,63,84,59,85,47,80,38,77,30,74,22,71,13,69,7,65,1,64,1,57,5,48,7,42,9,37,13,32,12,27,15,22,18,17,18,11,20,5,22,2,28,5,38,7,46,9,54,12,65,15,75,20,83,23];
		var minionThreeCoords = [46,14,44,23,43,29,42,40,44,45,48,53,43,57,39,59,37,53,31,56,27,57,24,62,19,65,18,61,21,57,18,52,17,45,18,38,15,35,11,36,8,39,7,43,5,42,3,44,0,39,5,34,10,34,15,31,11,25,12,16,17,10,24,7,32,10,35,9,40,16,42,12,39,8,37,0,43,4,51,0,50,7];
		var appleThreeCoords = [28,4,31,15,28,26,23,30,13,32,8,30,7,24,9,16,8,13,2,10,2,5,8,2,16,1];
		var wookieThreeCoords = [38,2,44,11,46,21,44,28,46,37,44,42,44,50,50,61,52,81,51,98,51,107,35,106,22,105,6,103,5,94,3,77,1,65,2,53,9,44,11,40,14,31,17,14,20,5,28,1];
		var compassThreeCoords = [32,5,32,15,26,20,21,22,11,24,4,20,0,14,2,6,7,2,13,0,22,1,30,2];
		var flameThreeCoords = [23,15,33,24,35,30,34,39,29,42,27,42,18,45,14,44,6,37,6,32,7,26,5,21,1,17,7,15,6,8,6,1,8,0,10,7,12,15,19,16,15,8];
		var gasMaskThreeCoords = [37,19,46,18,52,26,49,30,43,33,42,35,44,43,48,49,49,57,56,65,59,74,51,79,49,80,43,78,41,70,41,65,39,59,34,54,30,50,27,44,22,40,21,39,16,41,7,44,2,42,1,34,6,30,14,27,8,24,2,21,2,15,4,11,4,6,9,2,15,1,22,1,29,5,36,8,39,14];
		var bottleThreeCoords = [17,7,19,12,20,24,18,36,18,49,17,50,12,48,7,45,4,45,0,44,1,32,1,22,2,11,8,7,9,0,16,0];
		var leverThreeCoords = [23,31,25,43,24,60,20,65,9,64,3,64,1,58,0,42,0,29,11,29,14,27,16,18,18,8,17,6,17,2,22,0,25,5,24,7,21,16,19,26];
		var cupThreeCoords = [22,36,11,32,2,27,1,19,6,15,13,12,15,7,19,1,28,1,39,3,47,7,48,12,55,12,56,19,55,22,56,28,55,30,52,33,46,36];
		var clockThreeCoords = [45,5,54,14,61,28,60,36,58,48,49,57,44,62,30,65,21,63,11,56,3,47,0,34,2,24,8,13,16,6,23,3,32,1,41,3];
		var magicLampThreeCoords = [90,10,81,17,74,26,64,33,55,37,64,42,62,48,56,50,40,53,39,52,37,52,41,45,42,43,30,41,26,36,25,34,22,40,18,40,16,37,17,35,12,33,5,32,1,27,5,21,13,17,21,20,24,27,29,23,29,20,33,17,37,15,40,13,40,9,37,7,38,4,39,2,44,3,45,10,53,14,63,16,76,12,90,3,102,0,98,5];
		var cameraThreeCoords = [49,11,56,18,56,28,54,36,48,42,38,42,34,47,28,50,22,55,14,56,5,55,0,47,1,40,4,34,6,28,6,18,7,10,11,5,18,2,27,6,36,2,40,1,48,7];
		var spotlightThreeCoords = [80,10,84,25,84,39,79,42,55,43,37,45,18,48,4,47,1,34,1,29,0,18,74,11,77,4];
		var portholeThreeCoords = [43,3,52,14,52,29,46,38,33,45,23,48,4,42,0,34,2,17,7,10,16,3,30,0,42,2];
		var ladderThreeCoords = [53,2,57,13,59,27,61,37,68,41,68,48,75,85,83,137,94,194,98,213,100,222,93,224,91,222,77,225,60,225,50,226,48,224,42,211,11,211,8,209,8,226,0,227,1,189,4,162,3,128,5,79,6,39,7,17,6,3,12,7,13,12,19,12,30,11,44,10,49,8,51,1];
		var trapdoorThreeCoords = [108,16,91,47,62,94,41,91,1,86,8,30,12,5];
		var padlockThreeCoords = [15,5,18,15,17,20,23,29,22,40,19,45,15,46,7,42,2,43,2,29,1,19,5,18,4,9,4,2,9,0,15,3];

		var coords = [pliersThreeCoords, footprintThreeCoords, stainThreeCoords, dragonsThreeCoords, trashCanThreeCoords, firstaidThreeCoords, ringThreeCoords, mapThreeCoords, minionThreeCoords, appleThreeCoords, wookieThreeCoords, compassThreeCoords, flameThreeCoords, gasMaskThreeCoords, bottleThreeCoords, leverThreeCoords, cupThreeCoords, clockThreeCoords, magicLampThreeCoords, cameraThreeCoords, spotlightThreeCoords, portholeThreeCoords, ladderThreeCoords, trapdoorThreeCoords, padlockThreeCoords];
		
		var objectCount = difficulty(level, objectIDs.length); //Anzahl der klickbaren Objekte bestimmen lassen
		var arrayIndexes = getObjectsLevel(objectCount, objectIDs.length); //Zufällige Verteilung der klickbaren und nicht-klickbaren Objekte
		prepareDrawing(objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsDrawNot, true); //Aufruf der Vorbereitungsfunktion, in der die Zeichnenfunktion aufgerufen wird
		
		$('.imageMaps').click(function()
		{
			objectClick(objectsFound, objectCount, $(this).attr('id'), 'Three', 'Four', timeLimit, level);
		});
		
		$('#hint').click(function()
		{
			if(getLevelName() == 'levelThree')
			{
				if(hintShow(objectsFound, arrayIndexes, objectIDs, hintUsed))
				{
					hintUsed++;
				}
			}
		});
		
		jQuery.getDataResizelevelThree = function() //Daten für die Window-Resize-Funktion übergeben
		{
			var getDataArray = [objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsFound];
			return(getDataArray);
		};	
	}

	function levelFour() //Viertes Level ausführen
	{
		$('.object').remove();
		$('.objectMap').remove();
	
		$('#pausePlay').show();
		$('#hint').show();
		$('#mute').show();
		
		$('#story').html('<p class="toSearch">Zu suchende Objekte</p>');
	
		//Musik ändern und starten
		musicstatus = true;
		$('#musicMp3').attr('src','music/gotMp3.mp3');
		$('#musicOgg').attr('src','music/gotOgg.ogg');
		var music = document.getElementById('music');
		music.load();
		music.play();
		
		var objectsFound = [];
		var objectsDrawNot = [];
		var hintUsed = 0;
		
		timeLimit = startTime(level); //Anfangszeit, die vom Schwierigkeitsgrad übergeben wird
		var timeCounter = timer(timeLimit); //Start des Counters
		
		//Array mit den Namen aller Objekte
		var objectNames = ['Taschenlampe', 'Bürste', 'Ghostbusters', 'Smiley', 'Radio', 'Brille', 'Sauerstoffflasche', 'Marienkäfer', 'Todesstern', 'Brief', 'Ufo', 'Trauben', 'Rose', 'Minion', 'Taschenuhr', 'Hebel', 'Wolf', 'Erste-Hilfe-Kasten', 'Stuhl', 'U-Boot'];
		
		//Array mit den IDs aller Objekte (entspricht dem Dateinamen)
		var objectIDs = ['torchFour', 'brushFour', 'ghostbustersFour', 'smileyFour', 'radioFour', 'glassesFour', 'oxygenFlaskFour', 'ladybugFour', 'deathStarFour', 'letterFour', 'ufoFour', 'grapesFour', 'roseFour', 'minionFour', 'pocketWatchFour', 'leverFour', 'wolfFour', 'firstaidFour', 'chairFour', 'subFour'];
		
		//Arrays mit den Originalgrößen der Objekte
		var objectWidth = [64,80,67,46,147,54,71,23,104,79,140,70,47,48,38,41,31,43,44,51,50,70];
		var objectHeight = [35,39,43,45,128,24,121,22,96,70,47,48,38,54,40,50,47,61,79,67];
		
		//Arrays mit den ImageMap-Koordinaten der Objekte
		var torchFourCoords = [61,0,64,8,62,12,52,17,31,24,25,30,11,35,2,29,0,21,0,15,5,10,12,9,18,8,27,10,29,8];
		var brushFourCoords = [59,8,70,10,79,14,79,22,76,24,79,32,77,36,70,38,64,39,56,38,49,37,48,29,49,19,51,12,30,11,27,31,19,30,4,26,0,23,2,14,0,9,2,3,7,1,20,1,31,4,30,9];
		var ghostbustersFourCoords = [55,6,64,16,67,28,63,33,50,42,31,41,18,34,14,27,13,18,7,17,3,17,2,9,3,5,14,9,23,4,35,2,42,0,51,2];
		var smileyFourCoords = [35,3,45,13,45,23,44,34,38,39,27,44,20,40,16,38,6,40,0,25,0,16,5,6,12,2,23,0];
		var radioFourCoords = [143,6,144,21,146,53,147,73,140,83,121,93,39,127,26,124,15,106,2,87,1,44,0,30,10,23,52,10,89,0,115,1,138,1];
		var glassesFourCoords = [45,1,53,5,50,16,46,19,38,16,37,14,34,18,29,22,19,22,15,19,15,16,8,13,0,9,0,4,9,9,17,12,29,10,40,9,44,7,40,4,33,1,35,0];
		var oxygenFlaskFourCoords = [62,2,71,9,64,19,60,19,58,23,58,30,57,38,54,41,58,52,53,66,31,117,24,120,10,120,2,111,1,106,4,94,21,59,29,42,36,36,43,35,45,25,45,16,51,19,52,15,51,6,51,2,56,0];
		var ladybugFourCoords = [2,15,4,4,19,1,21,6,20,14,17,20,7,20,3,19];
		var deathStarFourCoords = [63,2,79,11,85,23,95,33,97,48,104,56,96,82,90,78,76,80,71,86,70,96,46,95,24,80,5,63,0,46,1,30,7,19,18,9,35,0,52,0];
		var letterFourCoords = [49,11,63,25,79,41,46,59,32,69,0,32,28,1];
		var ufoFourCoords = [90,2,100,9,109,14,140,19,139,30,134,31,109,38,104,42,96,41,88,45,67,46,58,44,52,44,48,42,45,43,40,38,25,37,10,34,1,31,11,26,40,17,52,5,55,4,82,1];
		var grapesFourCoords = [48,8,51,19,59,23,68,29,69,38,66,43,60,45,54,43,45,46,40,38,36,41,30,41,25,35,19,39,17,35,15,36,9,34,6,32,3,32,2,24,4,22,1,15,6,13,13,14,18,11,23,8,29,13,33,10,39,7,45,4,51,0];
		var roseFourCoords = [22,1,32,3,31,6,29,13,18,10,7,10,2,17,17,17,35,19,35,27,23,36,13,37,7,34,0,25,0,16,4,6,11,2,17,1];
		var minionFourCoords = [30,1,37,13,40,25,41,38,41,44,34,46,31,53,25,53,24,53,19,53,15,51,20,49,19,46,14,44,12,41,8,39,2,31,3,28,2,22,4,15,9,10,12,4,17,1,22,0];
		var pocketWatchFourCoords = [20,9,29,16,30,24,27,34,21,39,11,39,4,35,2,29,0,19,6,13,11,10,9,8,7,4,8,2,18,0,17,5,15,7];
		var leverFourCoords = [24,1,42,13,41,46,29,50,11,40,11,19,1,9,5,1,14,6];
		var wolfFourCoords = [43,3,43,32,41,32,40,37,37,38,34,45,26,43,22,38,17,35,15,31,12,31,8,37,0,27,3,23,11,15,21,9,27,4,34,2,43,1];
		var firstaidFourCoords = [17,0,32,15,50,31,49,40,46,53,44,57,29,61,0,27,3,15,4,4];
		var chairFourCoords = [27,3,26,15,28,31,41,38,49,43,49,53,48,68,45,68,44,49,31,54,29,55,29,78,24,79,24,52,8,44,3,51,0,49,4,36,0,7,21,1];
		var subFourCoords = [50,15,56,12,64,13,69,21,68,28,63,34,53,42,39,46,31,49,33,57,29,63,25,66,16,59,14,64,13,60,11,56,4,57,8,51,3,47,2,43,8,43,4,35,11,31,21,34,29,31,37,24,33,16,36,12,37,11,34,6,37,3,41,0,43,8];

		var coords = [torchFourCoords, brushFourCoords, ghostbustersFourCoords, smileyFourCoords, radioFourCoords, glassesFourCoords, oxygenFlaskFourCoords, ladybugFourCoords, deathStarFourCoords, letterFourCoords, ufoFourCoords, grapesFourCoords, roseFourCoords, minionFourCoords, pocketWatchFourCoords, leverFourCoords, wolfFourCoords, firstaidFourCoords, chairFourCoords, subFourCoords];
		
		var objectCount = difficulty(level, objectIDs.length); //Anzahl der klickbaren Objekte bestimmen lassen
		var arrayIndexes = getObjectsLevel(objectCount, objectIDs.length); //Zufällige Verteilung der klickbaren und nicht-klickbaren Objekte
		prepareDrawing(objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsDrawNot, true); //Aufruf der Vorbereitungsfunktion, in der die Zeichnenfunktion aufgerufen wird
		
		$('.imageMaps').click(function()
		{
			objectClick(objectsFound, objectCount, $(this).attr('id'), 'Four', 'End', timeLimit, level);
		});
		
		$('#hint').click(function()
		{
			if(getLevelName() == 'levelFour')
			{
				if(hintShow(objectsFound, arrayIndexes, objectIDs, hintUsed))
				{
					hintUsed++;
				}
			}
		});
		
		jQuery.getDataResizelevelFour = function() //Daten für die Window-Resize-Funktion übergeben
		{
			var getDataArray = [objectCount, objectNames, objectIDs, objectWidth, objectHeight, coords, arrayIndexes, objectsFound];
			return(getDataArray);
		};
	}

	//Aufruf Level One
	$('#cutScenes').on('click','#startLevelOne',function() 
	{
		musicstatus = false;
		var music = document.getElementById('music');
		music.pause();

		$('#main').show();
		$('#home').hide();
		$('#cover').hide();
		$('#cutScenes').hide();
		
		//Array für die Dialog-Zeilen
		var dialogueRows = ['Eine unbekannte Zeit später in einem unbekannten Zimmer', '„Urg…was ist passiert? Wo..Woah..träume ich oder sind das Fische in der Decke?“', '„Das letzte, an das ich mich erinnern kann ist das Meer..eine Welle…Wasser…“', '„Wasser…“', '„Moooment, bin ich…bin ich etwa UNTER Wasser?“', '„…Oh Man, was zur…“', 'Dekompositionsprozess ist eingeleitet, es verbleiben 20 Minuten um die Station zu verlassen.', '„Dekompositionsprozess in 20 Minuten…das klingt nicht sehr gut.“', '„Ich sollte mich vielleicht wirklich nicht mit Fragen aufhalten, sondern erstmal einen Weg hier raus finden, auch wenn ich keine Ahnung habe, was hier eigentlich los ist.“', '„So ein Mist, die Tür ist verschlossen.“', '„Hier muss doch irgendwo etwas rumliegen, womit ich die Tür öffnen kann…“'];
		
		var keyPressed = 1;
		
		$('#story').html('<p>LEERTASTE drücken zum weiterschalten</p><br>' + dialogueRows[0]);
		
		$(document).keyup(function(event) //Funktion zum Abprüfen der Leertaste -> Dialog weiterschalten
		{		
			if(event.keyCode == 32)
			{
				if(keyPressed == dialogueRows.length) //Dialog zu Ende -> Level eins starten
				{
					levelOne();
				}
				
				if(keyPressed == 1)
				{
					$('#story').html('<div style="float:left;"><img id="avatar" src="img/avatar.png" alt="Avatar"></div><div id="dialogue">' + dialogueRows[keyPressed] + '</div>');
					
					calculateAvatarSize(); //Größe des Avatar-Bildes festlegen
				}
				else if(keyPressed == 6)
				{
					$('#avatar').hide();
					$('#dialogue').html(dialogueRows[keyPressed]);
				}
				else
				{
					$('#avatar').show();
					$('#dialogue').html(dialogueRows[keyPressed]);
				}
				keyPressed++;
			}
		});
	});
	
	//Aufruf Level Two
	$('#messages').on('click','#startLevelTwo',function() 
	{
		$('.object').remove();	
	
		$('#main').show();
		$('#home').hide();
		$('#cover').hide();
		$('#cutScenes').hide();
		
		$('#timer').html('00:00');
		
		$('#backgroundImage').attr('src','img/backgrounds/levelTwo.jpg'); //Spielhintergrund festlegen
		
		//Array für die Dialog-Zeilen
		var dialogueRows = ['„Ah perfekt, jetzt bin ich hier wenigstens rausgekommen.“', '„Hm, aber sehr viel weiter bin ich jetzt offenbar auch nicht...“', '„Wieder ein völlig menschenleerer Raum, wieder Fische in der Decke und wieder…“', '„...eine verschlossene Tür.“', 'Dekompositionsprozess beginnt in 10 Minuten. Bitte verlassen Sie unter allen Umständen die Station.', '„Arg, was passiert hier nur?“', '„Langsam bekomme ich es doch mit der Angst zu tun...“', '„Ganz schnell…vielleicht finde ich hier ja wieder einen Schlüssel!“'];
		
		var keyPressed = 0;

		$('#story').html('<div style="float:left;"><img id="avatar" src="img/avatar.png" alt="Avatar"></div><div id="dialogue">' + dialogueRows[keyPressed] + '</div>');
		
		calculateAvatarSize(); //Größe des Avatar-Bildes festlegen
		
		$(document).keyup(function(event) //Funktion zum Abprüfen der Leertaste -> Dialog weiterschalten
		{
			keyPressed++;

			if(event.keyCode == 32)
			{
				if(keyPressed == dialogueRows.length) //Dialog zu Ende -> Level zwei starten
				{
					levelTwo();
				}
				else if(keyPressed == 4)
				{
					$('#avatar').hide();
					$('#dialogue').html(dialogueRows[keyPressed]);
				}
				else
				{
					$('#avatar').show();
					$('#dialogue').html(dialogueRows[keyPressed]);
				}

				$('#dialogue').html(dialogueRows[keyPressed]);				
			}
		});
	});

	//Aufruf Level Three
	$('#messages').on('click','#startLevelThree',function() 
	{
		$('.object').remove();		
	
		$('#main').show();
		$('#home').hide();
		$('#cover').hide();
		$('#cutScenes').hide();
		
		$('#timer').html('00:00');
		
		$('#backgroundImage').attr('src','img/backgrounds/levelThree.jpg'); //Spielhintergrund festlegen
		
		//Array für die Dialog-Zeilen
		var dialogueRows = ['„Tja, einen Schlüssel habe ich zwar nicht gefunden, aber zumindest einen anderen Ausgang, der nicht versperrt war.“', '„Aber wo bin ich hier nur?“', '„Sieht aus wie eine Art Kontrollraum…“', '„Aber wieder keine Menschenseele…gruselig“', '„Na zumindest gibt es hier keine verschlossenen Türen!“', 'Achtung, Achtung! Begeben Sie sich bitte unverzüglich zu den Rettungskapseln.', '„Nicht schon wieder….das wird ja immer penetranter…“', '„…und ist definitiv kein gutes Zeichen.“', '„Hm…Zu den Rettungskapseln…“', '„Vielleicht sollte ich mich wirklich dahin begeben. Sicher ist sicher.“', '„Aber nur wie? Ich hab‘ schließlich keine Ahnung wo ich hier bin!“', '„Hey, du!“', '„Jaa duu da draußen vor dem Bildschirm!“', '„Hilf mir einen Weg hier raus und zu den Rettungskapseln zu finden!“'];
		
		var keyPressed = 0;
		
		$('#story').html('<div style="float:left;"><img id="avatar" src="img/avatar.png" alt="Avatar"></div><div id="dialogue">' + dialogueRows[keyPressed] + '</div>');
		
		calculateAvatarSize(); //Größe des Avatar-Bildes festlegen
		
		$(document).keyup(function(event) //Funktion zum Abprüfen der Leertaste -> Dialog weiterschalten
		{
			keyPressed++;

			if(event.keyCode == 32)
			{
				if(keyPressed == dialogueRows.length) //Dialog zu Ende -> Level zwei starten
				{
					levelThree();
				}
				else if(keyPressed == 5)
				{
					$('#avatar').hide();
					$('#dialogue').html(dialogueRows[keyPressed]);
				}
				else
				{
					$('#avatar').show();
					$('#dialogue').html(dialogueRows[keyPressed]);
				}


				$('#dialogue').html(dialogueRows[keyPressed]);				
			}
		});
	});

	//Aufruf Level Four
	$('#messages').on('click','#startLevelFour',function() 
	{
		$('.object').remove();		
	
		$('#main').show();
		$('#home').hide();
		$('#cover').hide();
		$('#cutScenes').hide();
		
		$('#timer').html('00:00');
		
		$('#backgroundImage').attr('src','img/backgrounds/levelFour.jpg'); //Spielhintergrund festlegen
		
		//Array für die Dialog-Zeilen
		var dialogueRows = ['„Gute Arbeit!“', '„Mithilfe der Karte war es mir möglich, mich durch die Station bis zu den Rettungskapseln zu navigieren!“', '„Allerdings habe ich auf meinem Weg hier her tatsächlich niemanden getroffen…“', '„Das gefällt mir nicht…“', 'Letzte Warnung: Es verbleiben nur noch wenige Minuten bis zum Dekompositionsprozess.', '„Und das gefällt mir erst recht nicht…“', '„Ich will hier einfach nur noch weg…“', '„…wo sind denn jetzt nur diese blöden Rettungskapseln?“'];
		
		var keyPressed = 0;
		
		$('#story').html('<div style="float:left;"><img id="avatar" src="img/avatar.png" alt="Avatar"></div><div id="dialogue">' + dialogueRows[keyPressed] + '</div>');
		
		calculateAvatarSize(); //Größe des Avatar-Bildes festlegen
		
		$(document).keyup(function(event) //Funktion zum Abprüfen der Leertaste -> Dialog weiterschalten
		{
			keyPressed++;

			if(event.keyCode == 32)
			{
				if(keyPressed == dialogueRows.length) //Dialog zu Ende -> Level zwei starten
				{
					levelFour();
				}
				else if(keyPressed == 4)
				{
					$('#avatar').hide();
					$('#dialogue').html(dialogueRows[keyPressed]);
				}
				else
				{
					$('#avatar').show();
					$('#dialogue').html(dialogueRows[keyPressed]);
				}

				$('#dialogue').html(dialogueRows[keyPressed]);				
			}
		});
	});
	
	//Spielstart -> Sprite (Intro) abspielen
	$('#start').click(function()
	{
		musicstatus = true;
		var music = document.getElementById('music');
		music.play();

		$('#chooseDifficulty').hide();
	    $('#showHighscore').hide();
		$('#cutScenes').show();
		$('#human').show();
		$('#home').hide();
		$('#main').hide();
		$('#pausePlay').hide();
		$('#hint').hide();
		$('#mute').hide();
		$('#chooseDifficulty').hide();
		$('#endTitles').hide();
		$('#bubbleOne').hide();
		$('#bubbleTwo').hide();
		$('#bubbleThree').hide();
		$('#bubbleFour').hide();
		$('#splash').hide();
		$('#tardis').hide();
		$('#jump').hide();
		$('#humanOcean').hide();
		
		$('#water').pan({fps: 30, speed: 2, dir: 'left'});
		$('#waterTwo').pan({fps: 30, speed: 1, dir: 'right'});
		$('#clouds').pan({fps: 30, speed: 0.7, dir: 'left'});
		$('#bird').pan({fps: 30, speed: 1, dir: 'right'});
		
		//Sprechblasen und Splash
		setTimeout(function(){$('#bubbleOne').fadeIn(1000);}, 2000);
		setTimeout(function(){$('#bubbleOne').fadeOut(1000);}, 6000);
		setTimeout(function(){$('#bubbleTwo').fadeIn(1000);}, 9000);
		setTimeout(function(){$('#bubbleTwo').fadeOut(1000);}, 10000);
		setTimeout(function(){$('#splash').show();}, 10500);
		setTimeout(function(){$('#splash').fadeOut(1000);}, 13000);
		setTimeout(function(){$('#bubbleThree').fadeIn(1000);}, 14000);
		setTimeout(function(){$('#bubbleThree').fadeOut(1000);}, 17000);
		setTimeout(function(){$('#bubbleFour').fadeIn(1000);}, 20000);
		setTimeout(function(){$('#bubbleFour').fadeOut(1000);}, 23000);
		
		//Sprung ins Meer
		setTimeout(function(){$('#human').hide();}, 9000);
		
		setTimeout(function() //GIF (neu) laden bei Beginn des Sprungs zwecks Synchronität und anzeigen lassen
		{
			var tmp = $('#jumpImg').attr('src');
			$('#jumpImg').attr('src', '');
			$('#jumpImg').attr('src', tmp);
			$('#jump').show();
		}, 9000);
		
		setTimeout(function(){$('#jump').hide();}, 10400);
		setTimeout(function(){$('#humanOcean').show();}, 10400);
		
		setTimeout(function() //Mensch untergehen lassen
		{
			$('#humanOcean').animate(
			{
				top:'45px'
			}, 200);
		}, 19000);
		
		setTimeout(function() //Button erstellen
		{			
			$('#cutScenes').append('<button id="startLevelOne">Fortsetzen</button>');
		}, 1000);
		
		setTimeout(function() //EasterEgg (Tardis)
		{
			$('#tardis').fadeIn(1000);
			setTimeout(function(){$('#tardis').pan({fps: 30, speed: 2, dir: 'up'});}, 1000);
			setTimeout(function(){$('#tardis').fadeOut(1000);}, 6000);
		}, 28000);
		
		setTimeout(function(){$('#bird').fadeOut(1000);}, 27000); //Vogel ausblenden
		
		setTimeout(function() //Animation (aus Performancegründen) stoppen
		{
			$('#water').spStop();
			$('#waterTwo').spStop();
			$('#clouds').spStop();
			$('#tardis').spStop();
		}, 35000);

		setTimeout(function() //Musik kurz nach Animationsende stoppen
		{
			if($('#cutScenes').css('display') == 'block')
			{
				musicstatus = false;
				var music = document.getElementById('music');
				music.pause();
			}
		}, 38000);
	});
	
	//Aufruf Abspann (Sprite)
	$('#messages').on('click','#startLevelEnd',function()
	{
		musicstatus = true;
		$('#musicMp3').attr('src','music/alexanderMp3.mp3');
		$('#musicOgg').attr('src','music/alexanderOgg.ogg');
		var music = document.getElementById('music');
		music.load();
		music.play();

		$('#sprite').html('');

		$('#chooseDifficulty').hide();
	    $('#showHighscore').hide();
	    $('#intro').hide();
		$('#cutScenes').show();
		$('#endTitles').show();
		$('#home').hide();
		$('#main').hide();
		$('#pausePlay').hide();
		$('#hint').hide();
		$('#mute').hide();
		$('#chooseDifficulty').hide();
		$('#startLevelOne').hide();
		$('#creditsOne').hide();
		$('#creditsTwo').hide();

		$('#submarine').pan({fps: 15, speed: 0.5, dir: 'right'});

		var stationSize = 1;

		//Station langsam verkleinern
		var minimizeStation = setInterval(function()
		{		
			$('#underWaterStation').css({'-webkit-transform': 'scale(' + stationSize + ')', '-moz-transform': 'scale(' + stationSize + ')', '-ms-transform': 'scale(' + stationSize + ')', '-o-transform': 'scale(' + stationSize + ')', 'transform': 'scale(' + stationSize + ')'});

			stationSize -= 0.0007;
		}, 50);

		setTimeout(function()
		{
			$('#underWaterStation').fadeOut(2000);
		}, 48000);

		setTimeout(function()
		{
			$('#submarine').fadeOut(1000);
		}, 50000);

		setTimeout(function() //Animationen aus Performancegründen stoppen
		{
			clearInterval(minimizeStation);
			$('#submarine').spStop();
		}, 51000);

		setTimeout(function()
		{
			$('#creditsOne').fadeIn(2000);
		}, 50000);

		setTimeout(function()
		{
			$('#creditsTwo').fadeIn(2000);
		}, 55000);

		setTimeout(function()
		{
			musicstatus = false;
			var music = document.getElementById('music');
			music.pause();
		}, 60000);
	});
});