//Benedikt Donhauser, Matrikelnummer 1625156
var ziel = 5; //Anzahl der Treffer um zu gewinnen
var canvas1 = document.getElementById('canvas1');
var ctx1 =  canvas1.getContext("2d");
var canvas2 = document.getElementById('canvas2');
var ctx2 =  canvas2.getContext("2d");

var spielstand = function (context, zahl, color) {
	if(zahl >= 0)
	{
		context.clearRect((zahl - 1) * 60 , 0, 30, 140);
		if(color === 0){
			context.fillStyle = "rgba(241, 041, 167, 0.15)";
		}
		else if(color === 1){
		context.fillStyle = "rgba(114, 248, 014, 0.15)";
		}
		else if(color === 2){
			context.fillStyle = "rgb(114, 248, 014)";
		}
		else if(color === 3){
			context.fillStyle = "rgb(241, 041, 167)";
		}
		context.fillRect((zahl - 1) * 60 , 0, 30, 140);
	}
};

var Player = function(id, keyboard, resources, x, y) {
	this.id = id;
	this.resources = resources;
	this.treffer = 0;
	this.keyboard = keyboard;
	this.objects = [];
	var pfeil = new Pfeil(x, y, resources.pfeil, this.id);
	this.pfeil = pfeil;
	this.objects.push(pfeil);
	
	this.keydown = function(ev) {
		if (ev.keyCode === keyboard.down)
			pfeil.direction = Direction.down;
		else if (ev.keyCode === keyboard.up)
			pfeil.direction = Direction.up;
		else if (ev.keyCode === keyboard.left)
			pfeil.direction = Direction.left;
		else if (ev.keyCode === keyboard.right)
			pfeil.direction = Direction.right;
		else if (ev.keyCode === keyboard.shot1)
			pfeil.shooting1 = true;
		else if (ev.keyCode === keyboard.shot2)
			pfeil.shooting2 = true;
		else 
			return;

		ev.preventDefault();
		return false;
	};
	this.keyup = function(ev) {
		if (ev.keyCode === keyboard.down && pfeil.direction == Direction.down)
			pfeil.direction = Direction.none;
		else if (ev.keyCode === keyboard.up && pfeil.direction == Direction.up)
			pfeil.direction = Direction.none;
		else if (ev.keyCode === keyboard.left && pfeil.direction == Direction.left)
			pfeil.direction = Direction.none;
		else if (ev.keyCode === keyboard.right && pfeil.direction == Direction.right)
			pfeil.direction = Direction.none;
		else if (ev.keyCode === keyboard.shot1)
			pfeil.shooting1 = false;
		else if (ev.keyCode === keyboard.shot2)
			pfeil.shooting2 = false;
		else
			return;
		ev.preventDefault();
		return false;
	};
};

Player.prototype.isAlive = function() {
	return this.pfeil.alive;
};

Player.prototype.connect = function() {
	window.addEventListener('keydown', this.keydown);
	window.addEventListener('keyup', this.keyup);
};

Player.prototype.disconnect = function() {
	window.removeEventListener('keydown', this.keydown);
	window.removeEventListener('keyup', this.keyup);
};

var Game = function(width, height, ctx) {
	this.loop = undefined;
	this.players = [];
	this.running = false;
	this.width = width || 0;
	this.height = height || 0;
	this.ctx = ctx;
	this.ds = 5;
};

Game.prototype.addPlayer = function(player) {
	this.players.push(player);
};

Game.prototype.draw = function() {
	this.ctx.clearRect(0, 0, this.ctx.canvas.width, this.ctx.canvas.height); 

	for (var j = this.players.length; j--; ) {
		var objects = this.players[j].objects;

		for (var i = objects.length; i--; )
			objects[i].draw(this.ctx);
	}
};

Game.prototype.step = function() {
	var ds = this.ds;
	for (var i = this.players.length; i--; ) {
		if (!this.players[i].isAlive()) {
			this.players[i].treffer += 1;

			if(i === 0)
				spielstand(ctx2, this.players[i].treffer, 2);
			if(i === 1)
				spielstand(ctx1, this.players[i].treffer, 3);

			this.players[i].pfeil.alive = true; 
		}
		if(this.players[i].treffer === ziel)
		{	
			$('#span').show();
			if(i === 0)
				txt = document.createTextNode(this.players[1].id + " hat gewonnen.");
			if(i === 1)
				txt = document.createTextNode(this.players[0].id + " hat gewonnen.");
			document.getElementById('span').innerHTML = txt.textContent;
			$('#hintergrund').show();
			$('#canvas').hide();
			$('.anzeige').hide();
			this.end();
			return;
		}
	}

	for (var i = this.players.length; i--; ) {
		var objects = this.players[i].objects;
		for (var j = objects.length; j--; ) {
			objects[j].step(this, ds);

			if (!objects[j].alive && (this.players[i].treffer !== ziel))	
				objects.splice(j, 1);
		}
	}
	
	for (var i = this.players.length; i--; ) {
		var objects1 = this.players[i].objects;

		for (var k = objects1.length; k--; ) {
			for (var j = i; j--; ) {
				var objects2 = this.players[j].objects;

				for (var l = objects2.length; l--; ) {
					objects1[k].collides(objects2[l]);
				}
			}
		}
	}
};

Game.prototype.bindHandlers = function() {
	for (var i = this.players.length; i--; ) {
		this.players[i].connect();
	}
};

Game.prototype.unbindHandlers = function() {
	for (var i = this.players.length; i--; ) {
		this.players[i].disconnect();
	}
};

Game.prototype.run = function() {
	var me = this;
	me.bindHandlers();
	me.running = true;
	me.loop = setInterval(function() {
		me.step();
	}, 50);

	var drawGame = function() {
		me.draw(this.ctx);
		if (me.running)
			window.requestAnimationFrame(drawGame);
	};
	drawGame();
};

Game.prototype.pause = function() {
	var me = this;
	me.running = false;
	clearInterval(me.loop);
	me.loop = undefined;
	me.unbindHandlers();
};

Game.prototype.end = function() {
	for (var i = ziel; i > 0; i--) {
		spielstand(ctx1, i, 0);
		spielstand(ctx2, i, 1);
	}
	var me = this;
	me.unbindHandlers();
	me.running = false;
	clearInterval(me.loop);
	me.loop = undefined;	
};

var GameObject = function() {
	this.setPosition();
	this.setDimension();
	this.alive = true;
};

GameObject.prototype.setPosition = function(x, y) {
	this.x = x || 0;
	this.y = y || 0;
};

GameObject.prototype.setDimension = function(width, height) {
	this.width = width || 0;
	this.height = height || 0;
};

GameObject.prototype.setImage = function(im) {
	this.image = im;
};

GameObject.prototype.draw = function(ctx) {
};

GameObject.prototype.step = function(game, ds) {
};

GameObject.prototype.collides = function(w) {
	var v = this;
	var d = v.x - (w.x + w.width);
	var e = w.y - (v.y + v.height);

	if ((e < 0 && e > -(v.height + w.height)) && (d < 0 && d > -(v.width + w.width))) {
		if(v.mortal + w.mortal === 3){//Bei Kollision von Kugel und Balken wird der Balken nicht gelöscht.
			if(v.mortal === 1)
				v.alive = false;
			else
				w.alive = false;
		}
		else{
			v.alive = false;
			w.alive = false;
		}	
	}
};

var Kugel = function(x, y, im, id) {
	this.setPosition(x, y);
	this.setDimension(im.width, im.height);
	this.setImage(im);
	this.id = id;
	this.mortal = 1;
};

Kugel.prototype = new GameObject();
Kugel.prototype.draw = function(ctx) {
	ctx.drawImage(this.image, this.x, this.y);
};

Kugel.prototype.step = function(game, ds) {
	for (var i = game.players.length - 1; i >= 0; i--) {
		if (this.id === game.players[i].id) {
			if(i === 0)
				BorderKugel(this, game.height, 1, ds);
			if(i === 1)
				BorderKugel(this, 0, -1, ds);
		}
	}
};

var Direction = {
	none : 0,
	up : 1,
	right : 2,
	down : 3,
	left : 4
};

var Pfeil = function(x, y, im, id) {
	this.setPosition(x, y);
	this.direction = Direction.none;
	this.shooting1 = false;
	this.shooting2 = false;
	this.numbershot2 = 0;
	this.setDimension(50, 50);
	this.cooldownKugel = 0;
	this.cooldownBalken = 0;
	this.setImage(im);
	this.id = id;
};

Pfeil.prototype = new GameObject();
Pfeil.prototype.draw = function(ctx) {
	ctx.drawImage(this.image, this.x, this.y, this.width, this.height); 
};

Pfeil.prototype.step = function(game, ds) {

	if (this.cooldownKugel)
		this.cooldownKugel--;

	if (this.cooldownBalken)
		this.cooldownBalken--;
	else
	{
		this.numbershot2++;
		this.cooldownBalken = 100;
	}

	for (var i = game.players.length - 1; i >= 0; i--) {
		if (this.id === game.players[i].id) {
			if(i === 0)
				BorderPfeil(this, 0, 0.3 * game.height, game.width - this.width, 0, ds)
			if(i === 1)
				BorderPfeil(this, 0.5 * game.height, game.height - this.height, game.width - this.width, 0, ds)
		}
	}

	if (this.shooting1 && this.cooldownKugel === 0) {
		for (var i = game.players.length - 1; i >= 0; i--) {
			if (this.id === game.players[i].id) {
				if(i === 0)
					Shot1(game, this, this.x + this.width * 0.5 - 6, this.y + this.height, i);
				if(i === 1)
					Shot1(game, this, this.x + this.width * 0.5 - 7, this.y - 15, i);
			}
		}
	}

	if (this.shooting2 && this.numbershot2 > 0 && this.cooldownKugel === 0) {
		for (var i = game.players.length - 1; i >= 0; i--) {
			if (this.id === game.players[i].id) {
				if(i === 0)
					Shot2(game, this, this.x - 50, this.y + this.height, i);
				if(i === 1)
					Shot2(game, this, this.x - 50, this.y - 15, i);
			}
		}	
	}
};

var BorderKugel = function(inst, bedingung, vorzeichen, ds) {
	inst.y = inst.y + vorzeichen * ds;
	if (vorzeichen * inst.y > bedingung)
		inst.alive = false;
};

var BorderPfeil = function(inst, up, down, right, left, ds) {
	switch (inst.direction) {
		case Direction.up:
			if (inst.y >= up)
				inst.y -= ds;
			break;
		case Direction.down:
			if (inst.y <= down)
				inst.y += ds;
			break;
		case Direction.right:
			if (inst.x <= right)
				inst.x += ds;
			break;
		case Direction.left:
			if (inst.x >= left)
				inst.x -= ds;
			break;
	}
};

var Shot1 = function (game, inst, dx, dy, k) {
	var kugel = new Kugel(dx, dy, game.players[k].resources.kugel, game.players[k].id);
	game.players[k].objects.push(kugel);
	inst.cooldownKugel = 10;
};

var Shot2 = function (game, inst, dx, dy, k) {
	var kugel = new Kugel(dx, dy, game.players[k].resources.balken, game.players[k].id);
	kugel.mortal = 2;
	game.players[k].objects.push(kugel);
	inst.numbershot2--;
	inst.cooldownKugel = 10;
};

var Keyboard = function(up, right, down, left, shot1, shot2) {
	this.up = up;
	this.right = right;
	this.down = down;
	this.left = left;
	this.shot1 = shot1;
	this.shot2 = shot2;
};

$(document).ready(function() {

	var steuerung = false;
	var images1 = [
		{ name: 'kugel', src: 'bilder/kugel-rot.png' },
		{ name: 'pfeil', src: 'bilder/schiff1.gif' },
		{ name: 'balken', src: 'bilder/balken-pink.gif' },
	];
	var images2 = [
		{ name: 'kugel', src: 'bilder/kugel-blau.png' },
		{ name: 'pfeil', src: 'bilder/schiff2.gif' },
		{ name: 'balken', src: 'bilder/balken-grün.gif' },
	];
	var total = images1.length + images2.length;
	var canvas = document.getElementById('canvas');
	var ctx = canvas.getContext("2d");
	var resources = [];
	var res1 = {};
	var res2 = {};
	resources.push(res1);
	resources.push(res2);
	var game = undefined;


	var grenze = 0;
	var interval = Math.round(100 / total);
	var progressbar = $("#progressbar");
	var	progressLabel = $(".progress-label");

	progressbar.progressbar({
		value: 0,
		max: 100,
		change: function() {
			progressLabel.text(progressbar.progressbar( "value" ) + "%");
		},
		complete: function() {
			progressLabel.text("Geladen! Zum Starten Klicken!");
			loaded();
		}
	});

	function progress() {
		var val = progressbar.progressbar("value") || 0;
		progressbar.progressbar('value', val + 1);

		if (val < grenze && val < 100) {
			var time = setTimeout(progress, 100);
		}
		else{
			clearTimeout(time);
			return;
		}
	};

	function setGrenze () {
		grenze += interval - 1;
	};

	$('#canvas').hide();
	$('#eingabe').hide();
	$('.anzeige').hide();
	$('#steuerung').hide();

	var loadImage = function(image, i) {
		var img = document.createElement('img');
		img.src = image.src;
		img.addEventListener('load', function() {
			total--;
			setGrenze();
			progress();
			resources[i][image.name] = img;
		});	
	};

	for (var i = images1.length - 1; i >= 0; i--)
		loadImage(images1[i], 0);
	for (var i = images2.length - 1; i >= 0; i--)
		loadImage(images2[i], 1)

	var loaded = function() {				
		document.getElementById("hintergrund").addEventListener('click', function(){
			$('#progressbar').hide();
			$('#eingabe').show();
			document.getElementById("button").addEventListener('click', function(){					
				$('#hintergrund').hide();
				$('#canvas').show();
				$('.anzeige').show();
				game = startGame();
			});
		});
	};

	var startGame = function() {

		var topKeyboard = new Keyboard(87, 68, 83, 65, 32, 86);
		var bottomKeyboard = new Keyboard(38, 39, 40, 37, 188, 190);

		var topName = $('#spieler1').val() || "Spieler1";
		var bottomName = $('#spieler2').val() || "Spieler2";

		var topPlayer = new Player(topName, topKeyboard, resources[0], 10, 10);
		var bottomPlayer = new Player(bottomName, bottomKeyboard, resources[1], 470, 340);

		var game = new Game(canvas.width, canvas.height, ctx);
		game.addPlayer(topPlayer);
		game.addPlayer(bottomPlayer);

		for (var i = ziel; i > 0; i--) {
			spielstand(ctx1, i, 0);
			spielstand(ctx2, i, 1);
		}

		game.run();
		return game;
	};

	window.addEventListener('keydown', function(ev) {
		//F1 Neustarten
		//Internet Explorer
		if ("onhelp" in window)
			window.onhelp = function () {   
			return false;
    	}
		if (ev.keyCode === 112 && game) {
			game.end();
			game = undefined;
			game = startGame();
			ev.preventDefault();
			return false;
		}
		//F2 Steuerung zeigen
		if (ev.keyCode === 113 && game){
			steuerung = true;
			$('#canvas').hide();
			$('.anzeige').hide();
			$('#steuerung').show();;
			game.pause();
			ev.preventDefault();
		}	
		return false;
	});

	window.addEventListener('keyup', function(ev) {
		//F2 Steuerung ausblenden
		if (ev.keyCode === 113 && steuerung){
			steuerung = false;
			$('#steuerung').hide();
			$('#canvas').show();
			$('.anzeige').show();
			game.run();
			ev.preventDefault();
		}
		return false;
	});
});