
function Bullet(x, y, rot){
	console.log("Rot ist: " + rot);
	this.canCollide=true;
	this.setDimension(bulletsize, bulletsize);
	this.setPosition(x, y);
	this.vec = new vec(rot);
	this.lifetime= bulletLifetime;		//Multiple of 50 milliseconds, 20 corresponds to 1 second; see logic loop for this timing

	this.move=function(){
		this.setPosition( 1*this.x +this.vec.dx*bulletspeed*1, 1*this.y + this.vec.dy*bulletspeed*1);
		//console.log("Koordinaten move nachher:" + this.x + " "  +this.y);		// Wert 0 0
	};
	this.draw=function(mycan){
		mycan.fillStyle=bulletcolor;
		mycan.beginPath();
		//console.log("ZeichnungsKoordinaten vorher:" + this.x + " "  +this.y);
		mycan.arc(this.x,this.y, bulletsize, 0, 2* Math.PI, false)	//Positon x ,y radius (in px), startAngle, endAngle, direction
		//console.log("ZeichnungsKoordinaten nachher:" + this.x + " "  +this.y);

		mycan.fill();
		mycan.closePath();
	};
	this.decreaseLifetime=function(){
		this.lifetime-=1
	}
};

Bullet.prototype = new GameObject();
Bullet.prototype.constructor= Bullet;

Bullet.prototype.warp = function(arg){
	if (arg == "left")
		this.setPosition(0,this.y);
	if (arg == "right")
		this.setPosition(800-this.width-1,this.y);
	if (arg == "top")
		this.setPosition(this.x,50);
	if (arg == "bottom")
		this.setPosition(this.x,600-this.height-1);
}

Bullet.prototype.collides = function(other){

	if (other.constructor.name="Fence"){
		var thisCenterPoint = new position(this.x +this.width/2, this.y + this.height/2),
		relRot,
		halfDiag = Math.sqrt(this.width*1*this.width*1 + this.height*1*this.height)/2,
		thisVertex = [];

		
		relRot = this.vec.rot;


		// Principle: Take the center of the rectangular object, consider the rotation and then, using sine and cosine, 
		// determine the coordinates of the vertices
		// Rotation is as follows: the "this"-object is always non-rotated, and the "this"-object is rotated depending on 
		// the relative rotation

		// !!! IMPORTANT!!! Both objects have to be tested if one of their corners lies in the this object!!!! 
		//	(Because you don't know which one is the bigger object, the corners of one object never touch the this one...)
		thisVertex.push(new position(thisCenterPoint.x+Math.cos(relRot-Math.PI/4)*halfDiag,
				 					thisCenterPoint.y - Math.sin(relRot-Math.PI/4) *halfDiag ));
		thisVertex.push( new position(thisCenterPoint.x+Math.cos(relRot-Math.PI/4+Math.PI/2)*halfDiag,
				 					thisCenterPoint.y - Math.sin(relRot-Math.PI/4+Math.PI/2) *halfDiag ));
		thisVertex.push ( new position(thisCenterPoint.x+Math.cos(relRot-Math.PI/4+Math.PI)*halfDiag,
				 					thisCenterPoint.y - Math.sin(relRot-Math.PI/4+Math.PI) *halfDiag ));
		thisVertex.push( new position(thisCenterPoint.x+Math.cos(relRot-Math.PI/4+Math.PI*3/2)*halfDiag,
				 					thisCenterPoint.y - Math.sin(relRot-Math.PI/4+Math.PI*3/2) *halfDiag ));

		for (var i=0; i<=3; i++)
		{
				//Test, if Vertices of "this"-object lie in "other"-object
			if ( thisVertex[i].x <=other.x+ other.width && thisVertex[i].x >=other.x
				&& thisVertex[i].y <=other.y+other.height && thisVertex[i].y >=other.y)
			{
				return true;
			}
		}
		return false;

		
	}

	//console.log("bulletcollide!");
		
	// Methode aus http://www.gamedev.net/page/resources/_/technical/game-programming/2d-rotated-rectangle-collision-r2604
	// relRot ist die relative Rotation (other ist zu this um relRot gedreht), mit Wertebereich zwischen 0 und 2*Pi 
	var relRot;
			relRot = Math.max(other.vec.rot, this.vec.rot)- Math.min(other.vec.rot, this.vec.rot);//  + 2*Math.PI;
			
	

	var otherCenterPoint = new position(other.x +other.width/2, other.y + other.height/2),
		halfDiag = Math.sqrt(other.width*1*other.width*1 + other.height*1*other.height)/2,
		otherVertex = [];
		// Principle: Take the center of the rectangular object, consider the rotation and then, using sine and cosine, 
		// determine the coordinates of the vertices
		// Rotation is as follows: the "this"-object is always non-rotated, and the "other"-object is rotated depending on 
		// the relative rotation

		// !!! IMPORTANT!!! Both objects have to be tested if one of their corners lies in the other object!!!! 
		//	(Because you don't know which one is the bigger object, the corners of one object never touch the other one...)
		otherVertex.push(new position(otherCenterPoint.x+Math.cos(relRot-Math.PI/4)*halfDiag,
				 					otherCenterPoint.y - Math.sin(relRot-Math.PI/4) *halfDiag ));
		otherVertex.push( new position(otherCenterPoint.x+Math.cos(relRot-Math.PI/4+Math.PI/2)*halfDiag,
				 					otherCenterPoint.y - Math.sin(relRot-Math.PI/4+Math.PI/2) *halfDiag ));
		otherVertex.push ( new position(otherCenterPoint.x+Math.cos(relRot-Math.PI/4+Math.PI)*halfDiag,
				 					otherCenterPoint.y - Math.sin(relRot-Math.PI/4+Math.PI) *halfDiag ));
		otherVertex.push( new position(otherCenterPoint.x+Math.cos(relRot-Math.PI/4+Math.PI*3/2)*halfDiag,
				 					otherCenterPoint.y - Math.sin(relRot-Math.PI/4+Math.PI*3/2) *halfDiag ));

	var thisVertex = [];

		thisVertex.push(new position(this.x,			this.y));
		thisVertex.push(new position(this.x+this.width,	this.y));
		thisVertex.push(new position(this.x,			this.y+this.height));
		thisVertex.push(new position(this.x+this.width,	this.y+this.height));

		
	var otherXMax, otherYMax, otherXMin, otherYMin;
		otherXMax= otherVertex[0];
		otherYMax= otherVertex[0];
		otherXMin= otherVertex[0];
		otherYMin= otherVertex[0];
		for (var i=0; i<=3; i++)
		{
			if (otherVertex[i].x> otherXMax.x)
				otherXMax= otherVertex[i];
			if (otherVertex[i].y> otherYMax.y)
				otherYMax= otherVertex[i];
			if (otherVertex[i].x < otherXMin.x)
				otherXMin= otherVertex[i];
			if (otherVertex[i].y < otherYMin.y)
				otherYMin= otherVertex[i];
		}

	for (var i=0; i<=3; i++)
	{
		//Test, if Vertices of "other"-object lie in "this"-object
		if ( otherVertex[i].x <=this.x+this.width && otherVertex[i].x >=this.x  
			&& otherVertex[i].y <=this.y+this.height && otherVertex[i].y >= this.y )
			return true;
		//Test, if Vertices of "this"-object lie in "other"-object
		if ( thisVertex[i].x <=otherXMax.x && thisVertex[i].x >=otherXMin.x
			&& thisVertex[i].y <=otherYMax.y && thisVertex[i].y >=otherYMin.y)
			return true;

	}
	return false;
};