﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Xml.Serialization;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using System.Collections;
using System.Windows.Threading;

namespace Chat
{
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    /// 
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            Application.Current.Exit +=Current_Exit;
        }

        ChatServer mainServer;

        private void Current_Exit(object sender, ExitEventArgs e)
        {
            if (mainServer != null)
            {
                mainServer.StopListening();
            }
            
        }

        public static Config configObj { get; set; }

        private delegate void UpdateStatusCallback(string strMessage);

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {

            try
            {
                XmlSerializer serializer = new XmlSerializer(typeof(Config));
                configObj = new Config();

                if (File.Exists("config.xml"))
                {
                    this.ResizeMode = System.Windows.ResizeMode.CanResize;

                    FileStream fs = new FileStream("config.xml", FileMode.Open);
                    configObj = (Config)serializer.Deserialize(fs);
                    fs.Close();

                    // Parse the server's IP address out of the TextBox
                    IPAddress ipAddr = IPAddress.Parse(configObj.IPAdress);
                    // Create a new instance of the ChatServer object
                    mainServer = new ChatServer(ipAddr, configObj.Port);
                    // Hook the StatusChanged event handler to mainServer_StatusChanged
                    ChatServer.StatusChanged += new StatusChangedEventHandler(mainServer_StatusChanged);
                    // Start listening for connections
                    mainServer.StartListening();
                    // Show that we started to listen for connections
                    SetText("Monitoring for connections...\r\n");
                }
                else
                {
                    SetupWelcomePage welcomePage = new SetupWelcomePage(this);
                    welcomePage.Height = this.Height;
                    welcomePage.Width = this.Width;
                    this.Content = welcomePage;
                }
            }
            catch (Exception ex)
            {
                if (ex is ArgumentNullException || ex is FormatException)
                {
                    MessageBox.Show(ex.Message + "\n\rTry to delete config.xml file und restart the application", "Error", MessageBoxButton.OK, MessageBoxImage.Error);
                }
                else MessageBox.Show(ex.Message, "Error", MessageBoxButton.OK, MessageBoxImage.Error);
            } 
        }

        public void mainServer_StatusChanged(object sender, StatusChangedEventArgs e)
        {
            // Call the method that updates the form
            this.Dispatcher.Invoke(new UpdateStatusCallback(this.SetText), new object[] { e.EventMessage });
        }

       
        private void SetText(string message)
        {
            String output = DateTime.Now.ToString("yyyy-MM-dd_HH:mm:ss");
            if (!this.StatusTextBox.Dispatcher.CheckAccess())
            {
                this.StatusTextBox.Dispatcher.Invoke(new Action(delegate
                    { StatusTextBox.AppendText(output + ": " + message); }
                    ));
            }
            else this.StatusTextBox.AppendText(output + ": " + message);

        }
    }
}
