﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Xml.Serialization;
using System.IO;

namespace Chat
{
    /// <summary>
    /// Interaktionslogik für SetupConfigPage.xaml
    /// </summary>
    public partial class SetupConfigPage : Page
    {
        public SetupConfigPage(Window main)
        {
            InitializeComponent();
            this.Main = main;
        }

        Window Main { get; set; }
        private void AbortButton_Click(object sender, RoutedEventArgs e)
        {
            this.Main.Close();
        }

        private void ContinueButton_Click(object sender, RoutedEventArgs e)
        {
            XmlSerializer serialize = new XmlSerializer(typeof(Config));
            Config configObj = new Config();
            Boolean canSerealize = true;

            if (IsIP(this.AdressTextBox.Text))
            {
                configObj.IPAdress = this.AdressTextBox.Text;

            }
            else 
            { 
                canSerealize = false;
                MessageBox.Show("Ihre eingegebene IP-Adresse ist leider nicht gültig.", "Error", MessageBoxButton.OK, MessageBoxImage.Error);
            }

            Int32 Port;
            if (Int32.TryParse(this.PortTextBox.Text, out Port))
            {
                configObj.Port = Port;
            }
            else
            {
                canSerealize = false;
                MessageBox.Show("Ihr eingegebener Port ist leider nicht gültig.", "Error", MessageBoxButton.OK, MessageBoxImage.Error);
            }

            configObj.User = this.UserTextBox.Text;
            configObj.Password = this.PasswordTextBox.Password;

            if (canSerealize)
            {
                FileStream fs = new FileStream("config.xml", FileMode.Create);
                serialize.Serialize(fs, configObj);
                SetupFinalPage finalePage = new SetupFinalPage(this.Main);
                this.Main.Content = finalePage;
                fs.Close();
            }  
        }

        private bool IsIP(string IP)
        {
            return System.Text.RegularExpressions.Regex.IsMatch(IP, @"\b((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$\b");
        }
    }
}
