﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Sockets;
using System.Net;
using System.Threading;
using System.IO;


namespace Chat
{
    // This class handels connections; there will be as many instances of it as there will be connected users
    class Connection
    {
        TcpClient tcpClient;
        // The thread that will send information to the client
        private Thread thrSender;
        private StreamReader srReceiver;
        private StreamWriter swSender;
        private string LoginString;
        private string strResponse;

        // The constructor of the class takes in a TCP connection
        public Connection(TcpClient tcpCon)
        {
            tcpClient = tcpCon;
            // The thread that accepts the client and awaits messages
            thrSender = new Thread(AcceptClient);
            // The thread calls the AcceptClient() method
            thrSender.Start();
        }

        private void CloseConnection()
        {
            // Close the currently open objects
            tcpClient.Close();
            srReceiver.Close();
            swSender.Close();
        }

        // Occures when a new client is accepted
        private void AcceptClient()
        {
            srReceiver = new System.IO.StreamReader(tcpClient.GetStream());
            swSender = new System.IO.StreamWriter(tcpClient.GetStream());

            // Read the account information from the client
            LoginString = srReceiver.ReadLine();
            var loginArray = ParseLoginData(LoginString);

            // We got a response from the client
            if (loginArray[2] != "")
            {
                // Store the user name in the hash table
                if (ChatServer.htUsers.Contains(loginArray[2]) == true)
                {
                    // 0 means not connected
                    swSender.WriteLine("0|This username already exists.");
                    swSender.Flush();
                    CloseConnection();
                    return;
                }
                else if (loginArray[2] == "Administrator")
                {
                    // 0 means not connected
                    swSender.WriteLine("0|This username is reserved.");
                    swSender.Flush();
                    CloseConnection();
                    return;
                }
                else if (MainWindow.configObj.User != loginArray[0] || MainWindow.configObj.Password != loginArray[1])
                {
                    // 0 means not connected
                    swSender.WriteLine("0|Username or Password incorrect.");
                    swSender.Flush();
                    CloseConnection();
                    return;
                }
                else
                {
                    // 1 means connected successfully
                    swSender.WriteLine("1");
                    swSender.Flush();

                    // Add the user to the hash tables and start listening for messages from him
                    ChatServer.AddUser(tcpClient, loginArray[2]);
                }
            }
            else
            {
                CloseConnection();
                return;
            }

            try
            {
                // Keep waiting for a message from the user
                while ((strResponse = srReceiver.ReadLine()) != "")
                {
                    // If it's invalid, remove the user
                    if (strResponse == null)
                    {
                        ChatServer.RemoveUser(tcpClient);
                        break;
                    }
                    else
                    {
                        // Otherwise send the message to all the other users
                        ChatServer.SendMessage(loginArray[2], strResponse);
                    }
                }
            }
            catch
            {
                // If anything went wrong with this user, disconnect him
                ChatServer.RemoveUser(tcpClient);
            }
        }

        private String[] ParseLoginData(String loginString)
        {
            String[] returnString = new String[3];

            Int32 index1 = loginString.IndexOf(";", 0);
            Int32 index2 = loginString.IndexOf(";", index1 + 1);
            returnString[0] = loginString.Substring(0, index1);                     //User
            returnString[1] = loginString.Substring(index1 + 1, index2 - index1 - 1);  //Password

            index1 = loginString.IndexOf("#", index2 + 1);
            returnString[2] = loginString.Substring(index2 + 1, index1 - index2 - 1);  //Alias

            return returnString;
        }
    }
}
