﻿using System;

namespace Projekt
{
    static class NumberExtensions
    {
        const Double CoarseTolerance = 1e-2;
        const Double FineTolerance = 1e-7;

        public static Boolean SignificantlyNotZero(this Double value)
        {
            return Math.Abs(value) > CoarseTolerance;
        }

        public static Boolean SignificantlySmallerZero(this Double value)
        {
            return value < -CoarseTolerance;
        }

        public static Boolean SignificantlyGreaterZero(this Double value)
        {
            return value > CoarseTolerance;
        }

        public static Boolean NotZero(this Double value)
        {
            return Math.Abs(value) > FineTolerance;
        }

        public static Boolean SmallerZero(this Double value)
        {
            return value < -FineTolerance;
        }

        public static Boolean GreaterZero(this Double value)
        {
            return value > FineTolerance;
        }

    }
}
