﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public struct Power
    {
        Double power;

        #region constructors
        public Power(Double value)
        {
            this.power = value;
        }

        public Power(Power value)
        {
            this.power = value.power;
        }
        #endregion

        #region conversions
        public static Power FromHP(Double value)
        {
            return new Power(value * 735.49875);
        }

        public static Power FromWatt(Double value)
        {
            return new Power(value);
        }

        public static Power FromKiloWatt(Double value)
        {
            return new Power(value * 0.001);
        }

        public Double HP
        {
            get { return power * 0.001359621617; }
        }

        public Double Watt
        {
            get { return power; }
        }

        public Double KiloWatt
        {
            get { return power * 0.001; }
        }
        #endregion

        #region operators
        public static implicit operator Power(Double value)
        {
            return new Power(value);
        }

        public static explicit operator Double(Power value)
        {
            return value.power;
        }
        public static Power operator +(Power firstValue, Power secondValue)
        {
            return new Power(firstValue.power + secondValue.power);
        }

        public static Power operator -(Power firstValue, Power secondValue)
        {
            return new Power(firstValue.power - secondValue.power);
        }

        public static Power operator /(Power firstValue, Power secondValue)
        {
            return new Power(firstValue.power / secondValue.power);
        }

        public static Power operator /(Power value, Double div)
        {
            return new Power(value.power / div);
        }

        public static Power operator *(Power value, Double mult)
        {
            return new Power(value.power * mult);
        }

        public static Power operator *(Power firstValue, Power secondValue)
        {
            return new Power(firstValue.power * secondValue.power);
        }

        public static Power operator -(Power value)
        {
            return new Power(-value.power);
        }

        public static Power Max(Power firstValue, Power secondValue)
        {
            return new Power(Math.Max(firstValue.power, secondValue.power));
        }

        public static Power Min(Power firstValue, Power secondValue)
        {
            return new Power(Math.Min(firstValue.power, secondValue.power));
        }
        #endregion
    }
}
