﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;

namespace Projekt
{
    [StructLayout(LayoutKind.Explicit, Pack = 1)]
    public struct FrictionKey
    {
        [FieldOffset(0)]
        Int32 hashcode;
        [FieldOffset(0)]
        GroundCondition weather;
        [FieldOffset(1)]
        GroundType groundType;
        [FieldOffset(2)]
        WheelType wheelType;

        /// <summary>
        /// Instanciates a friction key containing information about the weather, ground and wheel
        /// </summary>
        /// <param name="weather">weather situation</param>
        /// <param name="groundType">type of the ground</param>
        /// <param name="wheelType">type of the wheel</param>
        public FrictionKey(GroundCondition weather, GroundType groundType, WheelType wheelType)
        {
            this.hashcode = 0;
            this.weather = weather;
            this.groundType = groundType;
            this.wheelType = wheelType;
        }

        public override int GetHashCode()
        {
            return hashcode;
        }

        public override bool Equals(object obj)
        {
            if (obj is FrictionKey)
                return ((FrictionKey)obj).hashcode == hashcode;

            return false;
        }
    }
}
