﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public sealed class FrictionTableClass
    {
        static volatile FrictionTableClass instance;
        static Object myLock = new Object();

        readonly Dictionary<FrictionKey, FrictionValue> frictionTable;

        public static FrictionTableClass Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (myLock)
                    {
                        if (instance == null)
                        {
                            instance = new FrictionTableClass();
                        }
                    }
                }
                return instance;
            }
        }

        public FrictionValue this[FrictionKey key]
        {
            get { return frictionTable[key]; }
        }

        public FrictionValue this[GroundCondition weather, GroundType groundType, WheelType wheelType]
        {
            get { return frictionTable[new FrictionKey(weather, groundType, wheelType)]; }
        }

        private FrictionTableClass()
        {
            frictionTable = new Dictionary<FrictionKey,FrictionValue>();

            #region coeffCollection
            //collection of realistic friction coefficients
            //Surface	Adhesion Coefficient 
            //    - μt -
            //    Wet Ice	0.1
            //    Dry Ice	0.2
            //    Loose Sand	0.3 - 0.4
            //    Dry Clay	0.5 - 0.6
            //    Wet rolled Gravel	0.3 - 0.5
            //    Dry rolled Gravel	0.6 - 0.7
            //    Wet Asphalt	0.4 - 0.7
            //    Wet Concrete	0.4 - 0.7
            //    Dry Asphalt	0.4 - 0.7
            //    Dry Concrete	0.4 - 0.7


            //                Rolling Resistance Coefficient	 
            //    c	cl (mm)
            //    0.001 - 0.002	0.5	
            //    railroad steel wheels on steel rails

            //    0.001		bicycle tire on wooden track
            //    0.002 - 0.005		low resistance tubeless tires
            //    0.002		bicycle tire on concrete
            //    0.004		bicycle tire on asphalt road
            //    0.005		dirty tram rails
            //    0.006 - 0.01		truck tire on asphalt
            //    0.008		bicycle tire on rough paved road
            //    0.01 - 0.015		ordinary car tires on concrete
            //    0.03		car tires on tar or asphalt
            //    0.04 - 0.08		car tire on solid sand
            //    0.2 - 0.4		car tire on loose sand


            //                cR	Wälzkörper/Wälzkörperbahn
            //    0,0005–0,001	Kugellager, Kugel und Lager aus gehärtetem Stahl4
            //    0,001–0,002	Eisenbahnrad auf Schiene1
            //    0,015-0,02	Motorradreifen auf Asphalt
            //    0,006–0,010	Autoreifen auf Asphalt, Lkw
            //    0,011–0,015	Autoreifen auf Asphalt, Pkw
            //    0,01–0,02	Autoreifen auf Beton2
            //    0,020	Autoreifen auf Schotter
            //    0,015–0,03	Autoreifen auf Kopfsteinpflaster2
            //    0,03–0,06	Autoreifen auf Schlaglochstrecke2
            //    0,045	Verbinderkette (Raupenfahrwerk, Leopard 2) auf fester Fahrbahn
            //    0,050	Autoreifen auf Erdweg
            //    0,04–0,08	Autoreifen auf festgefahrenem Sand2
            //    0,035–0,08	Gurtband (Raupenfahrwerk, Caterpillar Challenger und John Deere 8000T) auf Asphalt
            //0,2–0,4	Autoreifen auf losem Sand2/3
            #endregion

            #region Table

            #region Dry
            //Dry
                //Asphalt
            AddToTable(GroundCondition.Dry, GroundType.Asphalt, WheelType.Profile, 0.6, 0.012);
            AddToTable(GroundCondition.Dry, GroundType.Asphalt, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Asphalt, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Asphalt, WheelType.Steel, 0.9, 0.1);

                //Sand
            AddToTable(GroundCondition.Dry, GroundType.Sand, WheelType.Profile, 0.4, 0.2);
            AddToTable(GroundCondition.Dry, GroundType.Sand, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Sand, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Sand, WheelType.Steel, 0.9, 0.1);

                //Grass
            AddToTable(GroundCondition.Dry, GroundType.Grass, WheelType.Profile, 0.25, 0.04);
            AddToTable(GroundCondition.Dry, GroundType.Grass, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Grass, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Grass, WheelType.Steel, 0.9, 0.1);

                //Gravel
            AddToTable(GroundCondition.Dry, GroundType.Gravel, WheelType.Profile, 0.6, 0.02);
            AddToTable(GroundCondition.Dry, GroundType.Gravel, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Gravel, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Gravel, WheelType.Steel, 0.9, 0.1);

                //Mud
            AddToTable(GroundCondition.Dry, GroundType.Mud, WheelType.Profile, 0.5, 0.05);
            AddToTable(GroundCondition.Dry, GroundType.Mud, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Mud, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Mud, WheelType.Steel, 0.9, 0.1);

                //Concrete
            AddToTable(GroundCondition.Dry, GroundType.Concrete, WheelType.Profile, 0.7, 0.017);
            AddToTable(GroundCondition.Dry, GroundType.Concrete, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Concrete, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Dry, GroundType.Concrete, WheelType.Steel, 0.9, 0.1);
            #endregion
            #region Sunny
            //Sunny
                //Asphalt
            AddToTable(GroundCondition.Sunny, GroundType.Asphalt, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Asphalt, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Asphalt, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Asphalt, WheelType.Steel, 0.9, 0.1);
                                                      
                //Sand                                
            AddToTable(GroundCondition.Sunny, GroundType.Sand, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Sand, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Sand, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Sand, WheelType.Steel, 0.9, 0.1);
                                                     
                //Grass                              
            AddToTable(GroundCondition.Sunny, GroundType.Grass, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Grass, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Grass, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Grass, WheelType.Steel, 0.9, 0.1);

                //Gravel                            
            AddToTable(GroundCondition.Sunny, GroundType.Gravel, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Gravel, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Gravel, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Gravel, WheelType.Steel, 0.9, 0.1);

                //Mud
            AddToTable(GroundCondition.Sunny, GroundType.Mud, WheelType.Profile, 0.5, 0.05);
            AddToTable(GroundCondition.Sunny, GroundType.Mud, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Mud, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Mud, WheelType.Steel, 0.9, 0.1);

                //Concrete
            AddToTable(GroundCondition.Sunny, GroundType.Concrete, WheelType.Profile, 0.7, 0.017);
            AddToTable(GroundCondition.Sunny, GroundType.Concrete, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Concrete, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Sunny, GroundType.Concrete, WheelType.Steel, 0.9, 0.1);
            #endregion
            #region Humid
            //Humid
                //Asphalt
            AddToTable(GroundCondition.Humid, GroundType.Asphalt, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Asphalt, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Asphalt, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Asphalt, WheelType.Steel, 0.9, 0.1);
                                                      
                //Sand                                
            AddToTable(GroundCondition.Humid, GroundType.Sand, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Sand, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Sand, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Sand, WheelType.Steel, 0.9, 0.1);
                                                     
                //Grass                              
            AddToTable(GroundCondition.Humid, GroundType.Grass, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Grass, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Grass, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Grass, WheelType.Steel, 0.9, 0.1);
                                                     
                //Paving                             
            AddToTable(GroundCondition.Humid, GroundType.Gravel, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Gravel, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Gravel, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Gravel, WheelType.Steel, 0.9, 0.1);

                //Mud
            AddToTable(GroundCondition.Humid, GroundType.Mud, WheelType.Profile, 0.5, 0.05);
            AddToTable(GroundCondition.Humid, GroundType.Mud, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Mud, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Mud, WheelType.Steel, 0.9, 0.1);

                //Concrete
            AddToTable(GroundCondition.Humid, GroundType.Concrete, WheelType.Profile, 0.7, 0.017);
            AddToTable(GroundCondition.Humid, GroundType.Concrete, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Concrete, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Humid, GroundType.Concrete, WheelType.Steel, 0.9, 0.1);
            #endregion
            #region Rain
            //Rain
                //Asphalt
            AddToTable(GroundCondition.Rain, GroundType.Asphalt, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Asphalt, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Asphalt, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Asphalt, WheelType.Steel, 0.9, 0.1);
                                                     
                //Sand                               
            AddToTable(GroundCondition.Rain, GroundType.Sand, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Sand, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Sand, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Sand, WheelType.Steel, 0.9, 0.1);
                                                     
                //Grass                              
            AddToTable(GroundCondition.Rain, GroundType.Grass, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Grass, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Grass, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Grass, WheelType.Steel, 0.9, 0.1);
                                                    
                //Gravel                          
            AddToTable(GroundCondition.Rain, GroundType.Gravel, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Gravel, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Gravel, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Gravel, WheelType.Steel, 0.9, 0.1);

                //Mud
            AddToTable(GroundCondition.Rain, GroundType.Mud, WheelType.Profile, 0.5, 0.05);
            AddToTable(GroundCondition.Rain, GroundType.Mud, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Mud, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Mud, WheelType.Steel, 0.9, 0.1);

                //Concrete
            AddToTable(GroundCondition.Rain, GroundType.Concrete, WheelType.Profile, 0.7, 0.017);
            AddToTable(GroundCondition.Rain, GroundType.Concrete, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Concrete, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Rain, GroundType.Concrete, WheelType.Steel, 0.9, 0.1);
            #endregion
            #region Snow
            //Snow
                //Asphalt
            AddToTable(GroundCondition.Snow, GroundType.Asphalt, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Asphalt, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Asphalt, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Asphalt, WheelType.Steel, 0.9, 0.1);
                                                     
                //Sand                               
            AddToTable(GroundCondition.Snow, GroundType.Sand, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Sand, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Sand, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Sand, WheelType.Steel, 0.9, 0.1);
                                                     
                //Grass                              
            AddToTable(GroundCondition.Snow, GroundType.Grass, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Grass, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Grass, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Grass, WheelType.Steel, 0.9, 0.1);
                                                    
                //Gravel                            
            AddToTable(GroundCondition.Snow, GroundType.Gravel, WheelType.Profile, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Gravel, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Gravel, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Gravel, WheelType.Steel, 0.9, 0.1);

                //Mud
            AddToTable(GroundCondition.Snow, GroundType.Mud, WheelType.Profile, 0.5, 0.05);
            AddToTable(GroundCondition.Snow, GroundType.Mud, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Mud, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Mud, WheelType.Steel, 0.9, 0.1);

                //Concrete
            AddToTable(GroundCondition.Snow, GroundType.Concrete, WheelType.Profile, 0.7, 0.017);
            AddToTable(GroundCondition.Snow, GroundType.Concrete, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Concrete, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Snow, GroundType.Concrete, WheelType.Steel, 0.9, 0.1);
            #endregion
            #region Icy
            //Icy
                //Asphalt
            AddToTable(GroundCondition.Icy, GroundType.Asphalt, WheelType.Profile, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Asphalt, WheelType.Slicks, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Asphalt, WheelType.Spikes, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Asphalt, WheelType.Steel, 0.4, 0.1);
                                                     
                //Sand                               
            AddToTable(GroundCondition.Icy, GroundType.Sand, WheelType.Profile, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Sand, WheelType.Slicks, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Sand, WheelType.Spikes, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Sand, WheelType.Steel, 0.4, 0.1);
                                                    
                //Grass                             
            AddToTable(GroundCondition.Icy, GroundType.Grass, WheelType.Profile, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Grass, WheelType.Slicks, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Grass, WheelType.Spikes, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Grass, WheelType.Steel, 0.4, 0.1);
                                                    
                //Gravel                            
            AddToTable(GroundCondition.Icy, GroundType.Gravel, WheelType.Profile, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Gravel, WheelType.Slicks, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Gravel, WheelType.Spikes, 0.4, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Gravel, WheelType.Steel, 0.4, 0.1);

                //Mud
            AddToTable(GroundCondition.Icy, GroundType.Mud, WheelType.Profile, 0.5, 0.05);
            AddToTable(GroundCondition.Icy, GroundType.Mud, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Mud, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Mud, WheelType.Steel, 0.9, 0.1);

                //Concrete
            AddToTable(GroundCondition.Icy, GroundType.Concrete, WheelType.Profile, 0.7, 0.017);
            AddToTable(GroundCondition.Icy, GroundType.Concrete, WheelType.Slicks, 0.9, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Concrete, WheelType.Spikes, 0.9, 0.1);
            AddToTable(GroundCondition.Icy, GroundType.Concrete, WheelType.Steel, 0.9, 0.1);
            #endregion

            #endregion
        }

        /// <summary>
        /// Adds a frictionkey/frictionvalue pair to the frictiontable
        /// </summary>
        /// <param name="weather">weather condition</param>
        /// <param name="ground">type of the ground</param>
        /// <param name="wheel">type of the wheel</param>
        /// <param name="frictionCoeff">sliding friction coefficient</param>
        /// <param name="rollCoeff">rolling friction coefficient</param>
        void AddToTable(GroundCondition weather, GroundType ground, WheelType wheel, Double frictionCoeff, Double rollCoeff)
        {
            frictionTable[new FrictionKey(weather, ground, wheel)] = new FrictionValue(frictionCoeff, rollCoeff);
        }

        /// <summary>
        /// Adds a frictionkey/frictionvalue pair to the frictiontable
        /// </summary>
        /// <param name="key">a friction key consisting of weather, ground and wheeltype</param>
        /// <param name="value">a friction value consisting of sliding- and rolling- friction coefficient</param>
        void AddToTable(FrictionKey key, FrictionValue value)
        {
            frictionTable[key] = value;
        }
    }
}
