﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public struct Placement
    {
        Coord coordinates;
        Angle alignment;

        #region Constructors
        public Placement(Coord coordinates, Angle alignment)
        {
            this.coordinates = coordinates;
            this.alignment = alignment;
        }

        public Placement(Double x, Double y, Angle angle)
        {
            this.coordinates = new Coord(x, y);
            this.alignment = angle;
        }

        public Placement(Coord coordinates, Double angle)
        {
            this.coordinates = coordinates;
            this.alignment = new Angle(angle);
        }

        public Placement(Double x, Double y, Double angle)
        {
            this.coordinates = new Coord(x, y);
            this.alignment = new Angle(angle);
        }

        public Placement(Placement placement)
        {
            this.coordinates = placement.coordinates;
            this.alignment = placement.alignment;
        }
        #endregion

        public Coord Coordinates
        {
            get { return coordinates; }
        }

        public Double X
        {
            get { return coordinates.X; }
        }

        public Double Y
        {
            get { return coordinates.Y; }
        }

        public Angle Alignment
        {
            get { return alignment; }
        }
    }
}
