﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public struct Vector
    {
        //UNUSED!!!! may be deleted in the end
        Double length;
        Angle angle;

        public Vector(Double length, Angle angle)
        {
            this.length = length;
            this.angle = angle;
        }

        public Vector(Double xCoord, Double yCoord)
        {
            this.length = Math.Sqrt(xCoord * xCoord + yCoord * yCoord);
            this.angle = (Angle)Math.Atan(yCoord / xCoord);
        }

        //public Vector(Coord coords)
        //{
        //    this.length = Math.Sqrt(coords.X * coords.X + coords.Y * coords.Y);
        //    this.angle = (Angle)Math.Atan(coords.Y / coords.X);
        //}

        public Vector(Vector vector)
        {
            this.length = vector.length;
            this.angle = vector.angle;
        }

        public Double cos()
        {
            return angle.cos(length);
        }

        public Double sin()
        {
            return angle.sin(length);
        }

        public Double Length
        { get { return length; } }

        public Angle Angle
        { get { return angle; } }

        public static Vector operator +(Vector firstVector, Vector secondVector)
        {
            var resultX = firstVector.cos() + secondVector.cos();
            var resultY = firstVector.sin() + secondVector.sin();
            var length = Math.Sqrt(resultX * resultX + resultY * resultY);
            Angle angle = (Angle)Math.Atan(resultY / resultX);
            return new Vector(length, angle);
        }

        public static Vector operator -(Vector firstVector, Vector secondVector)
        {
            var resultX = firstVector.cos() - secondVector.cos();
            var resultY = firstVector.sin() - secondVector.sin();
            var length = Math.Sqrt(resultX * resultX + resultY * resultY);
            Angle angle = (Angle)Math.Atan(resultY / resultX);
            return new Vector(length, angle);
        }

        public static explicit operator Double(Vector value)
        {
            return value.Length;
        }

        public static explicit operator Vector(Double value)
        {
            return new Vector(value, (Angle)0.0);
        }

    }
}
