﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public interface ITire
    {
        #region Fixed Properties
        /// <summary>
        /// Overall context containing environmental parameters
        /// </summary>
        IContext Context
        {
            get;
        }

        /// <summary>
        /// Radius of the wheel
        /// </summary>
        Double Radius
        {
            get;
        }

        /// <summary>
        /// Type of the wheel (material, surface)
        /// </summary>
        WheelType Type
        { 
            get;
        }
        #endregion

        #region Changing Properties
        /// <summary>
        /// Type of ground currently in contact with the wheel
        /// </summary>
        IGround Ground
        {
            get;
            set;
        }

        /// <summary>
        /// Current position of the wheel
        /// </summary>
        Coord Position
        {
            get;
            set;
        }
        #endregion

        /// <summary>
        /// Calculates force applied by the tire to the ground
        /// </summary>
        /// <param name="normalForce">Normal force on the tire</param>
        /// <param name="velocity">Velocity of the vehicle to which the tire belongs</param>
        /// <returns>Force that the tire applies to the ground</returns>
        Double GetForce(Double normalForce, Double velocity);
    }
}
