﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public class SteeringWheel : ISteeringWheel
    {
        #region Constructors
        public SteeringWheel(IContext context, Double radius, WheelType type, Angle maxAngle)
        {
            this.context = context;
            this.Radius = radius;
            this.Type = type;
            this.MaxAngle = maxAngle;
        }
        #endregion

        #region Fixed Properties
        IContext context;
        public IContext Context
        { get { return context; } }

        Double radius;
        public double Radius
        {
            get { return radius; }
            private set
            {
                if (value > 0.0)
                {
                    radius = value;
                }
                else
                {
                    radius = 1.0;
                }
            }
        }

        public WheelType Type
        {
            get;
            private set;
        }

       Angle maxAngle;
       public Angle MaxAngle
        {
            get { return maxAngle; }
            private set
            {
                maxAngle = Math.Max(0.0, (Double)value);
            }
        }
        #endregion

        #region Changing Properties
        Angle currentAngle;
        public Angle CurrentAngle
        {
            get { return currentAngle; }
            set
            {
                if ((Double)value < Math.PI)
                {
                    currentAngle = new Angle(Math.Min((Double)maxAngle, (Double) value));
                }
                else
                {
                    currentAngle = new Angle(Math.Max(2.0 * Math.PI - (Double)maxAngle, (Double) value));
                }
            }
        }

        public Coord Position
        {
            get;
            set;
        }

        public IGround Ground
        {
            get;
            set;
        }

        public Double Torque
        {
            get;
            set;
        }
        #endregion

        #region Methods
        public Double GetForce(Double normalForce, Double velocity)
        {
            var ground = Ground as Ground;
            var friction = FrictionTableClass.Instance[ground.CurrentWeather, ground.CurrentGround, Type];
            
            if (Torque.SignificantlyNotZero() && velocity.SignificantlyNotZero())
            {
                return (-1.0) * normalForce * friction.FrictionCoeff * Math.Sign(velocity);
            }
            else if (velocity.SignificantlyNotZero())
            {
                return (-1.0) * normalForce * (friction.RollingFrictionCoeff * (1.0 - Math.Abs(CurrentAngle.sin())) + friction.FrictionCoeff * Math.Abs(CurrentAngle.sin())) * Math.Sign(velocity);
            }
            else
            {
                return 0.0;
            }
        }
        #endregion
    }
}
