﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public abstract class Vehicle
    {
        #region Fixed Properties
        Int32 wheelNumber;
        /// <summary>
        /// The number of wheels of the vehicle
        /// </summary>
        protected Int32 WheelNumber
        {
            get { return wheelNumber; }
            set
            {
                if (value > 0)
                {
                    wheelNumber = value;
                }
                else
                {
                    wheelNumber = 4;
                }
            }
        }

        Double mass;
        /// <summary>
        /// The mass of the vehicle
        /// </summary>
        protected Double Mass
        {
            get { return mass; }
            set
            {
                if (value > 0.0 )
                {
                    mass = value;
                }
                else
                {
                    mass = 1000.0;
                }
            }
        }

        Double centerOfMassHorizontal;
        /// <summary>
        /// The horizontal distance of the center of mass to the rear axle of the vehicle
        /// </summary>
        protected Double CenterOfMassHorizontal
        {
            get { return centerOfMassHorizontal; }
            set
            {
                if (value > 0.0)
                {
                    centerOfMassHorizontal = value;
                }
                else if (Length > 0.0)
                {
                    centerOfMassHorizontal = Length / 2.0;
                }
                else
                {
                    length = 5.0;
                    centerOfMassHorizontal = 2.5;
                }
            }
        }
        
        Double width;
        /// <summary>
        /// The width of the vehicle
        /// </summary>
        public Double Width
        {
            get { return width; }
            protected set
            {
                width = Math.Max(1.0, value);
            }
        }

        Double length;
        /// <summary>
        /// The length of the vehicle
        /// </summary>
        public Double Length
        {
            get { return length; }
            protected set
            {
                length = Math.Max(1.0, value);
            }
        }
        #endregion

        #region Changing Properties
        /// <summary>
        /// The current position of the car.
        /// </summary>
        public Placement Position
        {
            get;
            protected set;
        }

        /// <summary>
        /// Maximal Power of the vehicle's engine
        /// </summary>
        public Power MaxPower
        {
            get;
            protected set;
        }

        /// <summary>
        /// Current power of the vehicle's engine
        /// </summary>
        public Power CurrentPower
        {
            get;
            set;
        }

        Double dragCoefficient;
        /// <summary>
        /// The drag coefficient including the area and the factor 0.5
        /// </summary>
        public Double DragCoefficient
        {
            get { return dragCoefficient; }
            protected set
            {
                dragCoefficient = Math.Max(0.0, value);
            }
        }

        /// <summary>
        /// The current velocity of the vehicle
        /// </summary>
        public Double Velocity
        {
            get;
            protected set;
        }

        /// <summary>
        /// The current acceleration of the vehicle
        /// </summary>
        public Double Acceleration
        {
            get;
            protected set;
        }
        #endregion

        #region Methods
        /// <summary>
        /// Calculate the new position of the vehicle from the torque, the forces on the wheels and the actual position
        /// </summary>
        public abstract void Update();

        public abstract void Control(IVehicleControl control);

        /// <summary>
        /// Set the position of the wheels according to the current position of the vehicle
        /// </summary>
        protected abstract void SetWheels();

        /// <summary>
        /// Applies Torque to the wheels
        /// </summary>
        public abstract void ApplyTorque();

        /// <summary>
        /// Applies the current steering angle to the two front wheels, make them turn left or right
        /// </summary>
        /// <param name="angle">Current steering angle for the wheels</param>
        public abstract void ApplyAngle(Angle angle);
        #endregion
    
    }
}
