﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public class Context : IContext
    {
        #region constructors
        /// <summary>
        /// Constructor of a context which contains environmental parameters
        /// </summary>
        /// <param name="interval">Time of the update interval in miliseconds</param>
        /// <param name="airDensity">Density of the air in kg/m^3 (typical value: 1.2)</param>
        /// <param name="gravitationAcceleration">Gravitational Acceleration in m/s^2 (typical value: 9.81)</param>
        public Context(Int32 interval, Double airDensity, Double gravitationAcceleration)
        {
            this.interval = interval;
            this.airDensity = airDensity;
            this.gravitationAcceleration = gravitationAcceleration;
        }

        /// <summary>
        /// Constructor of a context which contains environmental parameters
        /// </summary>
        /// <param name="interval">Time of the update interval in miliseconds</param>
        public Context(Int32 interval)
        {
            this.interval = interval;
            this.airDensity = 1.2;
            this.gravitationAcceleration = 9.81;
        }

        /// <summary>
        /// Constructor of a context which contains environmental parameters
        /// </summary>
        public Context()
        {
            this.interval = 20;
            this.airDensity = 1.2;
            this.gravitationAcceleration = 9.81;
        }
        #endregion

        Int32 interval;
        public Int32 Interval_ms
        {
            get { return interval; }
        }

        public Double Interval_s
        {
            get { return (Double)interval * 0.001; }
        }

        Double airDensity;
        public Double AirDensity
        {
            get { return airDensity; }
        }

        Double gravitationAcceleration;
        public Double GravitationAcceleration
        {
            get { return gravitationAcceleration; }
        }
    }
}
