﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;

namespace LevelEditor.ViewModel
{
    class TileItemViewModel : ViewModelBase
    {
        private GroundTypes _GroundType;
        private RelayCommand _SelectTile;

        public TileItemViewModel(MainWindowViewModel parent, GroundTypes groundTypes)
        {
            this._GroundType = groundTypes;
            this._SelectTile = new RelayCommand(_ => parent.SelectedTile = this);
        }

        public GroundTypes GroundType
        {
            get { return _GroundType; }
            set { _GroundType = value; RaisePropertyChanged(); RaisePropertyChanged("Color"); }
        }

        public String Name { get { return _GroundType.ToString(); } }

        public Brush Color
        {
            get { return _GroundType.ToBrush(); }
        }

        public ICommand SelectTile
        {
            get { return _SelectTile; }
        }

    }
}
