﻿using System.Collections.Generic;
using System.Windows.Media;
namespace LevelEditor
{
    public static class GroundExtensions
    {
        static readonly Dictionary<GroundTypes, Brush> groundTypesToBrushes = new Dictionary<GroundTypes, Brush>()
        {
            {GroundTypes.Grass, Brushes.Green},
            {GroundTypes.Mud, Brushes.Chocolate},
            {GroundTypes.Sand, Brushes.SandyBrown},
            {GroundTypes.Gravel, Brushes.LightGray},
            {GroundTypes.Tamarc, Brushes.Gray}
        };

        public static Brush ToBrush(this GroundTypes ground)
        {
            return groundTypesToBrushes[ground];
        }

    }
}
