﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace LevelEditor
{
    [Serializable]
    public class GroundTileGrid
    {
        public GroundTypes[,] Grid { get; set; }

        public Int32 Width { get; set; }

        public Int32 Height { get; set; }

        public Int32 Area { get { return Width * Height; } }

        #region ctor

        public GroundTileGrid(GroundTypes[,] grid)
        {
            Grid = grid;
            Width = Grid.GetLength(0);
            Height = Grid.GetLength(1);
        }

        public GroundTileGrid()
            : this(new GroundTypes[0, 0])
        {

        }
        #endregion
    }
}
