﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Threading.Tasks;

namespace LevelEditor
{
    [Serializable]
    public class Track
    {

        public String Name { get; set; }

        public GroundTileGrid GroundTiles { get; set; }

        #region ctor

        public Track(String name, GroundTileGrid tiles)
        {
            Name = name;
            GroundTiles = tiles;
        }

        public Track()
            : this("Unnamed Track", new GroundTileGrid())
        {

        }

        #endregion

        #region saving and loading

        public async Task SaveAsync(Stream stream)
        {
            var buffer = new List<byte>();
            buffer.AddRange(BitConverter.GetBytes(Encoding.UTF8.GetByteCount(Name)));
            buffer.AddRange(Encoding.UTF8.GetBytes(Name));
            buffer.AddRange(BitConverter.GetBytes(GroundTiles.Width));
            buffer.AddRange(BitConverter.GetBytes(GroundTiles.Height));

            for (Int32 i = 0; i < GroundTiles.Width; i++)
            {
                for (Int32 j = 0; j < GroundTiles.Height; j++)
                {
                    buffer.Add((byte)GroundTiles.Grid[i, j]);
                }
            }

            var bufferArray = buffer.ToArray();
            await stream.WriteAsync(bufferArray, 0, bufferArray.Length);
        }

        public static async Task<Track> LoadAsync(Stream stream)
        {
            var buffer = new byte[stream.Length];
            await stream.ReadAsync(buffer, 0, (Int32)stream.Length);


            var output = new Track();
            var index = 0;
            var nameLength = BitConverter.ToInt32(buffer, index);
            index += 4;

            output.Name = Encoding.UTF8.GetString(buffer, index, nameLength);
            index += nameLength;

            var tilesWidth = BitConverter.ToInt32(buffer, index);
            index += 4;

            var tilesHeight = BitConverter.ToInt32(buffer, index);
            index += 4;

            var tiles = new GroundTypes[tilesWidth, tilesHeight];

            for (Int32 i = 0; i < tilesWidth; i++)
            {
                for (Int32 j = 0; j < tilesHeight; j++)
                {
                    tiles[i, j] = (GroundTypes)buffer[index++];
                }
            }

            output.GroundTiles = new GroundTileGrid(tiles);

            return output;
        }

        #endregion

    }
}
