﻿using LevelEditor.ViewModel;
using Microsoft.Win32;
using System;
using System.Text;
using System.Linq;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Shapes;
using System.Windows.Documents;
using System.Collections.Generic;

namespace LevelEditor
{
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        Point p;
        
        public MainWindow()
        {
            InitializeComponent();
            DataContext = new MainWindowViewModel(MyCanvas);
        }

        #region canvas interaction

        private void Canvas_MouseDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            var currentCanvas = sender as Canvas;
            var dc = DataContext as MainWindowViewModel;

            p = e.GetPosition(currentCanvas);
            VisualTreeHelper.HitTest(currentCanvas, null, dc.MyCallBack, new PointHitTestParameters(p));
            dc.SetToModified();
        }

        private void Canvas_MouseMove(object sender, System.Windows.Input.MouseEventArgs e)
        {
            var currentCanvas = sender as Canvas;
            var dc = DataContext as MainWindowViewModel;

            if (e.LeftButton == System.Windows.Input.MouseButtonState.Pressed && currentCanvas != null)
            {

                var newp = e.GetPosition(currentCanvas);

                var line = new LineGeometry(p, newp);
                VisualTreeHelper.HitTest(currentCanvas, null, dc.MyCallBack, new GeometryHitTestParameters(line));
                p = newp;
            }
        }


        private void Canvas_MouseUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            //will be added later
        }

        #endregion
        
    }
}
