﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;

namespace LevelEditor.ViewModel
{
    class PropertyPickerWindowViewModel : ViewModelBase
    {
        private String _SelectedName = "Unnamed";

        public String SelectedName
        {
            get { return _SelectedName; }
            set { _SelectedName = value; RaisePropertyChanged(); }
        }

        public Int32 MaximumTrackWidth
        {
            get { return 100; }
        }
        public Int32 MaximumTrackHeight
        {
            get { return 100; }
        }
        public Int32 MinimumTrackWidth
        {
            get { return 10; }
        }
        public Int32 MinimumTrackHeight
        {
            get { return 10; }
        }

        private Int32 _TrackWidth;
        public Int32 TrackWidth
        {
            get { return _TrackWidth; }
            set { _TrackWidth = value; RaisePropertyChanged(); }
        }

        private Int32 _TrackHeight;
        public Int32 TrackHeight
        {
            get { return _TrackHeight; }
            set { _TrackHeight = value; RaisePropertyChanged(); }
        }

        private GroundTypes _BaseTile;
        public GroundTypes BaseTile
        {
            get { return _BaseTile; }
            set { _BaseTile = value; RaisePropertyChanged(); RaisePropertyChanged("BaseTileColor"); }
        }

        public Brush BaseTileColor { get { return BaseTile.ToBrush(); } }

        public Array AvailableTiles { get { return Enum.GetValues(typeof(GroundTypes)); } }

        public PropertyPickerWindowViewModel()
        {
            TrackWidth = 10;
            TrackHeight = 10;
        }


    }
}
