﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using DbManager;
using MovieToolForms.GUI.Content;
using Datenbank;

namespace MovieToolForms.GUI.Content
{
    public partial class MovieOverview : UCListener
    {
        public MovieOverview()
        {
            InitializeComponent();

            configGrid();
            fillGrid();
        }

        private void configGrid()
        {
            dgvMovies.AutoGenerateColumns = false;
            dgvMovies.Columns.Add("Name", "Name");
            dgvMovies.Columns.Add("Language", "Language");
            dgvMovies.Columns.Add("Quality", "Quality");
            dgvMovies.Columns.Add("Duration", "Duration");
            dgvMovies.Columns.Add("Type", "Type");

            dgvMovies.Columns["Name"].DataPropertyName = "Name";
            dgvMovies.Columns["Language"].DataPropertyName = "Language";
            dgvMovies.Columns["Quality"].DataPropertyName = "Quality";
            dgvMovies.Columns["Duration"].DataPropertyName = "Duration";
            dgvMovies.Columns["Type"].DataPropertyName = "Type";


        }

        private void fillGrid()
        {
            DBMovieLogic dbl = new DBMovieLogic();
            List<Movie> movieList = dbl.getAllMovies();

            dgvMovies.DataSource = movieList;



        }

        public override void refreshControl()
        {
           
        }
    }
}
