﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using DbManager;
using System.Diagnostics;
using MovieToolForms.GUI.Content;
using Datenbank;

namespace MovieToolForms.GUI.Content
{
    public partial class Search :  UCListener
    {
        List<Movie> movieList = new List<Movie>();
        //List<string> stringList = new List<string>();

        public Search()
        {
            InitializeComponent();
            fillMovieList();

        }

        private void fillMovieList()
        {
            movieList.Clear();
           // stringList.Clear();
            DBMovieLogic dbl = new DBMovieLogic();
            movieList = dbl.getAllMovies();
         //   stringList = movieList.ConvertAll(obj => obj.ToString());
            filterForText("");
            setFilmCount(movieList.Count);

            
        }

        private void setFilmCount(int p)
        {
                txtFilmCount.Text = "Anzahl: " + p + "";
        }

        private void txtSearchFilm_TextChanged(object sender, EventArgs e)
        {

            TextBox snd = sender as TextBox;

            if (snd.Text.Length < 1)
            {
                setFilmCount(movieList.Count);
                return;
            }

            filterForText(tfSearchFilm.Text.ToLower());
            if (tfListResults.Items.Count == 0)
            {
                setFilmCount(movieList.Count);
                if (tfSearchFilm.Text != "")
                    setFilmCount(0);
            }
            else
            {
                setFilmCount(tfListResults.Items.Count);
            }
        }

        private void filterForText(String text)
        {
  
            tfListResults.Items.Clear();
            if (text == "")
                return;
            
            var tempList = movieList.Where(s => s.Name.ToLower().Contains(text) || s.Path.ToLower().Contains(text)).ToList();
            

            foreach (var item in tempList)
            {
                tfListResults.Items.Add(new ListViewItem(new string[]{item.Name, item.Path}));
            }
            tfListResults.View = View.Details;
            tfListResults.Columns.Clear();
            tfListResults.Columns.Add("Name");
            tfListResults.Columns.Add("Pfad");
            tfListResults.Columns[0].Width = (tfListResults.Width/2) - 2;
            tfListResults.Columns[1].Width = (tfListResults.Width / 2) - 2;
        }

        public override void refreshControl()
        {
           base.refreshControl();
            fillMovieList(); 
        }

    }
}
