﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using DbManager;
using MovieToolForms.GUI.Components;
using MovieToolForms.Model;
using MovieToolWpf.MediaInfo;
using Datenbank;

namespace MovieToolForms.Logic
{
    class HDScanner
    {
        private MediaInfoParser parser;
        private List<HardDisk> hds;
        private DBMovieLogic dbl;

        public HDScanner()
        {
            parser = new MediaInfoParser();
            dbl = new DBMovieLogic();
        }


        public void ScannSelectedHDs(List<HardDisk> hds) {

            this.hds = hds;

            foreach (HardDisk disk in hds) {

                var task1 = new Task<string>(n => ScanHD(disk), null);

                if (disk.IsActive)
                {
                    task1.Start();
                    task1.ContinueWith(a => { disk.scanDone(); });
                }
            }
        }

        private void countDirectories(HardDisk disk) {

            int directoryCount = 0;                    
            string[] subdirectoryEntries = Directory.GetDirectories(disk.Root);
            directoryCount += subdirectoryEntries.Length;
            foreach (string directory in subdirectoryEntries) {
                try
                {
                    directoryCount += Directory.GetDirectories(directory).Length;
                }
                catch (UnauthorizedAccessException ex) {
                    Debug.WriteLine(ex.Message);
                }
                }
            disk.DirectoryCount = directoryCount;      
        }

        private string ScanHD(HardDisk disk)
        {
            //  path = @"D:\down";

            if (File.Exists(disk.Root))
            {
                // This path is a file
                ProcessFile(disk.Root);
            }
            else if (Directory.Exists(disk.Root))
            {
                countDirectories(disk);
                // This path is a directory
                ProcessDirectory(disk.Root, 0, disk);
            }
            else
            {
                Debug.WriteLine("{0} is not a valid file or directory.", disk.Root);
            }
            return null;
        }

        private void UpdateScanStatus(HardDisk disk) {
            disk.updateScanProgress();
        }

        int dirCount = 0;

        // Process all files in the directory passed in, recurse on any directories  
        // that are found, and process the files they contain. 
        public void ProcessDirectory(string targetDirectory, int depth, HardDisk disk)
        {


            if (depth < 3)
            {
                UpdateScanStatus(disk);
                dirCount++;
            }
            
            try
            {
                // Process the list of files found in the directory. 
                string[] fileEntries = Directory.GetFiles(targetDirectory);
                foreach (string fileName in fileEntries)
                    ProcessFile(fileName);

                // Recurse into subdirectories of this directory. 
                string[] subdirectoryEntries = Directory.GetDirectories(targetDirectory);
                foreach (string subdirectory in subdirectoryEntries)
                    ProcessDirectory(subdirectory, depth+1, disk);

            }
            catch (UnauthorizedAccessException e)
            {
                
                Debug.WriteLine(e.Message);
            }
            catch(Exception ex){
                Debug.Write(ex.Message+"sonstige Exception");
            }
        }

        // Insert logic for processing found files here. 
        public void ProcessFile(string path)
        {
            try{
            ValidMovieType mvType = ValidMovieType.invalid;
            foreach (ValidMovieType type in Enum.GetValues(typeof(ValidMovieType)))
            {
                if (path.EndsWith(type.ToString().ToLower()) || path.EndsWith(type.ToString().ToUpper()))
                    mvType = type;
            }

            if (mvType != ValidMovieType.invalid)
            {
                Movie movie = new Movie();
                movie.Type = mvType.ToString();
                movie.Path = path;

                MovieInfo info = parser.getMovieInfo(path);

                movie.Name = info.Name;
                movie.Quality = info.Resolution.ToString();
                movie.Type = info.Extension.ToString();
                movie.Language = info.Streams;
                movie.Duration = info.Duration;

                FileInfo fInfo = new FileInfo(path);

                long size = fInfo.Length;

                if (size < 50000000)
                {
                    Debug.WriteLine(movie.Name + " is no movie");
                    return;
                }
                dbl.SaveMovie(movie);
            }
            }catch(Exception ex){
                Debug.WriteLine(path+" File Exception.. Exc: "+ex);
            
            }
            
            }
        }


}
