﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using MediaInfoLib;
using MovieToolForms;
using MovieToolForms.Model;


namespace MovieToolWpf.MediaInfo
{
    enum MediaInfoEnum { 
        extension, duration, resolution, size, name
    }

    class MovieInfo {

        private ValidMovieType extension;
        private string duration;
        private MvQuality resolution;
        private string size;
        private string name;
        private string streams;

        public string Streams
        {
            get { return streams; }
            set { streams = value; }
        }

        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        public string Size
        {
            get { return size; }
            set { size = value; }
        }

        public MvQuality Resolution
        {
            get { return resolution; }
            set { resolution = value; }
        }

        public string Duration
        {
            get { return duration; }
            set { duration = value; }
        }


        public ValidMovieType Extension
        {
            get { return extension; }
            set { extension = value; }
        }
    }

    class MediaInfoParser
    {

        public MovieInfo getMovieInfo(string path)
        {

            MediaInfoLib.MediaInfo info = new MediaInfoLib.MediaInfo();
            MovieInfo movieInfo = new MovieInfo();

            Debug.WriteLine(path);

            info.Open(path);
            movieInfo.Extension = getExtension(info.Get(StreamKind.General, 0, "FileExtension", InfoKind.Text, InfoKind.Name));
            movieInfo.Duration = info.Get(StreamKind.General, 0, "Duration/String", InfoKind.Text, InfoKind.Name);
            movieInfo.Resolution = getResolution(info.Get(StreamKind.Video, 0, "Width", InfoKind.Text, InfoKind.Name));
            movieInfo.Size = info.Get(StreamKind.General, 0, "FileSize/String", InfoKind.Text, InfoKind.Name);
            movieInfo.Name = getFileName(info.Get(StreamKind.General, 0, "CompleteName", InfoKind.Text, InfoKind.Name));

            movieInfo.Streams = getStreams(info);

            info.Close();

            return movieInfo;
        }

        public string getFileName(string s) {

            string temp = s.Substring(s.LastIndexOf('\\')+1);

            int ending = temp.LastIndexOf(".");
            try
            {
                temp = temp.Substring(0, ending);
            }
            catch (Exception ex) {
                Debug.WriteLine(ex.Message);
            }

            return temp;
        }

        public void addInfo(MediaInfoEnum key, String definition, StreamKind streamkind, MediaInfoLib.MediaInfo info, Dictionary<MediaInfoEnum, string> movieInfo)
        {
            movieInfo.Add(key, info.Get(streamkind, 0, definition, InfoKind.Text, InfoKind.Name));
        }

        public String getStreams(MediaInfoLib.MediaInfo info)
        {

            String streamcount = info.Get(StreamKind.Audio, 0, "StreamCount", InfoKind.Text, InfoKind.Name);
            String[] languages;
            
            if (streamcount == "")
            {
                return "NA";
            }

            String languageString = "";
            languages = new String[Int32.Parse(streamcount) + 1];

            string temp;
            for (int i = 0; i < languages.Length; i++)
            {
                temp = info.Get(StreamKind.Audio, i, "Language/String1", InfoKind.Text, InfoKind.Name);

                if (temp == "")
                    continue;
                
                languageString += temp;
                if(i < languages.Length-2)
                languageString += ";";
            }


            return languageString;
        }

        public MvQuality getResolution(String width)
        {

            if (width =="")
                return MvQuality.NA;


            MvQuality resolution = MvQuality.NA;
            int widthInt = Int32.Parse(width);

            if (widthInt > 1400)
                resolution = MvQuality.hd1080;

            if (widthInt < 1400 && widthInt > 1100)
                resolution = MvQuality.hd720;

            if (widthInt <= 1100 && widthInt > 500)
                resolution = MvQuality.dvd;

            if (widthInt <= 500)
                resolution = MvQuality.divx;

            return resolution;
        }


        public ValidMovieType getExtension(String str) {

            if (ValidMovieType.avi.ToString() == str)
                return ValidMovieType.avi;

            if (ValidMovieType.m2ts.ToString() == str)
                return ValidMovieType.m2ts;

            if (ValidMovieType.mkv.ToString() == str)
                return ValidMovieType.mkv;

            if (ValidMovieType.VOB.ToString() == str)
                return ValidMovieType.VOB;

            return ValidMovieType.invalid;

        
        }

    }
}
