﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MovieToolForms.GUI.Content;


namespace MovieToolForms.GUI
{
    public partial class NavArea : UCListener
    {
        private Menu menu;
        private MainForm parent;


        public NavArea(MainForm parent)
        {
            InitializeComponent();
            menu = new Menu();
            this.parent = parent;

            initMenuEntries();
            paintMenuEntries();
        }

        #region menuentries



        public void paintMenuEntries()
        {
            this.Controls.Clear();

            List<MenuPart> menuParts = menu.getMenuParts();
            int positionCounter = 0;

            foreach(MenuPart part in menuParts){          
            //--------- add heading
                this.Controls.Add(part.Heading);
                part.Heading.Location = new Point(0, positionCounter);
                positionCounter += part.Heading.Height;

            //----------- add entries
                foreach (NavEntry entry in part.Entries) {
                    if (part.IsActive)
                    {
                        this.Controls.Add(entry);
                        entry.Location = new Point(0, positionCounter);
                        positionCounter += entry.Height;
                    }
                    if (entry.IsActive)
                        entry.ContentText.ForeColor = Color.Crimson;
                    else 
                        entry.ContentText.ForeColor = Color.RoyalBlue;
                    entry.Refresh();
                }
            }
            
        }

        private void initMenuEntries()
        {

            NavEntry initEntry = new NavEntry("Scanner", new Scanner(), this);

            NavHeading headingHD = new NavHeading("Festplatten", this, global::MovieTool.Properties.Resources.pladde);
            List<NavEntry> entriesHD = new List<NavEntry>()
            {
                initEntry
            };

            NavHeading headingDB = new NavHeading("Datenbank", this, global::MovieTool.Properties.Resources.db);
            List<NavEntry> entriesDB = new List<NavEntry>() { 
                new NavEntry("Filmübersicht", new MovieOverview(), this),
                new NavEntry("Suche", new Search(), this),
            };

            menu.addMenuPart(headingHD, entriesHD);
            menu.addMenuPart(headingDB, entriesDB);

            receiveEntryClick(initEntry);
        }

        #endregion


        #region eventReceiver

        public void receiveHeadingClick(NavHeading heading)
        {
            toggleMenuHeading(heading);
            paintMenuEntries();
        }

        public void receiveEntryClick(NavEntry entry) {
            parent.setContent(entry);

            foreach (MenuPart part in menu.getMenuParts()) {
                foreach (NavEntry navEntry in part.Entries) {
                    navEntry.IsActive = false;
                   }
            }
            // activate active entry
            entry.IsActive = true;
            paintMenuEntries();
        }

        #endregion

        #region helper

        private void toggleMenuHeading(NavHeading heading)
        {
            if (heading.ParentMenuPart.IsActive)
            {
                heading.ParentMenuPart.IsActive = false;
                heading.ToggleBox.Image = global::MovieTool.Properties.Resources.menuClosed;
            }
            else
            {
                heading.ParentMenuPart.IsActive = true;
                heading.ToggleBox.Image = global::MovieTool.Properties.Resources.menuOpen;
            }
        }

        #endregion




        public override void refreshControl()
        {
            
        }
    }


    public class Menu {
        private List<MenuPart> menuParts = new List<MenuPart>();
        
        public void addMenuPart(NavHeading heading, List<NavEntry> entries) {
            MenuPart part = new MenuPart(heading, entries);
            if(!menuParts.Contains(part))
            menuParts.Add(part);
        }

        public List<MenuPart> getMenuParts() {
            return menuParts;
        }
    }

    public class MenuPart {
        private NavHeading heading;
        private List<NavEntry> entries = new List<NavEntry>();
        private bool isActive = true;

        public MenuPart(NavHeading heading, List<NavEntry> entries) {
            this.heading = heading;
            heading.ParentMenuPart = this;
            this.entries = entries;
        }

        public bool IsActive
        {
            get { return isActive; }
            set { isActive = value; }
        }
        public List<NavEntry> Entries
        {
            get { return entries; }
            set { entries = value; }
        }
        public NavHeading Heading
        {
            get { return heading; }
            set { heading = value; }
        }
    }


}
