﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace MyCSharpProject
{
    public partial class MyFieldControl : UserControl
    {

        List<MyPlayerControl> playerControls;
        List<PictureBox> mypictures;
        public List<Player> Players { get; private set; }
        List<MyCategory> categories;
        Random r = new Random();
        bool LastRound = false;
        
        internal MyGame CurrentGame { get; set; }

        public MyFieldControl()
        {
            InitializeComponent();
            BackColor = System.Drawing.Color.FromArgb(0, 0, 0, 0);

            playerControls = new List<MyPlayerControl>();
            mypictures = new List<PictureBox>() { pictureBox1, pictureBox2, pictureBox3, pictureBox4};
            Players = new List<Player>();

            Players.Add(new Player(myPlayerControl1));
            Players.Add(new Player(myPlayerControl2));
            Players.Add(new Player(myPlayerControl3));
            Players.Add(new Player(myPlayerControl4));
            
            
            questionControl1.QuestionAnswered += AnswerGiven;

            myPositionControl1.GameEnds += myGameEndsNow;

            for (int i = 0; i < 4; i++)
                Players[i].mycomboxes[3].SelectedIndexChanged += mySelectedIndexCounter;

            
        }


        private int HowManyHaveAlreadySelected = 0;

        /// <summary>
        /// ENABLES THE START BUTTON WHEN THE INDEX OF LAST COMBOBOX OF THE LAST PLAYER IS SET 
        /// </summary>
        /// <param name="s"></param>
        /// <param name="e"></param>
        public void mySelectedIndexCounter(object s, EventArgs e)
        {
            HowManyHaveAlreadySelected++;
            if (HowManyHaveAlreadySelected % CurrentGame.NoOfPlayers == 0)
            {
                Start.Enabled = true;
                SetRules("Click the Start-Button");
            }
        }

        /// <summary>
        /// IF A CORRECT ANSWER IS GIVEN, THE PLAYER MOVES
        /// ALSO IT GOES TO THE NEXT PLAYER GIVES THE NEXT QUESTION IF IT ISN'T THE LAST ROUND
        /// </summary>
        /// <param name="s"></param>
        /// <param name="e">CHECKS IF THE CORRECT ANSWER IS GIVEN</param>
        public void AnswerGiven(object s, MyQuestionEventArgs e)
        {
            if (e.rightAnswerClicked == true)
            {
                                               
                myPositionControl1.PlayerMove(CurrentGame.CurrentlyOperatingPlayer, CurrentGame.CurrentCategoryNumber);
                
            }
            else
            {
                ;
            }

            CurrentGame.NextPlayer();
            if (!LastRound)
            {
            questionControl1.receiveQuestion(CurrentGame.getCurrentQuestion(), CurrentGame.PlayerNames[CurrentGame.CurrentlyOperatingPlayer], CurrentGame.CurrentlyOperatingPlayer);
            }
            
        }

        
        /// <summary>
        /// WHEN CLICKED, CATEGORIES CAN BE SELECTED IN MYPLAYERCONTROL COMBOBOXES AND THE BUTTON WILL BE DISABLED
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void giveCat_Click(object sender, EventArgs e)
        {
            categories = Enum.GetValues(typeof(MyCategory)).Cast<MyCategory>().ToList();

            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 4; j++)
                {
                    Players[j].mycomboxes[i].Items.Clear();
                }
            }

            for (int j = 0; j < 4; j++)
            {
                for (int i = 0; i < 4; i++)
                {
                    var currentCat = categories[r.Next(categories.Count)];
                    Players[j].mycomboxes[0].Items.Add(currentCat);
                    categories.Remove(currentCat);
                }

                for (int i = 0; i < 4; i++)
                {
                    Players[i].mycomboxes[0].Enabled = true;
                }
              
            }

            giveCat.Enabled = false;


            SetRules("Choose the position of each of your four categories! (the higher the position the further you move)");

        }

        
        
        /// <summary>
        /// ADDS THE CATEGORIES TO THE PLAYERS (DEPENDENT ON THE NUMBER OF PLAYERS) AND STARTS THE GAME
        /// ALSO ENABLES THE QUESTIONCONTROL AND DISABLES THE START BUTTON
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Start_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < CurrentGame.NoOfPlayers; i++)
            {
                CurrentGame.PlayerXCategoryY[i].Clear();
                for (int j = 0; j < 4; j++)
                {
                    CurrentGame.PlayerXCategoryY[i].Add((MyCategory)Players[i].mycomboxes[j].SelectedItem);
                }
                CurrentGame.PlayerNames[i] = Players[i].Name;
            }
           
            LastRound = false;
            CurrentGame.NewCategories += myNewCategories;
            questionControl1.receiveQuestion(CurrentGame.getCurrentQuestion(),CurrentGame.PlayerNames[CurrentGame.CurrentlyOperatingPlayer], CurrentGame.CurrentlyOperatingPlayer);
            questionControl1.Enabled = true;
            Start.Enabled = false;
            SetRules("Answer the questions!");
        }


        /// <summary>
        /// SENDS THE GAME FROM CLASS MYGAME TO MYFIELDCONTROL
        /// </summary>
        /// <param name="newgame"></param>
        internal void sendGame(MyGame newgame)
        {
            CurrentGame = newgame;
        }

        
        /// <summary>
        /// ENABLES THE CATEGORY BUTTON AND DISABLES THE QUESTIONCONTROL WHEN ALL FOUR CATEGORY QUESTIONS WERE ANSWERED
        /// </summary>
        /// <param name="mysender"></param>
        /// <param name="e">CHECKS IF ALL CATEGORIES ARE ANSWERED</param>
        public void myNewCategories(object mysender, MyCategoryEventArgs e)
        {
            if (e.allCategoriesAnswered == true)
            {
                
                giveCat.Enabled = true;
                questionControl1.Enabled = false;
                LastRound = true;
                SetRules("Press the Categories-Button");
                

            }
            

        }
              
        /// <summary>
        /// DISABLES THE START BUTTON, THE CATEGORIES BUTTON AND THE QUESTION CONTROL WHEN A PLAYER WINS THE GAME
        /// ALSO SHOWS THE WINNER IN A MESSAGEBOX
        /// </summary>
        /// <param name="mysender"></param>
        /// <param name="e">CHECKS IF A PLAYER FINISHED THE GAME</param>
        public void myGameEndsNow(object mysender, MyPositionEventArgs e)
        {
            if (e.SomeoneFinished == true)
            {
                MessageBox.Show("The Winner is " + CurrentGame.PlayerNames[CurrentGame.CurrentlyOperatingPlayer]);
                giveCat.Enabled = false;
                Start.Enabled = false;
                questionControl1.Enabled = false;
                SetRules("To start a new game, press the New Game-Button!");

            }


        }


        /// <summary>
        /// ENABLES THE CATEGORIES BUTTON AND DISABLES THE PLAYERCONTROLS TO RESTART THE GAME
        /// </summary>
        internal void Restart()
        {
            giveCat.Enabled = true;
            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 4; j++)
			{
                Players[i].mycomboxes[j].Enabled = false;
			}
                
            }
        }

        /// <summary>
        /// HIDES THE PICTURECONTROL
        /// </summary>
        /// <param name="i">PICTUREBOX i</param>
        internal void HideMyPicture(int i)
        {
            mypictures[i].Visible = false;
        }

        /// <summary>
        /// SHOWS THE PICTURECONTROL
        /// </summary>
        /// <param name="i">PICTUREBOX i</param>
        internal void ShowMyPicture(int i)
        {
            mypictures[i].Visible = true;
        }

        /// <summary>
        /// CHANGES THE RULES-TEXTBOX
        /// </summary>
        /// <param name="p">STRING p</param>
        internal void SetRules(string p)
        {
            rules.Text = p;
        }
    }
}
