﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace MyCSharpProject
{
    public partial class QuestionControl : UserControl
    {
        
        Random r;
        Button[] buttons;
        List<MyPlayerControl> playerControls;
        public event EventHandler<MyQuestionEventArgs> QuestionAnswered;
        List<Color> mybackcolor;

        public QuestionControl()
        {
            InitializeComponent();

            r = new Random();
            buttons = new[] { button1, button2, button3, button4 };
            playerControls = new List<MyPlayerControl>();
            mybackcolor = new List<Color>() { Color.Red, Color.LightGreen, Color.LightSkyBlue, Color.Yellow};
            
        }

        //NOT USED:
        private void richTextBox1_TextChanged(object sender, EventArgs e)
        {

        }

        
        /// <summary>
        /// RECEIVES THE QUESTION FROM MYFIELDCONTROL AND ADDS IT TO THE QUESTION CONTROL
        /// </summary>
        /// <param name="question">CURRENT QUESTION</param>
        /// <param name="Playername">CURRENT PLAYER NAME</param>
        /// <param name="Playernumber">CURRENT PLAYER NUMBER</param>
        public void receiveQuestion(MyQuestion question, string Playername, int Playernumber)
        {
            Spielername.Text = "Player : " + Playername;
            var antworten = new List<String>();
            antworten.Add(question.RightAnswer);
            antworten.Add(question.WrongAnswerA);
            antworten.Add(question.WrongAnswerB); 
            antworten.Add(question.WrongAnswerC);
            richTextBox1.BackColor = mybackcolor[Playernumber];
            
            Category.Text = "Category : " + question.Category.ToString();
            richTextBox1.Text = question.Question;

            //RANDOMIZES THE ANSWER BUTTONS:
            while (antworten.Count > 0)
            {
                var antwortIndex = r.Next(0, antworten.Count);
                var antwort = antworten[antwortIndex];
                antworten.RemoveAt(antwortIndex);
                buttons[antworten.Count].Text = antwort;
                buttons[antworten.Count].Tag = antwort == question.RightAnswer;
            }
        }

        /// <summary>
        /// CHANGES THE COLOR OF THE BUTTONS AFTER ANSWERING (CLICKING A BUTTON)
        /// ALSO GIVES TELLS THE METHOD ANSWERGIVEN IN MYFIELDCONTROL THAT AN ANSWER IS GIVEN
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button_Click(object sender, EventArgs e)
        {
            var button = sender as Button;

            foreach (var _button in buttons)
            {
                if ((bool)_button.Tag)
                {
                    _button.BackColor = Color.LimeGreen;
                   
                }
                else
                    _button.BackColor = Color.Red;
            }
            
            this.Invalidate();
            var t = new System.Windows.Forms.Timer();
            t.Interval = 500;
            EventHandler eh = null;

            eh = (Sender, eventargs) =>
            {
                t.Stop();
                t.Tick -= eh;

                foreach (var _button in buttons)
                {
                    _button.BackColor = System.Drawing.SystemColors.Control;
                    _button.UseVisualStyleBackColor = true;
                }
                this.Invalidate();

                if (button != null)
                {
                    var isCorrect = (bool)button.Tag;
                    QuestionAnswered(this, new MyQuestionEventArgs(isCorrect));
                }
            };

            t.Tick += eh;
            t.Start();
  
        }

        //NOT USED:
        private void Spielername_TextChanged(object sender, EventArgs e)
        {

        }


    }
}
