﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml.Serialization;

namespace QuizSome
{
    class XmlParserUser
    {
        static XmlSerializer xml;

        /// <summary>
        /// Get the path where the user file is saved.
        /// </summary>
        static public string UserPath
        {
            get
            {
                return Path.Combine(XmlSettings.BasePath, "user.xml");
            }
        }

        /// <summary>
        /// In the constructor xml is set to a new xml serializer for a list of users.
        /// </summary>
        static XmlParserUser()
        {
            xml = new XmlSerializer(typeof(List<User>));
        }

        /// <summary>
        /// This method adds a user to the users file. It is nowhere called, but implemented for further use.
        /// </summary>
        /// <param name="user">A paramater of type User.</param>
        static public void addUser(User user)
        {
            List<User> users;
            try
            {
                //read all users
                FileStream streamOut = new FileStream(UserPath, FileMode.Open);
                users = xml.Deserialize(streamOut) as List<User>;
                streamOut.Close();
            }
            catch
            {
                //print an error if opening the file did not work
                users = new List<User>();
                MessageBox.Show("Error: Couldn't open file. Or no users are set yet!");
            }

            //add user
            users.Add(user);

            //save all users
            try
            {
                File.Delete(UserPath);
                FileStream streamIn = new FileStream(UserPath, FileMode.Create);
                xml.Serialize(streamIn, users);
                streamIn.Close();
            }
            catch
            {
                //print an error if opening the file did not work
                MessageBox.Show("Error: Couldn't open file.");
            }
        }

        /// <summary>
        /// Proofs if a login was successfull.
        /// </summary>
        /// <param name="nick">The given nickname</param>
        /// <param name="pwd">The given password</param>
        /// <returns>Returns a user if login was successfull. If not it returns an empty user.</returns>
        static public User Login(string nick, string pwd)
        {
            var tmp = new User();
            tmp = null;

            //read all users
            try
            {
                FileStream streamOut = new FileStream(UserPath, FileMode.Open);
                var users = xml.Deserialize(streamOut) as List<User>;
                streamOut.Close();

                //login user by setting the return value of the estimated user
                foreach (User allUsers in (List<User>)users)
                {
                    if (allUsers.Nickname == nick && allUsers.Password == pwd)
                    {
                        tmp = allUsers;
                    }
                }
            }
            catch
            {
                //print error if opening file did not work
                MessageBox.Show("Error: Couldn't open file. No login possible!");
            }
            return tmp;
        }

        /// <summary>
        /// This methods logs the user out and saves all his stats to the file
        /// </summary>
        /// <param name="user">A given user which is logged out</param>
        static public void logout(User user)
        {
            FileStream streamOut = null; FileStream streamIn = null;
            var users = new List<User>();
            //read all users
            try
            {
                streamOut = new FileStream(UserPath, FileMode.Open);
                users = xml.Deserialize(streamOut) as List<User>;
                streamOut.Close();
            }
            catch
            {   
                //error message when opening file failed
                MessageBox.Show("Could not read the user.xml.");
            }
            //logout user
            for (int i = 0; i < users.Count; i++)
            {
                if (users[i].Nickname == user.Nickname && users[i].Password == user.Password)
                {
                    users[i].Won = user.Won;
                    users[i].Lost = user.Lost;
                    users[i].Score = user.Score;
                }
            }
            try
            {
                //save all users
                streamIn = new FileStream(UserPath, FileMode.Create);
                xml.Serialize(streamIn, users);
                streamIn.Close();
            }
            catch
            {
                //error message when opening file failed
                MessageBox.Show("Error: Couldn't save user.xml. Logout was not successfull. Changes were not saved!");
            }
        }
    }
}
