﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace QuizSome
{
    public partial class MainFrame : Form
    {
        Quiz game;
        /// <summary>
        /// This constructor initalizes the game.
        /// </summary>
        public MainFrame()
        {
            game = new Quiz();
            InitializeComponent();
            game.stateChanged += new EventHandler<myGameStateEvent>(game_stateChanged);
        }

        /// <summary>
        /// If the game state changes, this method proofs in which game state
        /// you are. Depending on the case it runs several commands and methods.
        /// </summary>
        /// <param name="sender">sender</param>
        /// <param name="e">the event</param>
        void game_stateChanged(object sender, myGameStateEvent e)
        {
            switch (e.currentGameState)
            {
                case GameState.finished:
                    EndedGame();
                    break;
                case GameState.gaming:
                    ShowDicing(false);
                    restart.Visible = false;
                    ManageElements(false);
                    quizScreenControl1.recieveGame(game);
                    game.StartStopWatch();
                    break;
                case GameState.wrongLogin:
                    loginScreenControl1.Error = true;
                    loginScreenControl1.ErrorMessage = "Sorry, wrong password or nickname or both! :)";
                    break;
                case GameState.loggedOut:
                    ManageElements(true);
                    restart.Visible = false;
                    loginScreenControl1.ErrorMessage = "You are now logged out!!! Come back soon! :)";
                    break;
                case GameState.beforeDicing:
                    dice1.Starter = "Try your luck! :)";
                    game.RestartDicing();
                    ShowDicing(true);
                    break;
                case GameState.diceIsRolling:
                    ShowDicing(true);

                    var t = new System.Windows.Forms.Timer();
                    t.Interval = 250;
                    int counter = 0;
                    var r = new Random();
                    EventHandler eh=null;
                    eh = (s, eventargs) => {
                        if (counter < 10)
                        {
                            dice1.DicePlayer1 = r.Next(1,6).ToString();
                            dice1.DicePlayer2 = r.Next(1, 6).ToString();
                            counter++;
                        }
                        else if (counter >= 10 && counter < 17)
                        {
                            dice1.DicePlayer1 = game.Dices[0].ToString();
                            dice1.DicePlayer2 = game.Dices[1].ToString();
                            dice1.Starter = "Player " + (game.CurrentPlayerNumber + 1) + " starts";
                            counter++;
                        }
                        else
                        {
                            t.Stop();
                            t.Tick -= eh;
                            game.Start();
                        }
                            };
                    t.Tick += eh;
                    t.Start();

                    break;
                case GameState.quit:
                    Application.Exit();
                    break;
            }
        }

        private void EndedGame()
        {
            game.UpdatePlayer();
            //game.RestartDicing();
            quizScreenControl1.DeleteQuestions();
            game.MixQuestions();
            if (game.Points[0] > game.Points[1])
                MessageBox.Show("Player 1 has won!");
            else if (game.Points[0] < game.Points[1])
                MessageBox.Show("Player 2 has won!");
            else
            {
                if (game.Times[0] > game.Times[1])
                    MessageBox.Show("Player 2 has won!");
                else if (game.Times[0] < game.Times[1])
                    MessageBox.Show("Player 1 has won!");
                else
                    MessageBox.Show("Draw! :(");
            }
            restart.Visible = true;
            for (int i = 0; i < 2; i++)
            {
                for (int j = 0; j < 3; j++)
                {
                    game.Joker[i][j] = true;
                }
            }
            game.ResetAll();
        }

        void ShowDicing(bool control)
        {
            dice1.DicePlayer1 = "0";
            dice1.DicePlayer2 = "0";
            quizScreenControl1.Visible = !control;
            loginScreenControl1.Visible = !control;
            logIn.Visible = !control;
            logOut.Visible = control;
            dice1.Visible = control;
            startGame.Visible = control;
            restart.Visible = !control;
        }

        void ManageElements(bool control)
        {
            quizScreenControl1.Visible = !control;
            loginScreenControl1.Visible = control;
            loginScreenControl1.Error = control;
            logIn.Visible = control;
            logOut.Visible = !control;
            dice1.Visible = false;
            startGame.Visible = false;
        }

        /// <summary>
        /// Logs a certain user in.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void logIn_Click(object sender, EventArgs e)
        {
            game.SignIn(loginScreenControl1.nickPlayer1, loginScreenControl1.pwdPlayer1, loginScreenControl1.nickPlayer2, loginScreenControl1.pwdPlayer2);
        }

        /// <summary>
        /// Logs a certain user out.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void logOut_Click(object sender, EventArgs e)
        {
            game.UserLogout();
        }

        /// <summary>
        /// Let's the game end.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void quitButton_Click_1(object sender, EventArgs e)
        {
            game.Quit();
        }

        /// <summary>
        /// Sets the game state to diceIsRolling so the game will start.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void startGame_Click_1(object sender, EventArgs e)
        {
            game.ChangeState(GameState.diceIsRolling);
        }

        /// <summary>
        /// Restarts the game by setting the game state to beforeDicing.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void restart_Click_1(object sender, EventArgs e)
        {
            game.ChangeState(GameState.beforeDicing);
        }
    }
}
