﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml.Serialization;

namespace QuizSome
{
    class XmlParserQuestion
    {
        static XmlSerializer xml;

        /// <summary>
        /// Get the path where the question file is saved.
        /// </summary>
        static public string QuestionPath
        {
            get
            {
                return Path.Combine(XmlSettings.BasePath, "questions.xml");
            }
        }

        /// <summary>
        /// In the constructor xml is set to a new xml serializer for a list of users.
        /// </summary>
        static XmlParserQuestion()
        {
            xml = new XmlSerializer(typeof(List<Questions>));
        }

        /// <summary>
        /// This method loads all questions into the game
        /// </summary>
        /// <returns>Returns a list of questions which can be iterated afterwards</returns>
        static public List<Questions> loadQuestions()
        {
            List<Questions> questions;
            try
            {
                //read questions
                FileStream streamOut = new FileStream(QuestionPath, FileMode.Open);
                questions = xml.Deserialize(streamOut) as List<Questions>;
                streamOut.Close();
            }
            catch
            {
                //error message when opening file failed
                questions = new List<Questions>();
                MessageBox.Show("Error: Couldn't open file. Or no questions are set yet!");
            }
            return questions;
        }
    }
}
