﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Globalization;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace Downloader.AssetSpace
{
    public class DownloadFunktion
    {
        public async static Task DownloadYahoo(String Symbol, DateTime Start, DateTime End,  List<Values> data)
        {
            String yahooUrl = "http://ichart.finance.yahoo.com/table.csv?s=";
            yahooUrl += Symbol;
            yahooUrl += "&d=";
            yahooUrl += ( Start.Month - 1 ).ToString();
            yahooUrl += "&e=";
            yahooUrl += Start.Day.ToString();
            yahooUrl += "&f=";
            yahooUrl += Start.Year.ToString();
            yahooUrl += "&g=d&a=";
            yahooUrl += (End.Month - 1).ToString();
            yahooUrl += "&b=";
            yahooUrl += End.Day.ToString();
            yahooUrl += "&c=";
            yahooUrl += End.Year.ToString();
            yahooUrl += "&ignore=.csv";
            //Debug.WriteLine(yahooUrl);
            String responseBody;
            
            HttpClient webinterface = new HttpClient();
            HttpResponseMessage response = await webinterface.GetAsync(yahooUrl);
            response.EnsureSuccessStatusCode();
            responseBody = await response.Content.ReadAsStringAsync();
            String[] lines = responseBody.Split('\n');
            //Debug.WriteLine(responseBody);
            data.AddRange(lines.Skip(1).TakeWhile(s=>s!=string.Empty).Select(  L => {
                var tokens = L.Split(',');
                var date_strings = tokens[0].Split('-').ToArray();
                //Debug.WriteLine(tokens.ToString());
                return new Values()
                {
                    Datum    = new DateTime( Int32.Parse(date_strings[0]), 
                                                Int32.Parse(date_strings[1]), 
                                                Int32.Parse(date_strings[2]) ),
                    Open     = Decimal.Parse(tokens[1],new CultureInfo("en-US") ),
                    Max = Decimal.Parse(tokens[2], new CultureInfo("en-US")),
                    Low = Decimal.Parse(tokens[3], new CultureInfo("en-US")),
                    Close = Decimal.Parse(tokens[4], new CultureInfo("en-US")),
                    Volume = Decimal.Parse(tokens[5], new CultureInfo("en-US")),
                    AdjClose = Decimal.Parse(tokens[6], new CultureInfo("en-US"))
                };
            }));
            Debug.WriteLine("Symbol "+Symbol+" geladen");
        }
    }
}
