﻿using OxyPlot;
using OxyPlot.Axes;
using OxyPlot.Series;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;
using Downloader.AssetSpace;
using System.Windows;
using System.Windows.Controls;


namespace Downloader.ViewModels
{
    class MainViewModel : BaseViewModel
    {
        Boolean canDownload;
        ListeIndices mylist;
        ObservableCollection<IndexViewModel> selectedIndices;
        private PlotModel plotModel;
        private DateTime lastUpdate = DateTime.Now;



        public MainViewModel()
        {
            PlotModel = new PlotModel(); //neu
            SetUpModel();
            selectedIndices = new ObservableCollection<IndexViewModel>();
            StartDownload = new RelayCommand(_ => DownloadIndices().Forget());
            CanDownload = true;
            mylist = new ListeIndices();
            mylist.ReadIndices();
            foreach (var a in mylist.MainList)
            {
                selectedIndices.Add(new IndexViewModel(a));
                a.ReadStocks();
            }
        }

        public PlotModel PlotModel
        {
            get { return plotModel;}
            set { plotModel = value; NotifyPropertyChange(); }
        }

        public ICommand StartDownload
        {
            get;
            private set;
        }

        public ListeIndices Mylist
        {
            get { return mylist; }
        }

        public ObservableCollection<IndexViewModel> SelectedIndices
        {
            get { return selectedIndices; }
        }

        public bool CanDownload
        {
            get { return canDownload; }
            private set
            {
                canDownload = value;
                NotifyPropertyChange();
            }
        }

        public async Task DownloadIndices()
        {
            CanDownload = false;
            var downloads = GetDownloads().ToArray();
            await Task.WhenAll(downloads);
            Debug.WriteLine("finished Downloads");
            CanDownload = true;
            
            //LoadData(mylist.MainList[0]);
        }

        IEnumerable<Task> GetDownloads()
        {
            foreach (var entry in selectedIndices.Where(m => m.IsSelected).Select(m => m.Index))
            {
                yield return entry.UpdateData();
                foreach (var subentry in entry.Components)
                    yield return subentry.UpdateData();
            }
        }

        private ICommand _plotCommand;
        public ICommand PlotCommand
        {
            get
            {
                if (_plotCommand == null)
                {
                    _plotCommand = new RelayCommand(
                        param => this.Plotobject(param as Asset),
                        param => this.CanPlot()
                    );
                }
                return _plotCommand;
            }
        }

        private bool CanPlot()
        {
            return true;
        }

        private void Plotobject(Asset asset)
        {
            if (asset == null)
                return;

            LoadData(asset);
        }

        public String IsChoosen { get; set; }


        private void SetUpModel()
        {
            //PlotModel.LegendTitle = "Legend";
            //PlotModel.LegendOrientation = LegendOrientation.Horizontal;
            //PlotModel.LegendPlacement = LegendPlacement.Inside;
            //PlotModel.LegendPosition = LegendPosition.TopLeft;
            //PlotModel.LegendBackground = OxyColor.FromAColor(200, OxyColors.White);
            //PlotModel.LegendBorder = OxyColors.Black;
           
            var dateAxis = new DateTimeAxis(AxisPosition.Bottom, "Date", "dd/MM/yy") { MajorGridlineStyle = LineStyle.Solid, MinorGridlineStyle = LineStyle.Dot, IntervalLength = 80 };
            PlotModel.Axes.Add(dateAxis);
            var valueAxis = new LinearAxis(AxisPosition.Left, 0) { MajorGridlineStyle = LineStyle.Solid, MinorGridlineStyle = LineStyle.Dot };
            PlotModel.Axes.Add(valueAxis);
        }
        private void LoadData(Asset a)
        {
            PlotModel.Series.Clear();
            List<Values> Data = a.Data;
            var lineSerie = new LineSeries
            {
                StrokeThickness = 2,
                MarkerSize = 3,
               // MarkerStroke = OxyColors.Green,
                MarkerType = MarkerType.Plus,
                CanTrackerInterpolatePoints = false,
                Title = string.Format("{0}", a.Name),
                Smooth = true
            };
            Data.ToList().ForEach(d => lineSerie.Points.Add(new DataPoint(  DateTimeAxis.ToDouble(d.Datum), Convert.ToDouble(d.AdjClose) )));
            PlotModel.Series.Add(lineSerie);
            PlotModel.RefreshPlot(true);
        }

    }

}
