﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace Downloader.AssetSpace
{
    public class Index : Asset
    {
        List<Stock> components;
        public List<Stock> Components
        {
            get { return components; }
        }

        public ObservableCollection<Asset> Children { get; set; }

        public Index(String Name, String Symbol)
            : base(Name, Symbol)
        {
            components = new List<Stock>();
        }
        public void ReadStocks()
        {
            String line;
            Components.Clear();
            var stream = new System.IO.StreamReader(Name+@".txt");
            while ((line = stream.ReadLine()) != null)
            {
                Components.Add(new Stock(line, line));
            }
        }

           
        async public override Task UpdateData()
        {
            await DownloadFunktion.DownloadYahoo(this.Symbol, DateTime.Now, DateTime.Now.AddYears(-10), this.Data);
        }
    }
}
