﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Downloader.AssetSpace
{
    public class ListeIndices
    {
        ObservableCollection<Index> mainList;

        public ListeIndices()
        {
            mainList = new ObservableCollection<Index>();
        }

        public ObservableCollection<Index> MainList
        {
            get { return mainList; }
        }

        public void ReadIndices()
        {
                String line;
                mainList.Clear();           
                var stream = new System.IO.StreamReader(@"indexliste.txt");
                while ((line = stream.ReadLine()) != null)
                {
                    String[] temp = line.Split(new [] {'\t'}, 2);
                    MainList.Add(new Index(temp[0],temp[1]));                
                }
        }

        public void UpdateIndices(Action<Index> onFinishedEach)
        {            

            //List<Task> tasks = new List<Task>();
            foreach (var a in MainList)
            {
                var task = a.UpdateData();
                //tasks.Add(task);
                task.ContinueWith(_ => onFinishedEach(a));
            }

            //Task.WhenAll(tasks.ToArray()).ContinueWith(_=>onFinished(mainList));
        }
    }
}