﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Diagnostics;

namespace ColorFlooder
{
    public class Formular : Form
    {
        private ColorPanelControl cpc;
        private const string FORM_TEXT = "C# Beispielprojekt - Color Flooder";

        public Formular()
        {
            Text = FORM_TEXT;
            ClientSize = new Size(480, 320);
            Icon = Icons.Ball;
            MinimumSize = Size;
            cpc = new ColorPanelControl();
            cpc.Location = new Point(25, 35);
            cpc.Size = new Size(Width - 60, Height - 80);
            cpc.Anchor = AnchorStyles.Left | AnchorStyles.Right | AnchorStyles.Bottom | AnchorStyles.Top;
            Controls.Add(cpc);
            Array farben = Enum.GetValues(typeof(FlooderColor));
            int blength = (Width-15) / farben.Length;
            for (int i = 0; i < farben.Length; i++)
            {
                Button bt = new Button();
                bt.Anchor = AnchorStyles.Top;
                bt.Click += new EventHandler(bt_Click);
                bt.Size = new Size(blength, 25);
                bt.Location = new Point(i * blength, 0);
                bt.BackColor = Color.FromArgb((int)farben.GetValue(i));
                bt.Tag = (FlooderColor)farben.GetValue(i);
                Controls.Add(bt);
            }
        }

        private void bt_Click(object sender, EventArgs e)
        {
            Button bt = (Button)sender;
            bool finished = cpc.SetColor((FlooderColor)bt.Tag);
            UpdateText();
            Refresh();
            if (finished && MessageBox.Show("Spiel gewonnen in " + cpc.Counter.ToString() + " Zügen. Neues Spiel?", "Sieg", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
            {
                cpc.Reset();
                UpdateText();
            }
        }

        private void UpdateText()
        {
            Text = string.Format("{0} - {1} Züge", FORM_TEXT , cpc.Counter.ToString());
        }
    }

    public class ColorPanelControl : Panel
    {
        private ColorPanelCollection collection;
        private int count;

        public ColorPanelControl()
        {
            collection = new ColorPanelCollection(15, 15);
            SetStyle(ControlStyles.ResizeRedraw, true);
        }

        public void Reset()
        {
            count = 0;
            collection.Reset();
            Refresh();
        }

        public int Counter
        {
            get { return count; }
        }

        public bool SetColor(FlooderColor c)
        {
            count++;
            collection[0, 0].SetColor(c,c);
            FlooderColor checkc = collection[0, 0].GetColor();
            for (int i = 0; i < collection.N; i++)
                for (int j = 0; j < collection.M; j++)
                    if (checkc != collection[i, j].GetColor())
                        return false;
            return true;
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            collection.Paint(e.Graphics, Width, Height);
            base.OnPaint(e);
        }
    }

    public class ColorPanel
    {
        private ColorPanelCollection parent;
        private FlooderColor color;
        private int x, y;

        public ColorPanel(ColorPanelCollection parent, FlooderColor color, int x, int y)
        {
            this.parent = parent;
            this.color = color;
            this.x = x;
            this.y = y;
        }

        public void Paint(Graphics g, int Width, int Height)
        {
            g.FillRectangle(new SolidBrush(Color.FromArgb((int)color)), new Rectangle(0, 0, Width, Height));
        }

        public FlooderColor GetColor()
        {
            return color;
        }

        public void SetColor(FlooderColor oldcolor, FlooderColor newcolor)
        {
            FlooderColor ocolor = oldcolor;
            if (x == 0 && y == 0)
            {
                if (oldcolor == color)
                    return;
                ocolor = color;
                color = newcolor;
            }
            else if (color != oldcolor)
                return;
            else
                color = newcolor;
            for (int i = 0; i <= 1; i++)
                for (int j = 0; j <= 1; j++)
                    if (i != j)
                    {
                        ColorPanel cp = parent[y+j, x+i];
                        if (cp != null)
                            cp.SetColor(ocolor, newcolor);
                    }
        }
    }

    public class ColorPanelCollection
    {
        private ColorPanel[,] array;
        private int n, m;

        public ColorPanelCollection(int n, int m)
        {
            this.n = n;
            this.m = m;
            Reset();
        }

        public int N
        {
            get { return n; }
        }

        public int M
        {
            get { return m; }
        }

        public void Reset()
        {
            Random r = new Random();
            Array farben = Enum.GetValues(typeof(FlooderColor));
            array = new ColorPanel[n, m];
            for (int i = 0; i < n; i++)
                for (int j = 0; j < m; j++)
                    array[i, j] = new ColorPanel(this, (FlooderColor)farben.GetValue(r.Next(0, farben.Length)), j, i);
        }

        public ColorPanel this[int x, int y]
        {
            get { if (x < 0 || x > m - 1 || y < 0 || y > n - 1) return null; return array[x, y]; }
            set { array[x, y] = value; }
        }

        public void Paint(Graphics g, int Width, int Height)
        {
            float width = (float)Width / (float)m;
            float height = (float)Height / (float)n;
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < m; j++)
                {
                    array[i, j].Paint(g, (int)width, (int)height);
                    g.TranslateTransform(width, 0f);
                }
                g.TranslateTransform(-Width, height);
            }
            g.TranslateTransform(0, -Height);
        }
    }

    public enum FlooderColor : int
    {
        Red = -65536,
        Blue = -16776961,
        Green = -16744448,
        Pink = -16181,
        Orange = -23296,
        Yellow = -256,
    }
}
