﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace WindowsFormsApplication1
{
    /// <summary>
    /// Class that stores information about the current board.
    /// </summary>
    [Serializable]
    public class Level
    {
        private int num;
        private Rectangle[] rec;
        private int entrenceX;
        private int entrenceY;
        private int exitX;
        private int exitY;
        private List<Rectangle> stairs = new List<Rectangle>();
        private List<Rectangle> holes = new List<Rectangle>();

        /// <summary>
        /// Level-Default-Constructor.
        /// </summary>
        public Level() { }

        /// <summary>
        /// Level-Constructor.
        /// </summary>
        /// <param name="num">Number of the Level</param>
        public Level(int num)
        {
            this.num=num;
        }

        /// <summary>
        /// Gets or sets the number of the Level.
        /// </summary>
        public int Num
        {
            get { return num; }
            set { num = value; }
        }

        /// <summary>
        /// Gets or sets the walls and grounds of the level
        /// </summary>
        public Rectangle[] Rec
        {
            get { return rec; }
            set { rec = value; }
        }

        /// <summary>
        /// Gets or sets the x-coordinate of the entrence.
        /// </summary>
        public int EntrenceX
        {
            get { return entrenceX; }
            set { entrenceX = value; }
        }

        /// <summary>
        /// Gets or sets the y-coordinate of the entrence.
        /// </summary>
        public int EntrenceY
        {
            get { return entrenceY; }
            set { entrenceY = value; }
        }

        /// <summary>
        /// Gets or sets the x-coordinate of the exit.
        /// </summary>
        public int ExitX
        {
            get { return exitX; }
            set { exitX = value; }
        }

        /// <summary>
        /// Gets or sets the y-coordinate of the exit.
        /// </summary>
        public int ExitY
        {
            get { return exitY; }
            set { exitY = value; }
        }

        /// <summary>
        /// Draws the current Level on the board.
        /// </summary>
        /// <param name="g">Graphics that shall draw the level.</param>
        public void Draw(Graphics g)
        {
            foreach (Rectangle r in Rec)
            {
                g.DrawRectangle(new Pen(Color.Yellow), r);
                g.FillRectangle(new SolidBrush(Color.Yellow), r);
            }
            for (int i = 0; i < stairs.Count; i++)
            {
                g.DrawRectangle(new Pen(Color.Yellow), stairs[i]);
                g.FillRectangle(new SolidBrush(Color.Yellow), stairs[i]);
            }
            for(int i=0;i<holes.Count;i++)
            {
                g.DrawRectangle(new Pen(Color.Black), holes[i]);
                g.FillRectangle(new SolidBrush(Color.Black), holes[i]);
            }
            g.DrawRectangle(new Pen(Color.Blue), new Rectangle(entrenceX, entrenceY + 80, 30, 30));
            g.FillRectangle(new SolidBrush(Color.Blue), new Rectangle(entrenceX, entrenceY + 80, 30, 30));
            g.DrawRectangle(new Pen(Color.Blue), new Rectangle(exitX, exitY, 30, 30));
            g.FillRectangle(new SolidBrush(Color.Blue), new Rectangle(exitX, exitY, 30, 30));
        }

        /// <summary>
        /// Adds a stair (rectangle with half the height of a Lemming).
        /// </summary>
        /// <param name="p">x-coordinate of the stair.</param>
        /// <param name="p_2">y-coordinate of the stair.</param>
        public void AddStair(int p, int p_2)
        {
            stairs.Add(new Rectangle(p, p_2, 20, 5));
        }

        /// <summary>
        /// Adds a hole in a wall.
        /// </summary>
        /// <param name="p">x-coordinate of the wall.</param>
        /// <param name="p_2">y-coordinate of the wall.</param>
        internal void AddHole(int p, int p_2)
        {
            holes.Add(new Rectangle(p, p_2, 10, 10));
        }

        /// <summary>
        /// Tells whether there is the ground.
        /// </summary>
        /// <param name="p">x-coordinate.</param>
        /// <param name="p_2">y-coordinate.</param>
        /// <returns></returns>
        internal bool hasRectAt(int p, int p_2)
        {
            foreach (Rectangle r in rec)
            {
                if (r.Contains(p,p_2)&&r.Top<=p_2)
                {
                    return true;
                }
            }
            for (int i = 0; i < stairs.Count; i++)
            {
                if (stairs[i].Contains(p, p_2) && stairs[i].Top <= p_2)
                {
                    return true;
                }
            }
            return false;
        }

        /// <summary>
        /// Tells whether there is a wall.
        /// </summary>
        /// <param name="p">x-coordinate.</param>
        /// <param name="p_2">y-coordinate.</param>
        /// <returns></returns>
        internal bool hasBoundaryAt(int p, int p_2)
        {
            for (int i = 0; i < holes.Count; i++)
            {
                if (holes[i].Contains(p, p_2))
                    return false;
            }
            foreach(Rectangle r in rec)
            {
                if(r.Contains(p,p_2) && r.Bottom>=p_2)
                    return true;
            }
            for (int i = 0; i < stairs.Count; i++)
            {
                if (stairs[i].Contains(p, p_2 + 5) && stairs[i].Bottom >= p_2)
                    return true;
            }
            return false;
        }

        /// <summary>
        /// Tells whether there is the exit.
        /// </summary>
        /// <param name="p">x-coordinate.</param>
        /// <param name="p_2">y-coordinate.</param>
        /// <returns></returns>
        internal bool hasExitAt(int p, int p_2)
        {
            if (p <= ExitX + 15 && p>=ExitX+5 && p_2 <= ExitY-1)
                return true;
            return false;
        }

        /// <summary>
        /// Tells whether there is a stair.
        /// </summary>
        /// <param name="p">x-coordinate.</param>
        /// <param name="p_2">y-coordinate.</param>
        /// <returns></returns>
        internal bool hasStairAt(int p, int p_2)
        {
            foreach (Rectangle r in rec)
            {
                if (r.Contains(p, p_2)&&r.Bottom<=p_2+5)
                    return true;
            }
            for (int i = 0; i < stairs.Count; i++)
            {
                if (stairs[i].Contains(p, p_2) && stairs[i].Bottom <= p_2 + 5)
                    return true;
            }
            return false;
        }

        /// <summary>
        /// Gives the height of a stair.
        /// </summary>
        /// <param name="p">x-coordinate of the stair.</param>
        /// <param name="p_2">y-coordinate of the stair.</param>
        /// <returns></returns>
        internal int StairHeight(int p, int p_2)
        {
            foreach (Rectangle r in rec)
            {
                if (r.Contains(p, p_2) && r.Bottom <= p_2+5)
                    return r.Bottom;
            }
            for (int i = 0; i < stairs.Count; i++)
            {
                if (stairs[i].Contains(p, p_2) && stairs[i].Bottom <= p_2 + 5)
                    return stairs[i].Bottom;
            }
            return 0;
        }
    }
}
