﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace WindowsFormsApplication1
{
    /// <summary>
    /// Class, containing the informations about the recent game.
    /// </summary>
    [Serializable]
    public class Game
    {
        private Color lemmingcolor;
        private int level = 1;
        private string playerName;
        private bool saveAllowed;
        private int speed = 1;

        public Game()
        {
            lemmingcolor = Color.Black;
            playerName = string.Empty;
            saveAllowed = false;
            level = 1;
            speed = 1;
        }
        public Game(Color lemmingcolor, string playerName,bool saveAllowed, int level, int speed)
        {
            this.lemmingcolor = lemmingcolor;
            this.playerName = playerName;
            this.saveAllowed = saveAllowed;
            this.level = level;
            this.speed = speed;
        }

        /// <summary>
        /// Gets or sets the color of the Lemmings.
        /// </summary>
        public int Lemmingcolor
        {
            get { return lemmingcolor.ToArgb(); }
            set { lemmingcolor = Color.FromArgb(value); }
        }

        /// <summary>
        /// Gets or sets the name of the player.
        /// </summary>
        public string PlayerName
        {
            get { return playerName; }
            set { playerName = value; }
        }

        /// <summary>
        /// Gets or sets the level of the game.
        /// </summary>
        public int Level
        {
            get { return level; }
            set { level = value; }
        }

        /// <summary>
        /// Gets or sets whether the user can save the game manually.
        /// </summary>
        public bool SaveAllowed
        {
            get { return saveAllowed; }
            set { saveAllowed = value; }
        }

        /// <summary>
        /// Gets or sets the speed of the game.
        /// </summary>
        public int Speed
        {
            get { return speed; }
            set { speed = value; }
        }
    }
}
