﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Serialization;
using System.Threading;

namespace WindowsFormsApplication1
{
    public delegate void BitmapRefresh();
    public delegate void ClosingDelegate();

    /// <summary>
    /// Class that provides the framework of the game.
    /// </summary>
    public partial class GameFrame : Form
    {
        Color lemmingcolor = Color.SandyBrown;
        int maxlev = 2;
        int level = 0;
        int killedLemmings = 0;
        int timeSinceLastLemming = 0;
        int speed = 1;
        int savedLemmings = 0;
        int neededSavedLemmings = 5;
        const int picWidth = 800;
        const int picHeight = 600;
        string playerName;
        bool saveAllowed;
        Level lev = null;
        Graphics g = null;
        LemmingCollection lemmingcol = new LemmingCollection();
        Image gameImage;
        System.Threading.Timer timer;
        List<int> stopperX = new List<int>();
        List<int> stopperY = new List<int>();
        int addStairIn = 0;
        int buildHole = 0;
        int maxSurviveHeight = 20;

        /// <summary>
        /// Loading the first Level, drawing it and initializing the game.
        /// </summary>
        /// <param name="lemmingcolor">Color of the Lemmings.</param>
        /// <param name="playerName">Name of the player.</param>
        /// <param name="saveAllowed">Whether the player is allowed to save the game hisself/herself.</param>
        /// <param name="level">Number of the level to start with.</param>
        public GameFrame(Color lemmingcolor, string playerName, bool saveAllowed, int level)
        {
            XmlSerializer xml = new XmlSerializer(typeof(Level));
            FileStream fs = File.Open("..\\..\\" + level + ".lev", FileMode.Open);
            try { lev = (Level)xml.Deserialize(fs); }                   //Load level
            catch { }
            finally { fs.Close(); }
            this.lemmingcolor = lemmingcolor;
            this.level = level;
            this.playerName = playerName;
            this.saveAllowed = saveAllowed;

            InitializeComponent();
            this.Width = picWidth + 30;
            this.Height = picHeight + 15;
            pictureBox1.Width = picWidth;
            pictureBox1.Image = gameImage;
            toolStripLabel2.Text = playerName;
            toolStripLabel3.Text = "Level " + this.level;
            toolStripLabel4.Text = "Killed Lemmings: 0";
            toolStripLabel5.Text = "Saved Lemmings: 0";

            //Draw image of the quit-Button.
            Image im = new Bitmap(22, 22);
            g = Graphics.FromImage(im);
            g.FillRectangle(new SolidBrush(Color.White), 0, 0, 22, 22);
            g.DrawLine(new Pen(Color.Red, 2), 0, 0, 22, 22);
            g.DrawLine(new Pen(Color.Red, 2), 22, 0, 0, 22);
            quitButton.Image = im;
            if (!saveAllowed) saveButton.Visible = false;
            stopperButton.Checked = true;

            //Draw background and Level.
            gameImage = new Bitmap(picWidth, picHeight);
            g = Graphics.FromImage(gameImage);
            savedLemmings = 0;
            toolStripLabel3.Text = "Level " + level;
            g.FillRectangle(new SolidBrush(Color.Black), 0, 0, picWidth, picHeight);
            lev.Draw(g);
            gameImage.RotateFlip(RotateFlipType.RotateNoneFlipY);
            pictureBox1.Image = gameImage;

            //Starting the game.
            timer = new System.Threading.Timer(redrawLevel, this, 1000, 20);
        }

        /// <summary>
        /// Calculates and redraws the Lemmings as well as the Level if necessary.
        /// </summary>
        /// <param name="obj">An arbitrary object.</param>
        public void redrawLevel(object obj)
        {
            lock (this)
            {
                if (timeSinceLastLemming == 0) lemmingcol.Add(new Lemming(lev.EntrenceX + 10, lev.EntrenceY + 90, 1, lemmingcolor));
                g.FillRectangle(new SolidBrush(Color.Black), 0, 0, picWidth, picHeight);
                lev.Draw(g);
                timeSinceLastLemming = (timeSinceLastLemming + 1) % (50 / speed);
                for (int i = 0; i < lemmingcol.Count; i++)
                {
                    Lemming l = lemmingcol[i];

                    //Lemming with id=1 on ground moves the the right.
                    if (l.ID == 1 && (lev.hasRectAt(l.X, l.Y) || lev.hasRectAt(l.X + 10, l.Y)))
                    {
                        //correct the y-coordinate of the lemming if necessary.
                        while (lev.hasRectAt(l.X, l.Y) && l.Fallheight > 0)
                        {
                            if (l.Fallheight > maxSurviveHeight)
                            {
                                killedLemmings++;
                                toolStripLabel4.Text = "Killed Lemmings: " + killedLemmings;
                                lemmingcol.Remove(l);
                                l.Fallheight = 0;
                                if (killedLemmings == 5)
                                {
                                    timer.Dispose();
                                    MessageBox.Show("Game Over!");
                                    this.Invoke(new ClosingDelegate(this.Close));
                                }
                                break;
                            }
                            l.Y++;
                        }
                        if (l.Fallheight > 0)
                            l.Y--;
                        l.Fallheight = 0;

                        //Check whether the Lemming touches a Stopper.
                        for (int j = 0; j < stopperX.Count; j++)
                        {
                            if (l.X + 10 == stopperX[j] && l.Y == stopperY[j])
                                l.ID *= -1;
                        }
                        /*Do the action of the Lemming depending on the status:
                            0   Stopper
                            1   normal running Lemming
                            2   Stair-builder
                            3   Hole-builder*/
                        if (l.Status == 1 || l.Status == 4)
                            l.X += l.ID * speed;
                        else if (l.Status == 2)
                        {
                            if (addStairIn == 0)
                            {
                                lev.AddStair(l.X+5, l.Y);
                                lev.Draw(g);
                                l.X++;
                                l.Y += 5;
                                addStairIn = 5;
                            }
                            else
                            {
                                addStairIn--;
                                l.X++;
                            }
                        }
                        else if (l.Status == 3)
                        {
                            if (buildHole == 0)
                            {
                                lev.AddHole(l.X + 10, l.Y+2);
                                lev.Draw(g);
                                buildHole = 5;
                            }
                            else
                            {
                                buildHole--;
                                l.X++;
                            }
                        }
                        if (l.X + 10 == picWidth)
                        {
                            l.ID *= -1;
                        }
                        if (lev.hasBoundaryAt(l.X + 10, l.Y + 10))
                        {
                            l.ID *= -1;
                        }
                        else if (lev.hasStairAt(l.X + 10, l.Y + 2))
                        {
                            l.Y = lev.StairHeight(l.X + 10, l.Y + 1) - 1;
                            l.X++;
                        }

                        //Lemming entering the exit
                        if (lev.hasExitAt(l.X, l.Y))
                        {
                            savedLemmings++;
                            toolStripLabel5.Text = "Saved Lemmings: " + savedLemmings;
                            lemmingcol.Remove(l);
                            if (savedLemmings == neededSavedLemmings)
                            {
                                lemmingcol.Clear();
                                killedLemmings = 0;
                            }
                        }
                    }

                    //Lemming with id=1 on ground moves the the right. Further explanations see case above.
                    else if (l.ID == -1 && (lev.hasRectAt(l.X + 10, l.Y) || lev.hasRectAt(l.X, l.Y)))
                    {
                        while (lev.hasRectAt(l.X + 10, l.Y) && l.Fallheight > 0)
                        {
                            if (l.Fallheight > maxSurviveHeight)
                            {
                                killedLemmings++;
                                toolStripLabel4.Text = "Killed Lemmings: " + killedLemmings;
                                lemmingcol.Remove(l);
                                l.Fallheight = 0;
                                if (killedLemmings == 5)
                                {
                                    timer.Dispose();
                                    MessageBox.Show("Game Over!");
                                    this.Invoke(new ClosingDelegate(this.Close));
                                }
                                break;
                            }
                            l.Y++;
                            if (l.Fallheight > 0)
                                l.Y--;
                            l.Fallheight = 0;
                        }
                        for (int j = 0; j < stopperX.Count; j++)
                        {
                            if (l.X - 10 == stopperX[j] && l.Y == stopperY[j])
                                l.ID *= -1;
                        }
                        if (l.Status == 1 || l.Status == 4)
                            l.X += l.ID * speed;
                        else if (l.Status == 2)
                        {
                            if (addStairIn == 0)
                            {
                                lev.AddStair(l.X-15, l.Y);
                                lev.Draw(g);
                                l.X--;
                                l.Y += 5;
                                addStairIn = 5;
                            }
                            else
                            {
                                addStairIn--;
                                l.X--;
                            }
                        }
                        else if (l.Status == 3)
                        {
                            if (buildHole == 0)
                            {
                                lev.AddHole(l.X-10, l.Y + 2);
                                lev.Draw(g);
                                buildHole = 5;
                            }
                            else
                            {
                                buildHole--;
                                l.X--;
                            }
                        }
                        if ((l.X + 10 == picWidth && l.ID == 1) || (l.X == 0 && l.ID == -1))
                        {
                            l.ID *= -1;
                        }
                        if (lev.hasBoundaryAt(l.X, l.Y + 10))
                        {
                            l.ID *= -1;
                        }
                        else if (lev.hasStairAt(l.X, l.Y + 2))
                        {
                            l.Y = lev.StairHeight(l.X, l.Y + 1) - 1;
                            l.X--;
                        }
                        if (lev.hasExitAt(l.X, l.Y))
                        {
                            savedLemmings++;
                            toolStripLabel5.Text = "Saved Lemmings: " + savedLemmings;
                            lemmingcol.Remove(l);
                            if (savedLemmings == neededSavedLemmings)
                            {
                                lemmingcol.Clear();
                                killedLemmings = 0;
                            }
                        }
                    }

                    //Lemming falling down
                    else
                    {
                        //Accellaration
                        l.Y -= speed * l.Fallheight;
                        if (l.Status != 4)
                            l.Fallheight++;
                        else
                            l.Fallheight = 1;

                        //Lemming falling into deepness
                        if (l.Y <= 0)
                        {
                            lemmingcol.Remove(l);
                            killedLemmings++;
                            if (killedLemmings == 5)
                            {
                                timer.Dispose();
                                MessageBox.Show("Game Over!");
                                this.Invoke(new ClosingDelegate(this.Close));
                            }
                        }
                    }
                    l.Draw(g);
                }

                //Level finished?
                if (savedLemmings != neededSavedLemmings)
                {
                    gameImage.RotateFlip(RotateFlipType.RotateNoneFlipY);
                    pictureBox1.Invoke(new BitmapRefresh(pictureBox1.Refresh));
                }
                else
                {
                    timer.Dispose();
                    nextLevel();
                }
            }
        }

        /// <summary>
        /// Gets the number of the level.
        /// </summary>
        public int Level
        {
            get { return level; }
        }

        private void quitButton_Click(object sender, EventArgs e)
        {
            timer.Dispose();
            Application.Exit();
        }

        /// <summary>
        /// loads the next level.
        /// </summary>
        private void nextLevel()
        {
            if (level >= maxlev)
            {
                level = 0;
                MessageBox.Show("Wieder auf Anfang.");
                //speed++;
            }
            level++;
            killedLemmings = 0;
            savedLemmings = 0;
            XmlSerializer xml = new XmlSerializer(typeof(Level));
            FileStream fs = File.Open("..\\..\\" + level + ".lev", FileMode.Open);
            try { lev = (Level)xml.Deserialize(fs); }
            catch { }
            finally { fs.Close(); }
            toolStripLabel3.Text = "Level " + (++level);
            g.FillRectangle(new SolidBrush(Color.Black), 0, 0, picWidth, picHeight);
            lev.Draw(g);
            gameImage.RotateFlip(RotateFlipType.RotateNoneFlipY);
            pictureBox1.Invoke(new BitmapRefresh(pictureBox1.Refresh));
            timer = new System.Threading.Timer(redrawLevel, this, 1000, 20);
        }

        /// <summary>
        /// Auto-saving the current game at exit.
        /// </summary>
        /// <param name="e"></param>
        protected override void OnClosing(CancelEventArgs e)
        {
            Game game = new Game(lemmingcolor, playerName, saveAllowed, level, speed);
            FileStream fs = null;
            if (saveAllowed) fs = File.Create("auto.lem");
            else
            {
                saveFileDialog1.DefaultExt = "*.lem";
                if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                    fs = File.Create(saveFileDialog1.FileName);
                else
                    Application.Exit();
            }

            if (fs != null)
            {
                try { new XmlSerializer(typeof(Game)).Serialize(fs, game); }
                catch { }
                finally { fs.Close(); }
            }
            Application.Exit();
        }

        /// <summary>
        /// Click-action upon a Lemming
        /// </summary>
        /// <param name="sender">Sender</param>
        /// <param name="e">Mouse event args</param>
        private void ChangeLemming(object sender, MouseEventArgs e)
        {
            for (int i = 0; i < lemmingcol.Count; i++)
            {
                Lemming l = lemmingcol[i];
                if (e.X >= l.X && e.X <= l.X + 10 && picHeight - e.Y >= l.Y && picHeight - e.Y <= l.Y + 10)
                {
                    if (l.Status == 4)
                        umbrellaButton.Show();
                    if (stopperButton.Checked)
                    {
                        if (l.Status != 0)
                        {
                            l.Status = 0;
                            l.Lemmingcolor = Color.Red;
                            stopperX.Add(l.X);
                            stopperY.Add(l.Y);
                        }
                        else
                        {
                            l.Status = 1;
                            l.Lemmingcolor = lemmingcolor;
                            stopperX.Remove(l.X);
                            stopperY.Remove(l.Y);
                        }
                    }
                    else if (stairButton.Checked)
                    {
                        if (l.Status == 0)
                        {
                            l.Status = 1;
                            l.Lemmingcolor = lemmingcolor;
                            stopperX.Remove(l.X);
                            stopperY.Remove(l.Y);
                        }
                        if (l.Status != 2)
                        {
                            l.Status = 2;
                            l.Lemmingcolor = Color.Green;
                        }
                        else
                        {
                            l.Status = 1;
                            l.Lemmingcolor = lemmingcolor;
                        }
                    }
                    else if (holeButton.Checked)
                    {
                        if (l.Status == 0)
                        {
                            l.Status = 1;
                            l.Lemmingcolor = lemmingcolor;
                            stopperX.Remove(l.X);
                            stopperY.Remove(l.Y);
                        }
                        if (l.Status != 3)
                        {
                            l.Status = 3;
                            l.Lemmingcolor = Color.White;
                        }
                        else
                        {
                            l.Status = 1;
                            l.Lemmingcolor = lemmingcolor;
                        }
                    }
                    else if (umbrellaButton.Checked)
                    {
                        if (l.Status == 0)
                        {
                            l.Status = 1;
                            l.Lemmingcolor = lemmingcolor;
                            stopperX.Remove(l.X);
                            stopperY.Remove(l.Y);
                        }
                        if (l.Status != 4)
                        {
                            l.Status = 4;
                            l.Lemmingcolor = Color.Blue;
                            stopperButton.Checked = true;
                            umbrellaButton.Hide();
                        }
                        else
                        {
                            l.Status = 1;
                            l.Lemmingcolor = lemmingcolor;
                        }
                    }
                }
            }
        }
    }
}
