﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;

namespace Makro
{
    public partial class Anzeige : UserControl
    {    
        #region Methoden
        /// <summary>
        /// Konstuktor
        /// </summary>
        public Anzeige()
        {
            InitializeComponent();
            
            co_makroausloeseradd.Items.Add("Alt");
            co_makroausloeseradd.Items.Add("Control");
            co_makroausloeseradd.Items.Add("Shift");
            co_makroausloeseradd.Items.Add("Back");
            co_makroausloeseradd.Items.Add("Pause");
            co_makroausloeseradd.Items.Add("CapsLock");
            co_makroausloeseradd.Items.Add("Capital");
            co_makroausloeseradd.Items.Add("Delete");
            co_makroausloeseradd.Items.Add("Up");
            co_makroausloeseradd.Items.Add("Down");
            co_makroausloeseradd.Items.Add("Left");
            co_makroausloeseradd.Items.Add("Right");
            co_makroausloeseradd.Items.Add("End");
            co_makroausloeseradd.Items.Add("Enter");
            co_makroausloeseradd.Items.Add("Return");
            co_makroausloeseradd.Items.Add("Escape");
            co_makroausloeseradd.Items.Add("Help");
            co_makroausloeseradd.Items.Add("Home");
            co_makroausloeseradd.Items.Add("Insert");
            co_makroausloeseradd.Items.Add("NumLock");
            co_makroausloeseradd.Items.Add("Next");
            co_makroausloeseradd.Items.Add("PageDown");
            co_makroausloeseradd.Items.Add("Prior");
            co_makroausloeseradd.Items.Add("PageUp");
            co_makroausloeseradd.Items.Add("Print");
            co_makroausloeseradd.Items.Add("PrintScreen");
            co_makroausloeseradd.Items.Add("Snapshot");
            co_makroausloeseradd.Items.Add("Scroll");
            co_makroausloeseradd.Items.Add("Tab");
            co_makroausloeseradd.Items.Add("F1");
            co_makroausloeseradd.Items.Add("F2");
            co_makroausloeseradd.Items.Add("F3");
            co_makroausloeseradd.Items.Add("F4");
            co_makroausloeseradd.Items.Add("F5");
            co_makroausloeseradd.Items.Add("F6");
            co_makroausloeseradd.Items.Add("F7");
            co_makroausloeseradd.Items.Add("F8");
            co_makroausloeseradd.Items.Add("F9");
            co_makroausloeseradd.Items.Add("F10");
            co_makroausloeseradd.Items.Add("F11");
            co_makroausloeseradd.Items.Add("F12");
            co_makroausloeseradd.Items.Add("F13");
            co_makroausloeseradd.Items.Add("F14");
            co_makroausloeseradd.Items.Add("F15");
            co_makroausloeseradd.Items.Add("F16");
            co_makroausloeseradd.Items.Add("Add");
            co_makroausloeseradd.Items.Add("Subtract");
            co_makroausloeseradd.Items.Add("Multiply");
            co_makroausloeseradd.Items.Add("Divide");
            co_makroausloeseradd.Items.Add("Space");
            co_makroausloeseradd.Items.Add("D0");
            co_makroausloeseradd.Items.Add("NumPad0");
            co_makroausloeseradd.Items.Add("D1");
            co_makroausloeseradd.Items.Add("NumPad1");
            co_makroausloeseradd.Items.Add("D2");
            co_makroausloeseradd.Items.Add("NumPad2");
            co_makroausloeseradd.Items.Add("D3");
            co_makroausloeseradd.Items.Add("NumPad3");
            co_makroausloeseradd.Items.Add("D4");
            co_makroausloeseradd.Items.Add("NumPad4");
            co_makroausloeseradd.Items.Add("D5");
            co_makroausloeseradd.Items.Add("NumPad5");
            co_makroausloeseradd.Items.Add("D6");
            co_makroausloeseradd.Items.Add("NumPad6");
            co_makroausloeseradd.Items.Add("D7");
            co_makroausloeseradd.Items.Add("NumPad7");
            co_makroausloeseradd.Items.Add("D8");
            co_makroausloeseradd.Items.Add("NumPad8");
            co_makroausloeseradd.Items.Add("D9");
            co_makroausloeseradd.Items.Add("NumPad9");
            co_makroausloeseradd.Items.Add("Decimal");
            co_makroausloeseradd.Items.Add("Separator");

            co_makrotasten.Items.Add("Alt");
            co_makrotasten.Items.Add("Control");
            co_makrotasten.Items.Add("Shift");
            co_makrotasten.Items.Add("Back");
            co_makrotasten.Items.Add("Pause");
            co_makrotasten.Items.Add("CapsLock");
            co_makrotasten.Items.Add("Capital");
            co_makrotasten.Items.Add("Delete");
            co_makrotasten.Items.Add("Up");
            co_makrotasten.Items.Add("Down");
            co_makrotasten.Items.Add("Left");
            co_makrotasten.Items.Add("Right");
            co_makrotasten.Items.Add("End");
            co_makrotasten.Items.Add("Enter");
            co_makrotasten.Items.Add("Return");
            co_makrotasten.Items.Add("Escape");
            co_makrotasten.Items.Add("Help");
            co_makrotasten.Items.Add("Home");
            co_makrotasten.Items.Add("Insert");
            co_makrotasten.Items.Add("NumLock");
            co_makrotasten.Items.Add("Next");
            co_makrotasten.Items.Add("PageDown");
            co_makrotasten.Items.Add("Prior");
            co_makrotasten.Items.Add("PageUp");
            co_makrotasten.Items.Add("Print");
            co_makrotasten.Items.Add("PrintScreen");
            co_makrotasten.Items.Add("Snapshot");
            co_makrotasten.Items.Add("Scroll");
            co_makrotasten.Items.Add("Tab");
            co_makrotasten.Items.Add("F1");
            co_makrotasten.Items.Add("F2");
            co_makrotasten.Items.Add("F3");
            co_makrotasten.Items.Add("F4");
            co_makrotasten.Items.Add("F5");
            co_makrotasten.Items.Add("F6");
            co_makrotasten.Items.Add("F7");
            co_makrotasten.Items.Add("F8");
            co_makrotasten.Items.Add("F9");
            co_makrotasten.Items.Add("F10");
            co_makrotasten.Items.Add("F11");
            co_makrotasten.Items.Add("F12");
            co_makrotasten.Items.Add("F13");
            co_makrotasten.Items.Add("F14");
            co_makrotasten.Items.Add("F15");
            co_makrotasten.Items.Add("F16");
            co_makrotasten.Items.Add("Add");
            co_makrotasten.Items.Add("Subtract");
            co_makrotasten.Items.Add("Multiply");
            co_makrotasten.Items.Add("Divide");
            co_makrotasten.Items.Add("Space");
            co_makrotasten.Items.Add("D0");
            co_makrotasten.Items.Add("NumPad0");
            co_makrotasten.Items.Add("D1");
            co_makrotasten.Items.Add("NumPad1");
            co_makrotasten.Items.Add("D2");
            co_makrotasten.Items.Add("NumPad2");
            co_makrotasten.Items.Add("D3");
            co_makrotasten.Items.Add("NumPad3");
            co_makrotasten.Items.Add("D4");
            co_makrotasten.Items.Add("NumPad4");
            co_makrotasten.Items.Add("D5");
            co_makrotasten.Items.Add("NumPad5");
            co_makrotasten.Items.Add("D6");
            co_makrotasten.Items.Add("NumPad6");
            co_makrotasten.Items.Add("D7");
            co_makrotasten.Items.Add("NumPad7");
            co_makrotasten.Items.Add("D8");
            co_makrotasten.Items.Add("NumPad8");
            co_makrotasten.Items.Add("D9");
            co_makrotasten.Items.Add("NumPad9");
            co_makrotasten.Items.Add("Decimal");
            co_makrotasten.Items.Add("Separator");
        }
        //*************************************GET SET********************************
        #region Get Set

        public string ms
        {
            get
            {
                return num_ms.Value.ToString();
            }

            set
            {
                num_ms.Value = decimal.Parse(value);
            }
        }

        #endregion
        //***********************************GET SET ENDE*****************************

        /// <summary>
        /// Liest den ausgewählten Index von co_submakro aus und befüllt co_submakro mit den Tastenkombinationen
        /// welche durch die ausgewählten Tastenkombination ausgelöst werden
        /// </summary>
        /// <param name="makroliste"></param>
        public void makroauslesen()
        {
            if (Program.DATEI.Liste.Count != 0)
            {
                co_submakro.Items.Clear();
                int i_index = co_makroausloeser.SelectedIndex;
                if (i_index < 0)
                    i_index = 0;
                for (int i = 1; i < Program.DATEI.Liste[i_index].GetLength(0); i += 2)
                {
                    co_submakro.Items.Add(Program.DATEI.Liste[i_index][i] + " ms " + Program.DATEI.Liste[i_index][i + 1]);
                }
            }
        }
        /// <summary>
        /// Liest die übergebene Liste aus und befühlt co_makroausloeser mit den Elementen [0] der Arrays in der
        /// Liste
        /// </summary>
        /// <param name="makroliste"></param>
        public void makrolisteladen()
        {
            if (Program.DATEI.Liste.Count != 0)
            {
                co_makroausloeser.Items.Clear();
                foreach (string[] sa in Program.DATEI.Liste)
                {
                    co_makroausloeser.Items.Add(sa[0]);
                }
            }
            makroauslesen();
        }

        //***************************MAKROAUSLÖSER*****************************
        #region Makroausloeser bearbeiten
        /// <summary>
        /// Setzt die Zeichenkombination welche das Makro auslöst ändern 
        /// (das im co_makroausloeser ausgewähltes element wird geändert)
        /// </summary>
        /// <param name="s"></param>
        public void makroausloeseraendern(string s)
        {
            co_makroausloeser.Items[co_makroausloeser.SelectedIndex] = s;
            Program.DATEI.Liste[co_makroausloeser.SelectedIndex][0] = s;
        }
        /// <summary>
        /// Fügt eine neue Zeichenkombination welche ein Makro auslöst co_makroausloeser hinzu
        /// </summary>
        /// <param name="s"></param>
        public void addmakroausloeser(string s)
        {
            co_makroausloeser.Items.Add(s);
            string[] sa = new string[] {s};
            Program.DATEI.Liste.Add(sa);
        }
        #endregion
//***************************SUBMAKRO************************************
        #region Submakro bearbeiten

        public void submakroaendern(string sms, string s)
        {
            co_submakro.Items[co_submakro.SelectedIndex] =  sms + " ms " + s;
            Program.DATEI.Liste[co_makroausloeser.SelectedIndex][(co_submakro.SelectedIndex * 2)+ 1] = sms;
            Program.DATEI.Liste[co_makroausloeser.SelectedIndex][(co_submakro.SelectedIndex * 2) + 2] = s;
        }
        public void addsubmakro(string sms,string s)
        {
            co_submakro.Items.Add(sms + " ms " + s);
            ArrayList sal = new ArrayList();
            foreach (string szwischen in Program.DATEI.Liste[co_makroausloeser.SelectedIndex])
            {
                sal.Add(szwischen);
            }
            sal.Add(sms);
            sal.Add(s);
            string[] szsa = new string[sal.Count];
            szsa = (string[])sal.ToArray(typeof(string));
            Program.DATEI.Liste[co_makroausloeser.SelectedIndex] = szsa;
        }
        #endregion

        #endregion
        #region Events
        //*****************************BUTTONS***********************************
        private void btn_addmakro_Click(object sender, EventArgs e)
        {
            addmakroausloeser(co_makroausloeseradd.Text);
        }

        private void btn_makroausloeser_change_Click(object sender, EventArgs e)
        {
            makroausloeseraendern(co_makroausloeseradd.Text);
        }

        private void btn_delmakro_Click(object sender, EventArgs e)
        {
            Program.DATEI.Liste.RemoveAt(co_makroausloeser.SelectedIndex);
            co_makroausloeser.Items.RemoveAt(co_makroausloeser.SelectedIndex);
        }

        private void btn_addsubmakro_Click(object sender, EventArgs e)
        {
            addsubmakro(num_ms.Value.ToString(), co_makrotasten.Text);
        }

        private void btn_submakro_change_Click(object sender, EventArgs e)
        {
            submakroaendern(num_ms.Value.ToString(), co_makrotasten.Text);
        }

        private void btn_delsubmakro_Click(object sender, EventArgs e)
        {
            string[] sa = new string[co_submakro.Items.Count - 1];
            int a = 0;
            for (int i = 0;i<co_submakro.Items.Count - 1;i++)
            {
                if(i != co_submakro.SelectedIndex)
                {
                    sa[a] = Program.DATEI.Liste[co_makroausloeser.SelectedIndex][i];
                    a++;
                }
            }
            Program.DATEI.Liste[co_makroausloeser.SelectedIndex] = sa;
            co_submakro.Items.RemoveAt(co_submakro.SelectedIndex);
        }
        //*****************************BUTTONS ENDE***********************************
        private void co_makroausloeser_SelectedIndexChanged(object sender, EventArgs e)
        {
            makroauslesen();
            if(co_submakro.Items.Count > 0)
                co_submakro.SelectedIndex = 0;
        }
        #endregion

        private void co_submakro_SelectedIndexChanged(object sender, EventArgs e)
        {
            string[] zwischenarray = co_submakro.SelectedItem.ToString().Split(new string[] {" ms "},StringSplitOptions.RemoveEmptyEntries);
            ms = zwischenarray[0];
            co_makrotasten.Text = zwischenarray[1];
        }
    }
}