﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Text;
using System.Xml.Serialization;
using System.IO;

namespace Makro
{
    [Serializable]
    public class Einstellungen
    {
        private const string EINSTELLUNGEN = "\\Einstellung.xml";
        private string s_makrodatei; //Inhalt von tb_datei
        private string s_start_stop; //Inhalt von tb_start_stop
        private string s_ms; //Inhalt von tb_ms

        private bool b_nacheinander; //Zustand von cb_makronacheinander
        private bool b_ms; //Zustand von cb_ms

        //********************GET SET START*************************
        #region GET SET
        public string smakrodatei
        {
            get
            {
                return s_makrodatei;
            }
            set
            {
                s_makrodatei = value;
            }
        }

        public string sstart_stop
        {
            get
            {
                return s_start_stop;
            }
            set
            {
                s_start_stop = value;
            }
        }

        public string sms
        {
            get
            {
                return s_ms;
            }
            set
            {
                s_ms = value;
            }
        }

        public bool bnacheinander
        {
            get
            {
                return b_nacheinander;
            }
            set
            {
                b_nacheinander = value;
            }
        }

        public bool bms
        {
            get
            {
                return b_ms;
            }
            set
            {
                b_ms = value;
            }
        }
        #endregion
        //********************GET SET ENDE*************************

        public Einstellungen()
        {
            s_makrodatei = s_ms = s_start_stop = string.Empty;
            b_ms = b_nacheinander = false;
        }

        public static Einstellungen LoadValues()
        {
            Einstellungen zwischenklasse = new Einstellungen();
            if (File.Exists(Application.StartupPath + EINSTELLUNGEN))
            {
                FileInfo finfo = new FileInfo(Application.StartupPath + EINSTELLUNGEN);
                XmlSerializer xml = new XmlSerializer(typeof(Einstellungen));
                FileStream fs = File.Open(Application.StartupPath + EINSTELLUNGEN, FileMode.Open, FileAccess.Read);
                try
                {
                    zwischenklasse = (Einstellungen)xml.Deserialize(fs);
                }
                catch { }
                finally
                {
                    fs.Close();
                }
            }
            return zwischenklasse;
        }

        public void SaveValues()
        {
            XmlSerializer xml = new XmlSerializer(typeof(Einstellungen));
            FileStream fs = File.Open(Application.StartupPath + EINSTELLUNGEN, FileMode.Create, FileAccess.Write);
            try
            {
                xml.Serialize(fs, this);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            finally
            {
                fs.Close();
            }
        }
    }
}
